<?php
define('FPDF_FONTPATH','fpdf/font/');
//define('FPDF_FONTPATH','TCPDF-main/font/');
define('EURO', chr(128) );
require 'pdf_js.php';

############## VARIABLE PARA TAMAÑO DE LOGO ##############
$GLOBALS['logo1_vertical_X'] = 6;
$GLOBALS['logo1_vertical_Y'] = 4;
$GLOBALS['logo1_vertical'] = 40;

$GLOBALS['logo2_vertical_X'] = 2;
$GLOBALS['logo2_vertical_Y'] = 4;
$GLOBALS['logo2_vertical'] = 22;

$GLOBALS['logo1_horizontal_X'] = 40;
$GLOBALS['logo1_horizontal_Y'] = 2;
$GLOBALS['logo1_horizontal'] = 60;

$GLOBALS['logo2_horizontal_X'] = 10;
$GLOBALS['logo2_horizontal_Y'] = 2;
$GLOBALS['logo2_horizontal'] = 26;

$GLOBALS['logo1_letter_X'] = 18;
$GLOBALS['logo1_letter_Y'] = 2;
$GLOBALS['logo1_letter'] = 56;

$GLOBALS['logo2_letter_X'] = 20;
$GLOBALS['logo2_letter_Y'] = 2;
$GLOBALS['logo2_letter'] = 24;
############## VARIABLE PARA TAMAÑO DE LOGO ##############
 
//class PDF extends FPDF{ 
class PDF extends PDF_JavaScript
{
var $widths;
var $aligns;
var $flowingBlockAttr;
//$Tamhoriz = 88;


########################## FUNCION PARA MOSTRAR EL FOOTER ########################
//Pie de página
function Footer2()
{
  //Posición: a 2 cm del final
  $this->Ln();
  $this->SetY(-12);
  $this->SetFont('Courier','B',10);
  //Número de página
  $this->Cell(190,5,'SOFT RESTAURANT (Administración, Compras y ventas)','T',0,'L');
  $this->AliasNbPages();
  $this->Cell(0,5,'Pagina '.$this->PageNo(),'T',1,'R');

  if($this->page>0)
{
        // Page footer
        $this->_endpage();
    }

} 
######################## FUNCION PARA MOSTRAR EL FOOTER ########################


######################## FUNCION PARA CARGAR AUTOPRINTF ########################
function AutoPrint($dialog=false)
{
    //Open the print dialog or start printing immediately on the standard printer
    $param=($dialog ? 'true' : 'false');
    $script="print($param);";
    $this->IncludeJS($script);
}

function AutoPrintToPrinter($server, $printer, $dialog=false)
{
    //Print on a shared printer (requires at least Acrobat 6)
    $script = "var pp = getPrintParams();";
    if($dialog)
        $script .= "pp.interactive = pp.constants.interactionLevel.full;";
    else
        $script .= "pp.interactive = pp.constants.interactionLevel.automatic;";
    $script .= "pp.printerName = '\\\\\\\\".$server."\\\\".$printer."';";
    $script .= "print(pp);";
    $this->IncludeJS($script);
}
######################## FUNCION PARA CARGAR AUTOPRINT ########################




############################### REPORTES DE ADMINISTRACION ##############################

########################## FUNCION LISTAR PROVINCIAS ##############################
function TablaListarProvincias()
   {

    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE PROVINCIAS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(180,8,'NOMBRE DE PROVINCIA',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarProvincias();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,180));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["provincia"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PROVINCIAS ##############################


########################## FUNCION LISTAR DEPARTAMENTOS ##############################
function TablaListarDepartamentos()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE DEPARTAMENTOS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(80,8,'NOMBRE DE PROVINCIA',1,0,'C', True);
    $this->Cell(95,8,'NOMBRE DE DEPARTAMENTO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarDepartamentos();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,80,95));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["provincia"]),utf8_decode($reg[$i]["departamento"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DEPARTAMENTOS ##############################

########################## FUNCION LISTAR TIPOS DE DOCUMENTOS ##########################
function TablaListarDocumentos()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE DOCUMENTOS TRIBUTARIOS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(50,8,'NOMBRE DE DOCUMENTO',1,0,'C', True);
    $this->Cell(125,8,'DESCRIPCIÓN DE DOCUMENTO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarDocumentos();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,50,125));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["documento"]),utf8_decode($reg[$i]["descripcion"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TIPOS DE DOCUMENTOS ##########################

########################## FUNCION LISTAR TIPOS DE MONEDA ##############################
function TablaListarTiposMonedas()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE TIPOS DE MONEDA',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(85,8,'NOMBRE DE MONEDA',1,0,'C', True);
    $this->Cell(45,8,'SIGLAS',1,0,'C', True);
    $this->Cell(45,8,'SIMBOLO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarTipoMoneda();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,85,45,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["moneda"]),utf8_decode($reg[$i]["siglas"]),utf8_decode($reg[$i]["simbolo"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TIPOS DE MONEDA ##############################

########################## FUNCION LISTAR TIPOS DE CAMBIO ##############################
function TablaListarTiposCambio()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE TIPOS DE CAMBIO',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIÓN DE CAMBIO',1,0,'C', True);
    $this->Cell(35,8,'MONTO DE CAMBIO',1,0,'C', True);
    $this->Cell(35,8,'TIPO DE MONEDA',1,0,'C', True);
    $this->Cell(35,8,'FECHA DE INGRESO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarTipoCambio();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,70,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["descripcioncambio"]),utf8_decode($reg[$i]["montocambio"]),utf8_decode($reg[$i]['moneda']."/".$reg[$i]['siglas']),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechacambio'])))));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TIPOS DE CAMBIO ##############################

########################## FUNCION LISTAR IMPUESTOS ##############################
function TablaListarImpuestos()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE IMPUESTOS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(70,8,'NOMBRE DE IMPUESTO',1,0,'C', True);
    $this->Cell(35,8,'VALOR(%)',1,0,'C', True);
    $this->Cell(35,8,'STATUS',1,0,'C', True);
    $this->Cell(35,8,'FECHA DE INGRESO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarImpuestos();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,70,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["nomimpuesto"]),utf8_decode($reg[$i]["valorimpuesto"]),utf8_decode($reg[$i]['statusimpuesto']),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaimpuesto'])))));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR IMPUESTOS ##############################

########################## FUNCION LISTAR SUCURSALES ##############################
function TablaListarSucursales()
   {
    
    ################################# MEMBRETE LEGAL #################################
    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE SUCURSALES',0,0,'C');
    
    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE REGISTRO',1,0,'C', True);
    $this->Cell(60,8,'NOMBRE DE SUCURSAL',1,0,'C', True);
    $this->Cell(25,8,'PROVINCIA',1,0,'C', True);
    $this->Cell(30,8,'DEPARTAMENTO',1,0,'C', True);
    $this->Cell(55,8,'DIRECCIÓN',1,0,'C', True);
    $this->Cell(35,8,'CORREO ELECT',1,0,'C', True);
    $this->Cell(35,8,'Nº DE TELÉFONO',1,0,'C', True);
    $this->Cell(45,8,'ENCARGADO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarSucursales();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,60,25,30,55,35,35,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["cuitsucursal"]),portales(utf8_decode($reg[$i]["nomsucursal"])),portales(utf8_decode($reg[$i]['id_provincia'] == '0' ? "********" : $reg[$i]['provincia'])),portales(utf8_decode($reg[$i]['id_departamento'] == '0' ? "********" : $reg[$i]['departamento'])),portales(utf8_decode($reg[$i]["direcsucursal"])),portales(utf8_decode($reg[$i]["correosucursal"])),utf8_decode($reg[$i]["tlfsucursal"]),portales(utf8_decode($reg[$i]["nomencargado"]))));
  }
   }


    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR SUCURSALES ##############################

########################## FUNCION LISTAR CATEGORIAS ##############################
function TablaListarCategorias()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE CATEGORIAS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(175,8,'NOMBRE DE CATEGORIA',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarCategorias();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,175));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["nomcategoria"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CATEGORIAS ##############################

########################## FUNCION LISTAR MEDIDAS ##############################
function TablaListarMedidas()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE MEDIDAS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(180,8,'NOMBRE DE MEDIDA',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarMedidas();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,180));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["nommedida"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR MEDIDAS ##############################

########################## FUNCION LISTAR SALSAS ##############################
function TablaListarSalsas()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE SALSAS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(175,8,'NOMBRE DE SALSA',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarSalsas();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,175));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["nomsalsa"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR SALSAS ##############################

########################## FUNCION LISTAR SALAS ##############################
function TablaListarSalas()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE SALAS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(175,8,'NOMBRE DE SALA',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarSalas();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,175));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["nomsala"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR SALAS ##############################

########################## FUNCION LISTAR MESAS ##############################
function TablaListarMesas()
   {
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE MESAS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(70,8,'NOMBRE DE SALA',1,0,'C', True);
    $this->Cell(70,8,'NOMBRE DE MESA',1,0,'C', True);
    $this->Cell(40,8,'Nº DE PERSONAS',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarMesas();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,70,70,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["nomsala"]),utf8_decode($reg[$i]["nommesa"]),utf8_decode($reg[$i]["puestos"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR MESAS ##############################
     
########################## FUNCION LISTAR USUARIOS ##############################
function TablaListarUsuarios()
   {

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 
    
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE USUARIOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(40,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(30,8,'Nº DOCUMENTO',1,0,'C', True);
    $this->Cell(60,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
    $this->Cell(25,8,'SEXO',1,0,'C', True);
    $this->Cell(35,8,'Nº DE TELÉFONO',1,0,'C', True);
    $this->Cell(50,8,'EMAIL',1,0,'C', True);
    $this->Cell(40,8,'USUARIO',1,0,'C', True);
    $this->Cell(40,8,'NIVEL',1,1,'C', True);

    $tra = new Login();
    $reg = $tra->ListarUsuarios();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,40,30,60,25,35,50,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        portales(utf8_decode($sucursal = ($reg[$i]["codsucursal"] == "" ? "**********" : $reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"]))),
        utf8_decode($reg[$i]["dni"]),
        utf8_decode($reg[$i]["nombres"]),
        utf8_decode($reg[$i]["sexo"]),
        utf8_decode($reg[$i]["telefono"]),
        utf8_decode($reg[$i]["email"]),
        utf8_decode($reg[$i]["usuario"]),
        utf8_decode($reg[$i]["nivel"])));
        }
    }

    } else {

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DOCUMENTO',1,0,'C', True);
    $this->Cell(80,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
    $this->Cell(25,8,'SEXO',1,0,'C', True);
    $this->Cell(45,8,'Nº DE TELÉFONO',1,0,'C', True);
    $this->Cell(60,8,'EMAIL',1,0,'C', True);
    $this->Cell(40,8,'USUARIO',1,0,'C', True);
    $this->Cell(40,8,'NIVEL',1,1,'C', True);

    $tra = new Login();
    $reg = $tra->ListarUsuarios();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,80,25,45,60,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["dni"]),utf8_decode($reg[$i]["nombres"]),utf8_decode($reg[$i]["sexo"]),utf8_decode($reg[$i]["telefono"]),utf8_decode($reg[$i]["email"]),utf8_decode($reg[$i]["usuario"]),utf8_decode($reg[$i]["nivel"])));
            }
        }
    }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR USUARIOS ##############################


########################## FUNCION LISTAR LOGS DE USUARIOS ##############################
 function TablaListarLogs()
   {
    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE LOGS DE ACCESO DE USUARIOS',0,0,'C');
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(10,8,'N°',1,0,'C', True);
    $this->Cell(35,8,'IP EQUIPO',1,0,'C', True);
    $this->Cell(45,8,'TIEMPO ENTRADA',1,0,'C', True);
    $this->Cell(145,8,'NAVEGADOR DE ACCESO',1,0,'C', True);
    $this->Cell(60,8,'PÁGINAS DE ACCESO',1,0,'C', True);
    $this->Cell(35,8,'USUARIO',1,1,'C', True);
    

    $tra = new Login();
    $reg = $tra->ListarLogs();

    if($reg==""){
    echo "";      
    } else {
    
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,45,145,60,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["ip"]),utf8_decode($reg[$i]["tiempo"]),utf8_decode($reg[$i]["detalles"]),utf8_decode($reg[$i]["paginas"]),utf8_decode($reg[$i]["usuario"])));
  }
   }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
   }
########################## FUNCION LISTAR LOGS DE USUARIOS ##############################

############################ REPORTES DE ADMINISTRACION #############################







































############################### REPORTES DE MANTENIMIENTO ##############################

########################## FUNCION LISTAR CLIENTES ##############################
function TablaListarClientes()
   {
    
    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,10,'LISTADO GENERAL DE CLIENTES',0,0,'C');
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(35,8,'Nº DE DOCUMENTO',1,0,'C', True);
    $this->Cell(60,8,'NOMBRES/RAZÓN SOCIAL',1,0,'C', True);
    $this->Cell(35,8,'Nº DE TELEFONO',1,0,'C', True);
    $this->Cell(75,8,'DIRECCIÓN DOMICILIARIA',1,0,'C', True);
    $this->Cell(20,8,'CRÉDITO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarClientes();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,35,60,35,75,20));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["tipocliente"]),utf8_decode($reg[$i]["documento"]." ".$reg[$i]["dnicliente"]),portales(utf8_decode($reg[$i]["nomcliente"])),utf8_decode($reg[$i]['tlfcliente'] == '' ? "*********" : $reg[$i]['tlfcliente']),utf8_decode($reg[$i]["provincia"]." ".$reg[$i]["departamento"]." ".$reg[$i]["direccliente"]),utf8_decode($reg[$i]["limitecredito"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CLIENTES ##############################

########################## FUNCION LISTAR PROVEEDORES ##############################
function TablaListarProveedores()
   {
    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,10,'LISTADO GENERAL DE PROVEEDORES',0,0,'C');
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(40,8,'Nº DE DOCUMENTO',1,0,'C', True);
    $this->Cell(60,8,'NOMBRE DE PROVEEDOR',1,0,'C', True);
    $this->Cell(35,8,'Nº DE TELEFONO',1,0,'C', True);
    $this->Cell(75,8,'DIRECCIÓN DOMICILIARIA',1,0,'C', True);
    $this->Cell(35,8,'VENDEDOR',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarProveedores();

    if($reg==""){
    echo "";      
    } else {

 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,60,35,75,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["documento"]." ".$reg[$i]["cuitproveedor"]),portales(utf8_decode($reg[$i]["nomproveedor"])),utf8_decode($reg[$i]["tlfproveedor"]),utf8_decode($reg[$i]["provincia"]." ".$reg[$i]["departamento"]." ".$reg[$i]["direcproveedor"]),utf8_decode($reg[$i]["vendedor"])));
  }
   }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PROVEEDORES ##############################













########################## FUNCION LISTAR INGREDIENTES ##############################
function TablaListarIngredientes()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarIngredientes(); 

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,10,'LISTADO GENERAL DE INGREDIENTES EN ALMACEN',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(20,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(55,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(30,8,'MEDIDA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO VENTA',1,0,'C', True);
    $this->CellFitSpace(25,8,"P.V EXT",1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->CellFitSpace(15,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,55,30,30,30,25,25,15,15));

    $a=1;
    $TotalCompra=0;
    $TotalVenta=0;
    $TotalMoneda=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    $simbolo2 = ($reg[$i]['simbolo2'] == "" ? "" : $reg[$i]['simbolo2']);
    $moneda = (empty($reg[$i]['montocambio']) ? "0.00" : number_format($reg[$i]['precioventa'] / $reg[$i]['montocambio'], 2, '.', ','));

    $TotalCompra+=$reg[$i]['preciocompra'];
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['descingrediente']/100;
    $TotalMoneda += (empty($reg[$i]['montocambio']) ? "0.00" : number_format($reg[$i]['precioventa'] / $reg[$i]['montocambio'], 2, '.', ','));

    //$TotalMoneda+= ($cambio == 0 ? "0" : $reg[$i]['precioventa']/$cambio[0]['montocambio']);
    $TotalArticulos+=$reg[$i]['cantingrediente'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['codingrediente']),
        portales(utf8_decode($reg[$i]["nomingrediente"])),
        utf8_decode($reg[$i]["nommedida"]),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', ',')),
        utf8_decode($simbolo2.number_format($moneda, 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantingrediente'], 2, '.', ',')),
        utf8_decode($reg[$i]['ivaingrediente'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['descingrediente'], 2, '.', ','))));
  }
   
    $this->Cell(120,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalCompra, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo2.number_format($TotalMoneda, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR INGREDIENTES ##############################

####################### FUNCION LISTAR INGREDIENTES EN STOCK MINIMO ##############################
function TablaListarIngredientesMinimo()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarIngredientesMinimo(); 

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,10,'LISTADO GENERAL DE INGREDIENTES EN STOCK MINIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(12,8,'Nº',1,0,'C', True);
    $this->Cell(20,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(55,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(30,8,'MEDIDA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(28,8,'STOCK MINIMO',1,0,'C', True);
    $this->CellFitSpace(15,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(12,20,55,30,30,30,25,28,15,15));

    $a=1;
    $TotalCompra=0;
    $TotalVenta=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);  
    $TotalCompra+=$reg[$i]['preciocompra'];
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['descingrediente']/100;
    $TotalArticulos+=number_format($reg[$i]['cantingrediente'], 2, '.', ',');

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['codingrediente']),
        portales(utf8_decode($reg[$i]["nomingrediente"])),
        utf8_decode($reg[$i]["nommedida"]),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantingrediente'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['stockminimo'], 2, '.', ',')),
        utf8_decode($reg[$i]['ivaingrediente'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['descingrediente'], 2, '.', ','))));
  }
   
    $this->Cell(117,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalCompra, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR INGREDIENTES EN STOCK MINIMO ##############################

####################### FUNCION LISTAR INGREDIENTES EN STOCK MAXIMO ##############################
function TablaListarIngredientesMaximo()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarIngredientesMaximo(); 

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,10,'LISTADO GENERAL DE INGREDIENTES EN STOCK MAXIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(12,8,'Nº',1,0,'C', True);
    $this->Cell(20,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(55,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(30,8,'MEDIDA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(28,8,'STOCK MAXIMO',1,0,'C', True);
    $this->CellFitSpace(15,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(12,20,55,30,30,30,25,28,15,15));

    $a=1;
    $TotalCompra=0;
    $TotalVenta=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $TotalCompra+=$reg[$i]['preciocompra'];
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['descingrediente']/100;
    $TotalArticulos+=number_format($reg[$i]['cantingrediente'], 2, '.', ',');

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['codingrediente']),
        portales(utf8_decode($reg[$i]["nomingrediente"])),
        utf8_decode($reg[$i]["nommedida"]),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantingrediente'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['stockmaximo'], 2, '.', ',')),
        utf8_decode($reg[$i]['ivaingrediente'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['descingrediente'], 2, '.', ','))));
  }
   
    $this->Cell(117,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalCompra, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR INGREDIENTES EN STOCK MAXIMO ##############################

######################## FUNCION LISTAR INGREDIENTES VENDIDOS #########################
function TablaListarIngredientesVendidos()
   {
    
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarIngredientesVendidos(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE INGREDIENTES VENDIDOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(15,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(90,8,'DESCRIPCIÓN DE INGREDIENTE',1,0,'C', True);
    $this->Cell(30,8,'MEDIDA',1,0,'C', True);
    $this->Cell(40,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,'VENDIDO',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(40,8,'MONTO TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,15,90,30,40,25,20,30,30,40));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $VendidosTotal=0;
    $TotalDescuento=0;
    $TotalImpuesto=0;
    $PagoTotal=0;

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal+=$reg[$i]['precioventa'];
    $ExisteTotal+=$reg[$i]['cantingrediente'];
    $VendidosTotal+=$reg[$i]['cantidad'];

    $Descuento = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $CalculoDescuento = $PrecioDescuento*$reg[$i]['cantidad'];
    $PrecioFinal = $reg[$i]['precioventa']-$PrecioDescuento;

    $ivg = $reg[$i]['ivaproducto']/100;
    $SubtotalImpuesto = $PrecioFinal*$ivg;
    $CalculoImpuesto = $SubtotalImpuesto*$reg[$i]['cantidad'];

    $TotalDescuento+=$CalculoDescuento; 
    $TotalImpuesto+=$CalculoImpuesto; 
    $PagoTotal+=$PrecioFinal*$reg[$i]['cantidad']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["codproducto"]),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($reg[$i]["nommedida"]),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantingrediente'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoImpuesto, 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoDescuento, 2, '.', ',')),
        utf8_decode($simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 2, '.', ','))));
  }
   }
   
    $this->Cell(150,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PrecioTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode(number_format($VendidosTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR INGREDIENTES VENDIDOS ########################

########################## FUNCION LISTAR KARDEX POR INGREDIENTE ########################
function TablaListarKardexIngredientes()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $kardex = new Login();
    $kardex = $kardex->BuscarKardexIngrediente(); 

    $detalle = new Login();
    $detalle = $detalle->DetalleKardexIngrediente();

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,7,'MOVIMIENTO GENERAL POR INGREDIENTE',0,1,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($detalle[0]['documento'])." SUCURSAL: ".utf8_decode($detalle[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($detalle[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($detalle[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(12,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'MOVIMIENTO',1,0,'C', True);
    $this->Cell(20,8,'ENTRADAS',1,0,'C', True);
    $this->Cell(20,8,'SALIDAS',1,0,'C', True);
    $this->Cell(25,8,'DEVOLUCIÓN',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->CellFitSpace(18,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,'PRECIO',1,0,'C', True);
    $this->Cell(40,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(30,8,'FECHA KARDEX',1,1,'C', True);

    if($kardex==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(12,25,20,20,25,25,18,15,30,40,30));

    $TotalEntradas=0;
    $TotalSalidas=0;
    $TotalDevolucion=0;
    $a=1;
    for($i=0;$i<sizeof($kardex);$i++){ 
$simbolo = ($detalle[0]['simbolo'] == "" ? "" : $detalle[0]['simbolo']);
    $TotalEntradas+=$kardex[$i]['entradas'];
    $TotalSalidas+=$kardex[$i]['salidas'];
    $TotalDevolucion+=$kardex[$i]['devolucion'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($kardex[$i]["movimiento"]),
        utf8_decode(number_format($kardex[$i]["entradas"], 2, '.', ',')),
        utf8_decode(number_format($kardex[$i]["salidas"], 2, '.', ',')),
        utf8_decode(number_format($kardex[$i]["devolucion"], 2, '.', ',')),
        utf8_decode(number_format($kardex[$i]['stockactual'], 2, '.', ',')),
        utf8_decode($kardex[$i]['ivaingrediente']),
        utf8_decode(number_format($kardex[$i]['descingrediente'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($kardex[$i]['precio'], 2, '.', ',')),
        utf8_decode($kardex[$i]['documento']." ".$num = ($kardex[$i]['documento'] == 'VENTA' || $kardex[$i]['documento'] == 'DEVOLUCION' ? $kardex[$i]['codproceso'] : "")),
        utf8_decode(date("d-m-Y",strtotime($kardex[$i]['fechakardex'])))));
  }
   }
   
    $this->Cell(325,5,'',0,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(120,5,'DETALLES DEL INGREDIENTE',1,0,'C', True);
    $this->Ln();
    
    $this->Cell(35,5,'CÓDIGO',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode($detalle[0]['codingrediente']),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'DESCRIPCIÓN',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,portales(utf8_decode($detalle[0]['nomingrediente'])),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'ENTRADAS',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode(number_format($TotalEntradas, 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'SALIDAS',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode(number_format($TotalSalidas, 2, '.', ',')),1,0,'C');
    $this->Ln();

    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'DEVOLUCIÓN',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(85,5,utf8_decode(number_format($TotalDevolucion, 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'EXISTENCIA',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode(number_format($detalle[0]['cantingrediente'], 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'PRECIO COMPRA',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode($simbolo.number_format($detalle[0]['preciocompra'], 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'PRECIO VENTA',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode($simbolo.number_format($detalle[0]['precioventa'], 2, '.', ',')),1,0,'C');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR KARDEX POR INGREDIENTE ########################


####################### FUNCION LISTAR KARDEX VALORIZADO DE INGREDIENTES ###########################
function TablaListarKardexValorizadoIngredientes()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarIngredientes(); 

   ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,"LISTADO DE KARDEX VALORIZADO DE INGREDIENTES",0,1,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIÓN DE INGREDIENTE',1,0,'C', True);
    $this->Cell(30,8,'MEDIDA',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(20,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(30,8,'GANANCIAS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,60,30,30,20,15,25,40,40,30));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $PagoTotal=0;
    $compraTotal=0;
    $TotalGanancia=0;
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
$simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    $PrecioTotal+=$reg[$i]['precioventa'];
    $ExisteTotal+=$reg[$i]['cantingrediente'];
    $PagoTotal+=$reg[$i]['precioventa']*$reg[$i]['cantingrediente']-$reg[$i]['descingrediente']/100;
    $compraTotal+=$reg[$i]['preciocompra']*$reg[$i]['cantingrediente'];

    $sumventa = $reg[$i]['precioventa']*$reg[$i]['cantingrediente']-$reg[$i]['descingrediente']/100; 
    $sumcompra = $reg[$i]['preciocompra']*$reg[$i]['cantingrediente'];
    $TotalGanancia+=$sumventa-$sumcompra;  

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["codingrediente"]),
        portales(utf8_decode($reg[$i]["nomingrediente"])),
        utf8_decode($reg[$i]["nommedida"]),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode($reg[$i]['ivaingrediente'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['descingrediente'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantingrediente'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa']*$reg[$i]['cantingrediente']-$reg[$i]['descingrediente']/100, 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra']*$reg[$i]['cantingrediente'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($sumventa-$sumcompra, 2, '.', ','))));
  }
   }
   
    $this->Cell(195,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($compraTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalGanancia, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR KARDEX VALORIZADO DE INGREDIENTES ##########################

























########################## FUNCION LISTAR PRODUCTOS ##############################
function TablaListarProductos()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarProductos(); 

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,10,'LISTADO GENERAL DE PRODUCTOS EN ALMACEN',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(12,8,'Nº',1,0,'C', True);
    $this->Cell(20,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(56,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(28,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(32,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(32,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(25,8,"P.V EXT",1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->CellFitSpace(15,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,1,'C', True);


    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(12,20,56,28,32,32,25,25,15,15));

    $a=1;
    $TotalCompra=0;
    $TotalVenta=0;
    $TotalMoneda=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $simbolo2 = ($reg[$i]['simbolo2'] == "" ? "" : $reg[$i]['simbolo2']);
    $moneda = (empty($reg[$i]['montocambio']) ? "0.00" : number_format($reg[$i]['precioventa'] / $reg[$i]['montocambio'], 2, '.', ','));

    $TotalCompra+=$reg[$i]['preciocompra'];
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['descproducto']/100;
    $TotalMoneda += (empty($reg[$i]['montocambio']) ? "0.00" : number_format($reg[$i]['precioventa'] / $reg[$i]['montocambio'], 2, '.', ','));
    $TotalArticulos+=$reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['codproducto']),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($reg[$i]["nomcategoria"]),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', ',')),
        utf8_decode($simbolo2.number_format($moneda, 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode($reg[$i]['ivaproducto'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['descproducto'], 2, '.', ',')."%")));
  }
   
    $this->Cell(116,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(32,5,utf8_decode($simbolo.number_format($TotalCompra, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(32,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo2.number_format($TotalMoneda, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS ##############################

####################### FUNCION LISTAR PRODUCTOS EN STOCK MINIMO ##############################
function TablaListarProductosMinimo()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarProductosMinimo(); 

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,10,'LISTADO GENERAL DE PRODUCTOS EN STOCK MINIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(12,8,'Nº',1,0,'C', True);
    $this->Cell(18,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(57,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(29,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(28,8,'STOCK MINIMO',1,0,'C', True);
    $this->CellFitSpace(16,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(12,18,57,29,30,30,25,28,16,15));

    $a=1;
    $TotalCompra=0;
    $TotalVenta=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    $TotalCompra+=$reg[$i]['preciocompra'];
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['descproducto']/100;
    $TotalArticulos+=number_format($reg[$i]['existencia'], 2, '.', ',');

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['codproducto']),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($reg[$i]["nomcategoria"]),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['stockminimo'], 2, '.', ',')),
        utf8_decode($reg[$i]['ivaproducto'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['descproducto'], 2, '.', ',')."%")));
  }
   
    $this->Cell(116,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalCompra, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK MINIMO ##############################

####################### FUNCION LISTAR PRODUCTOS EN STOCK MAXIMO ##############################
function TablaListarProductosMaximo()
   {

   	$imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarProductosMaximo();
   
    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,10,'LISTADO GENERAL DE PRODUCTOS EN STOCK MAXIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(12,8,'Nº',1,0,'C', True);
    $this->Cell(18,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(57,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(29,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(28,8,'STOCK MÁXIMO',1,0,'C', True);
    $this->CellFitSpace(16,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(12,18,57,29,30,30,25,28,16,15));

    $a=1;
    $TotalCompra=0;
    $TotalVenta=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $TotalCompra+=$reg[$i]['preciocompra'];
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['descproducto']/100;
    $TotalArticulos+=number_format($reg[$i]['existencia'], 2, '.', ',');

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['codproducto']),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($reg[$i]["nomcategoria"]),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['stockmaximo'], 2, '.', ',')),
        utf8_decode($reg[$i]['ivaproducto'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['descproducto'], 2, '.', ',')."%")));
  }
   
    $this->Cell(116,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalCompra, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK MAXIMO ##############################

######################## FUNCION LISTAR PRODUCTOS VENDIDOS #########################
function TablaListarProductosVendidos()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarProductosVendidos(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE PRODUCTOS VENDIDOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(15,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(90,8,'DESCRIPCIÓN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(40,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,'VENDIDO',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(40,8,'MONTO TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,15,90,30,40,25,20,30,30,40));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $VendidosTotal=0;
    $TotalDescuento=0;
    $TotalImpuesto=0;
    $PagoTotal=0;

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal+=$reg[$i]['precioventa'];
    $ExisteTotal+=$reg[$i]['existencia'];
    $VendidosTotal+=$reg[$i]['cantidad'];

    $Descuento = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $CalculoDescuento = $PrecioDescuento*$reg[$i]['cantidad'];
    $PrecioFinal = $reg[$i]['precioventa']-$PrecioDescuento;

    $ivg = $reg[$i]['ivaproducto']/100;
    $SubtotalImpuesto = $PrecioFinal*$ivg;
    $CalculoImpuesto = $SubtotalImpuesto*$reg[$i]['cantidad'];

    $TotalDescuento+=$CalculoDescuento; 
    $TotalImpuesto+=$CalculoImpuesto; 
    $PagoTotal+=$PrecioFinal*$reg[$i]['cantidad']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["codproducto"]),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($reg[$i]["nomcategoria"]),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoImpuesto, 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoDescuento, 2, '.', ',')),
        utf8_decode($simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 2, '.', ','))));
  }
   }
   
    $this->Cell(150,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PrecioTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode(number_format($VendidosTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR PRODUCTOS VENDIDOS ########################

################### FUNCION LISTAR PRODUCTOS SEGUN MODENA ###################
function TablaListarProductosxMoneda()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $cambio = new Login();
    $cambio = $cambio->BuscarTiposCambios();

    $tra = new Login();
    $reg = $tra->ListarProductos(); 

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,10,'LISTADO DE PRODUCTOS EN ALMACEN POR MONEDA ('.$cambio[0]["moneda"].")",0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(20,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(30,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(30,8,'PRECIO '.$cambio[0]['siglas'],1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->CellFitSpace(20,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,1,'C', True);


    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,65,30,30,30,25,20,25));

    $a=1;
    $TotalVenta=0;
    $TotalMoneda=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['descproducto']/100;
    $TotalMoneda+= ($cambio == 0 ? "0" : $reg[$i]['precioventa']/$cambio[0]['montocambio']);
    $TotalArticulos+=$reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codproducto"]),portales(utf8_decode($reg[$i]["producto"])),utf8_decode($reg[$i]["nomcategoria"]),utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', ',')),$tipo = ($cambio[0]['moneda'] == "EURO" ? chr(128) : $cambio[0]['simbolo']).utf8_decode(number_format($reg[$i]['precioventa']/$cambio[0]['montocambio'], 2, '.', ',')),utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),utf8_decode($reg[$i]['ivaproducto'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),utf8_decode(number_format($reg[$i]['descproducto'], 2, '.', ',')."%")));
  }
   
    $this->Cell(130,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($cambio[0]['simbolo'].number_format($TotalMoneda, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
################## FUNCION LISTAR PRODUCTOS SEGUN MODENA ###################

########################## FUNCION LISTAR KARDEX POR PRODUCTO ########################
function TablaListarKardexProductos()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $kardex = new Login();
    $kardex = $kardex->BuscarKardexProducto(); 

    $detalle = new Login();
    $detalle = $detalle->DetalleKardexProducto();

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,7,'MOVIMIENTO GENERAL POR PRODUCTO',0,1,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }


    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(12,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'MOVIMIENTO',1,0,'C', True);
    $this->Cell(20,8,'ENTRADAS',1,0,'C', True);
    $this->Cell(20,8,'SALIDAS',1,0,'C', True);
    $this->Cell(25,8,'DEVOLUCIÓN',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->CellFitSpace(18,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,'PRECIO',1,0,'C', True);
    $this->Cell(40,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(30,8,'FECHA KARDEX',1,1,'C', True);

    if($kardex==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(12,25,20,20,25,25,18,15,30,40,30));

    $TotalEntradas=0;
    $TotalSalidas=0;
    $TotalDevolucion=0;
    $a=1;
    for($i=0;$i<sizeof($kardex);$i++){ 
    $simbolo = ($detalle[0]['simbolo'] == "" ? "" : $detalle[0]['simbolo']);
    $TotalEntradas+=$kardex[$i]['entradas'];
    $TotalSalidas+=$kardex[$i]['salidas'];
    $TotalDevolucion+=$kardex[$i]['devolucion'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($kardex[$i]["movimiento"]),
        utf8_decode(number_format($kardex[$i]["entradas"], 2, '.', ',')),
        utf8_decode(number_format($kardex[$i]["salidas"], 2, '.', ',')),
        utf8_decode(number_format($kardex[$i]["devolucion"], 2, '.', ',')),
        utf8_decode(number_format($kardex[$i]['stockactual'], 2, '.', ',')),
        utf8_decode($kardex[$i]["ivaproducto"]),
        utf8_decode(number_format($kardex[$i]['descproducto'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($kardex[$i]['precio'], 2, '.', ',')),
        utf8_decode($kardex[$i]['documento']." ".$num = ($kardex[$i]['documento'] == 'VENTA' || $kardex[$i]['documento'] == 'DEVOLUCION' ? $kardex[$i]['codproceso'] : "")),
        utf8_decode(date("d-m-Y",strtotime($kardex[$i]['fechakardex'])))));
  }
   }
   
    $this->Cell(325,5,'',0,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(120,5,'DETALLES DEL PRODUCTO',1,0,'C', True);
    $this->Ln();
    
    $this->Cell(35,5,'CÓDIGO',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode($detalle[0]['codproducto']),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'DESCRIPCIÓN',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,portales(utf8_decode($detalle[0]['producto'])),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'ENTRADAS',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode(number_format($TotalEntradas, 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'SALIDAS',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode(number_format($TotalSalidas, 2, '.', ',')),1,0,'C');
    $this->Ln();

    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'DEVOLUCIÓN',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(85,5,utf8_decode(number_format($TotalDevolucion, 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'EXISTENCIA',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode(number_format($detalle[0]['existencia'], 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'PRECIO COMPRA',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode($simbolo.number_format($detalle[0]['preciocompra'], 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'PRECIO VENTA',1,0,'C', True);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode($simbolo.number_format($detalle[0]['precioventa'], 2, '.', ',')),1,0,'C');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR KARDEX POR PRODUCTO ########################

####################### FUNCION LISTAR KARDEX VALORIZADO DE PRODUCTOS ###########################
function TablaListarKardexValorizadoProductos()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarProductos(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,"LISTADO DE KARDEX VALORIZADO DE PRODUCTOS",0,1,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIÓN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(20,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(30,8,'GANANCIAS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,60,30,30,20,15,25,40,40,30));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $PagoTotal=0;
    $compraTotal=0;
    $TotalGanancia=0;
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $PrecioTotal+=$reg[$i]['precioventa'];
    $ExisteTotal+=$reg[$i]['existencia'];
    $PagoTotal+=$reg[$i]['precioventa']*$reg[$i]['existencia']-$reg[$i]['descproducto']/100;
    $compraTotal+=$reg[$i]['preciocompra']*$reg[$i]['existencia'];

    $sumventa = $reg[$i]['precioventa']*$reg[$i]['existencia']-$reg[$i]['descproducto']/100; 
    $sumcompra = $reg[$i]['preciocompra']*$reg[$i]['existencia'];
    $TotalGanancia+=$sumventa-$sumcompra;  

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["codproducto"]),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($reg[$i]["nomcategoria"]),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode($reg[$i]['ivaproducto'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['descproducto'], 2, '.', ',')."%"),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa']*$reg[$i]['existencia']-$reg[$i]['descproducto']/100, 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra']*$reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($sumventa-$sumcompra, 2, '.', ','))));
  }
   }
   
    $this->Cell(195,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($compraTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalGanancia, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR KARDEX VALORIZADO DE PRODUCTOS ##########################

####################### FUNCION LISTAR KARDEX PRODUCTOS VALORIZADO POR FECHAS ###########################
function TablaListarKardexValorizadoProductosxFechas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarKardexProductosValorizadoxFechas(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,"LISTADO DE KARDEX PRODUCTOS VALORIZADO POR FECHAS",0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(20,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIÓN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,'VENDIDO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(35,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(30,8,'GANANCIAS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,70,30,20,30,25,20,35,35,30));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $VendidosTotal=0;
    $PagoTotal=0;
    $compraTotal=0;
    $TotalGanancia=0;
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $PrecioTotal+=$reg[$i]['precioventa'];
    $ExisteTotal+=$reg[$i]['existencia'];
    $VendidosTotal+=$reg[$i]['cantidad']; 
    $PagoTotal+=$reg[$i]['precioventa']*$reg[$i]['cantidad']-$reg[$i]['descproducto']/100;
    $compraTotal+=$reg[$i]['preciocompra']*$reg[$i]['cantidad'];

    $sumventa = $reg[$i]['precioventa']*$reg[$i]['cantidad']-$reg[$i]['descproducto']/100; 
    $sumcompra = $reg[$i]['preciocompra']*$reg[$i]['cantidad'];
    $TotalGanancia+=$sumventa-$sumcompra;  

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["codproducto"]),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($reg[$i]['codcategoria'] == '' ? "*********" : $reg[$i]["nomcategoria"]),
        utf8_decode(number_format($reg[$i]['descproducto'], 2, '.', ',')."%"),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa']*$reg[$i]['cantidad']-$reg[$i]['descproducto']/100, 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra']*$reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($sumventa-$sumcompra, 2, '.', ','))));
  }
   }
   
    $this->Cell(155,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($PrecioTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode(number_format($VendidosTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($compraTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalGanancia, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR KARDEX PRODUCTOS VALORIZADO POR FECHAS ##########################

########################## FUNCION LISTAR MENU ##############################
function TablaListarMenu()
   {
    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");

    // Inserta un logo en la esquina superior izquierda a 300 ppp
    //$this->Image($logo,50,80,120,0,'PNG');

    $tra = new Login();
    $reg = $tra->ListarProductosMenu();

    if($reg==""){

    } else {

    $this->SetFont('Courier','BI',24);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,8,portales(utf8_decode($_SESSION['nomsucursal'])),0,0,'C');
    $this->Ln();

    $this->SetFont('Courier','BI',18);  
    $this->SetTextColor(12,41,157);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,5,'CARTA DE MENÚ (PRODUCTOS)',0,1,'C');
    $this->Ln();

    $a=1;
    for($cont = 0, $s = sizeof($reg); $cont < $s; $cont++):
    $simbolo = ($reg[$cont]['simbolo'] == "" ? "" : $reg[$cont]['simbolo']);

    $this->SetFont('Courier','B',18);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(190,8,utf8_decode($reg[$cont]["nomcategoria"]),0,0,'C', True);
    $this->Ln();

    $a=1;
    $explode = explode("<br>",$reg[$cont]['menu_productos']);

    for($aum = 0, $r = sizeof($explode); $aum < $r; $aum++):
    list($producto,$precioventa,$existencia) = explode("|",$explode[$aum]);

    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('courier','',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(150,5,portales(utf8_decode($producto)),0,0,'L');
    $this->SetFont('courier','B',12); 
    $this->Cell(40,5,utf8_decode($simbolo.number_format($precioventa, 2, '.', ',')),0,0,'R');
    $this->Ln();
    
     endfor; ##fin de for

      endfor; ##fin de for

    $this->AddPage();//HACEMOS SALTO DE LINEA
    }

    $tra2 = new Login();
    $combo = $tra2->ListarCombosMenu();

    if($combo==""){

    } else {

    $this->SetFont('Courier','BI',24);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,8,portales(utf8_decode($_SESSION['nomsucursal'])),0,0,'C');
    $this->Ln();

    $this->SetFont('Courier','BI',18);  
    $this->SetTextColor(12,41,157);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,5,'CARTA DE MENÚ (COMBOS)',0,1,'C');
    $this->Ln();

    $this->SetFont('Courier','B',14);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(60,6,"Nombre",0,0,'C', True);
    $this->Cell(50,6,"Precio Venta",0,0,'C', True);
    $this->Cell(90,6,"Detalles de Combo",0,0,'C', True);
    $this->Ln();

    $a=1;
    for($contt = 0, $ss = sizeof($combo); $contt < $ss; $contt++):
    $simbolo = ($combo[$contt]['simbolo'] == "" ? "" : $combo[$contt]['simbolo']);
    $detalles = str_replace("<br>","\n", $combo[$contt]['detalles_productos']);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('courier','',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->CellFitSpace(60,5,portales(utf8_decode($combo[$contt]["nomcombo"])),0,0,'L');
    $this->SetFont('courier','B',12); 
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($combo[$contt]["precioventa"], 2, '.', ',')),0,0,'R');
    $this->MultiCell(90,3.5,$this->SetFont('Courier','B',9).portales(utf8_decode($detalles)),0,'R');
    $this->Ln();

       endfor; ##fin de for

    $this->AddPage();//HACEMOS SALTO DE LINEA
   }


    $extras = new Login();
    $extras = $extras->ListarIngredientesMenu();

    if($extras==""){

    } else {

    $this->SetFont('Courier','BI',24);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,8,portales(utf8_decode($_SESSION['nomsucursal'])),0,0,'C');
    $this->Ln();

    $this->SetFont('Courier','BI',18);  
    $this->SetTextColor(12,41,157);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,5,'CARTA DE MENÚ (EXTRAS)',0,1,'C');
    $this->Ln();

    $a=1;
    for($cont = 0, $s = sizeof($extras); $cont < $s; $cont++):
    $simbolo = ($extras[$cont]['simbolo'] == "" ? "" : $extras[$cont]['simbolo']);

    $this->SetFont('Courier','B',18);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(190,8,utf8_decode($extras[$cont]["nommedida"]),0,0,'C', True);
    $this->Ln();

    $a=1;
    $explode = explode("<br>",$extras[$cont]['menu_extras']);

    for($aum = 0, $r = sizeof($explode); $aum < $r; $aum++):
    list($nomingrediente,$precioingrediente,$existencia) = explode("|",$explode[$aum]);

    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('courier','',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(150,5,portales(utf8_decode($nomingrediente)),0,0,'L');
    $this->SetFont('courier','B',12); 
    $this->Cell(40,5,utf8_decode($simbolo.number_format($precioingrediente, 2, '.', ',')),0,0,'R');
    $this->Ln();
    
     endfor; ##fin de for

      endfor; ##fin de for
   }

}
########################## FUNCION LISTAR MENU ##############################















########################## FUNCION LISTAR COMBOS ##############################
function TablaListarCombos()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarCombos();  
   
    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COMBOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(40,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(35,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(35,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(30,8,"P.V EXT",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,$impuesto,1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(80,8,'DETALLES DE PRODUCTOS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,40,35,35,30,30,20,20,80));

    $a=1;
    $TotalCompra=0;
    $TotalVenta=0;
    $TotalMoneda=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $simbolo2 = ($reg[$i]['simbolo2'] == "" ? "" : $reg[$i]['simbolo2']);
    $moneda = (empty($reg[$i]['montocambio']) ? "0.00" : number_format($reg[$i]['precioventa'] / $reg[$i]['montocambio'], 2, '.', ','));

    $TotalCompra+=$reg[$i]['preciocompra'];
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['desccombo']/100;
    $TotalMoneda += (empty($reg[$i]['montocambio']) ? "0.00" : number_format($reg[$i]['precioventa'] / $reg[$i]['montocambio'], 2, '.', ','));
    $TotalArticulos+=$reg[$i]['existencia'];
    $detalles = str_replace("<br>","\n", $reg[$i]['detalles_productos']);

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['codcombo']),
        portales(utf8_decode($reg[$i]["nomcombo"])),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', ',')),
        utf8_decode($simbolo2.number_format($moneda, 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode($reg[$i]['ivacombo'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['desccombo'], 2, '.', ',')),
        portales(utf8_decode($detalles))));
  }
   
    $this->Cell(80,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalCompra, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', ',')),0,0,'L');
    $this->Cell(30,5,utf8_decode($simbolo2.number_format($TotalMoneda, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS ##############################

####################### FUNCION LISTAR COMBOS EN STOCK MINIMO ##############################
function TablaListarCombosMinimo()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarCombosMinimo(); 
   
    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COMBOS EN STOCK MINIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(40,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(35,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(35,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'STOCK MINIMO',1,0,'C', True);
    $this->Cell(20,8,$impuesto,1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(80,8,'DETALLES DE PRODUCTOS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,40,35,35,30,30,20,20,80));

    $a=1;
    $TotalCompra=0;
    $TotalVenta=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    $TotalCompra+=$reg[$i]['preciocompra'];
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['desccombo']/100;
    $TotalArticulos+=$reg[$i]['existencia'];
    $detalles = str_replace("<br>","\n", $reg[$i]['detalles_productos']);

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['codcombo']),
        portales(utf8_decode($reg[$i]["nomcombo"])),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra'], 2, '.', '.')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', '.')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['stockminimo'], 2, '.', ',')),
        utf8_decode($reg[$i]['ivacombo'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['desccombo'], 2, '.', ',')),
        portales(utf8_decode($detalles))));
  }
   
    $this->Cell(80,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalCompra, 2, '.', '.')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', '.')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($TotalArticulos, 2, '.', '.')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS EN STOCK MINIMO ##############################

####################### FUNCION LISTAR COMBOS EN STOCK MAXIMO ##############################
function TablaListarCombosMaximo()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarCombosMaximo(); 
   
    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COMBOS EN STOCK MAXIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(40,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(35,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(35,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'STOCK MAXIMO',1,0,'C', True);
    $this->Cell(20,8,$impuesto,1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(80,8,'DETALLES DE PRODUCTOS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,40,35,35,30,30,20,20,80));

    $a=1;
    $TotalCompra=0;
    $TotalVenta=0;
    $TotalArticulos=0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    $TotalCompra+=$reg[$i]['preciocompra'];
    $TotalVenta+=$reg[$i]['precioventa']-$reg[$i]['desccombo']/100;
    $TotalArticulos+=$reg[$i]['existencia'];
    $detalles = str_replace("<br>","\n", $reg[$i]['detalles_productos']);

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['codcombo']),
        portales(utf8_decode($reg[$i]["nomcombo"])),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra'], 2, '.', '.')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', '.')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['stockmaximo'], 2, '.', ',')),
        utf8_decode($reg[$i]['ivacombo'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['desccombo'], 2, '.', ',')),
        portales(utf8_decode($detalles))));
  }
   
    $this->Cell(80,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalCompra, 2, '.', '.')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalVenta, 2, '.', '.')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($TotalArticulos, 2, '.', '.')),0,0,'L');
    $this->Ln();
   }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS EN STOCK MAXIMO ##############################

######################## FUNCION LISTAR COMBOS VENDIDOS #########################
function TablaListarCombosVendidos()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarCombosVendidos(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE COMBOS VENDIDOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(15,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(90,8,'DESCRIPCIÓN DE COMBO',1,0,'C', True);
    $this->Cell(45,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'VENDIDO',1,0,'C', True);
    $this->Cell(35,8,$impuesto,1,0,'C', True);
    $this->Cell(35,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(40,8,'MONTO TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,15,90,45,30,30,35,35,40));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $VendidosTotal=0;
    $TotalDescuento=0;
    $TotalImpuesto=0;
    $PagoTotal=0;

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal+=$reg[$i]['precioventa'];
    $ExisteTotal+=$reg[$i]['existencia'];
    $VendidosTotal+=$reg[$i]['cantidad'];

    $Descuento = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $CalculoDescuento = $PrecioDescuento*$reg[$i]['cantidad'];
    $PrecioFinal = $reg[$i]['precioventa']-$PrecioDescuento;

    $ivg = $reg[$i]['ivaproducto']/100;
    $SubtotalImpuesto = $PrecioFinal*$ivg;
    $CalculoImpuesto = $SubtotalImpuesto*$reg[$i]['cantidad'];

    $TotalDescuento+=$CalculoDescuento; 
    $TotalImpuesto+=$CalculoImpuesto; 
    $PagoTotal+=$PrecioFinal*$reg[$i]['cantidad']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["codproducto"]),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoImpuesto, 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoDescuento, 2, '.', ',')),
        utf8_decode($simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 2, '.', ','))));
  }
   }
   
    $this->Cell(120,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(45,5,utf8_decode($simbolo.number_format($PrecioTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($VendidosTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR COMBOS VENDIDOS ########################

################### FUNCION LISTAR COMBOS SEGUN MODENA ###################
function TablaListarCombosxMoneda()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $cambio = new Login();
    $cambio = $cambio->BuscarTiposCambios();

    $tra = new Login();
    $reg = $tra->ListarCombos(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE PRODUCTOS EN ALMACEN POR MONEDA ('.$cambio[0]["moneda"].")",0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }
    
    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(45,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(40,8,'PRECIO VENTA',1,0,'C', True);
    $this->Cell(40,8,'PRECIO '.$cambio[0]['siglas'],1,0,'C', True);
    $this->Cell(35,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(80,8,'DETALLES DE PRODUCTOS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,30,45,40,40,35,20,25,80));

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $detalles = str_replace("<br>","\n", $reg[$i]['detalles_productos']); 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codcombo"]),portales(utf8_decode($reg[$i]["nomcombo"])),utf8_decode($simbolo.number_format($reg[$i]['precioventa'], 2, '.', ',')),$tipo = ($cambio[0]['moneda'] == "EURO" ? chr(128) : $cambio[0]['simbolo']).utf8_decode(number_format($reg[$i]['precioventa']/$cambio[0]['montocambio'], 2, '.', ',')),utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),utf8_decode($reg[$i]['ivacombo'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),utf8_decode(number_format($reg[$i]['desccombo'], 2, '.', ',')),portales(utf8_decode($detalles))));
  }
   }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
################## FUNCION LISTAR COMBOS SEGUN MODENA ###################

########################## FUNCION LISTAR KARDEX POR COMBO ########################
function TablaListarKardexCombos()
   {
   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $kardex = new Login();
    $kardex = $kardex->BuscarKardexCombo(); 

    $detalle = new Login();
    $detalle = $detalle->DetalleKardexCombo(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'MOVIMIENTO GENERAL POR COMBO',0,1,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($detalle[0]['documento'])." SUCURSAL: ".utf8_decode($detalle[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($detalle[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($detalle[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'MOVIMIENTO',1,0,'C', True);
    $this->Cell(25,8,'ENTRADAS',1,0,'C', True);
    $this->Cell(25,8,'SALIDAS',1,0,'C', True);
    $this->Cell(25,8,'DEVOLUCIÓN',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(30,8,'PRECIO',1,0,'C', True);
    $this->Cell(70,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(30,8,'FECHA KARDEX',1,1,'C', True);

    if($kardex==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,35,25,25,25,25,20,30,30,70,30));

    $TotalEntradas=0;
    $TotalSalidas=0;
    $TotalDevolucion=0;
    $a=1;
    for($i=0;$i<sizeof($kardex);$i++){ 
    $simbolo = ($detalle[0]['simbolo'] == "" ? "" : $detalle[0]['simbolo']);
    $TotalEntradas+=$kardex[$i]['entradas'];
    $TotalSalidas+=$kardex[$i]['salidas'];
    $TotalDevolucion+=$kardex[$i]['devolucion'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($kardex[$i]["movimiento"]),
        utf8_decode(number_format($kardex[$i]["entradas"], 2, '.', ',')),
        utf8_decode(number_format($kardex[$i]["salidas"], 2, '.', ',')),
        utf8_decode(number_format($kardex[$i]["devolucion"], 2, '.', ',')),
        utf8_decode(number_format($kardex[$i]['stockactual'], 2, '.', ',')),
        utf8_decode($kardex[$i]['ivacombo']),
        utf8_decode(number_format($kardex[$i]['desccombo'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($kardex[$i]['precio'], 2, '.', ',')),
        utf8_decode($kardex[$i]['documento']." ".$num = ($kardex[$i]['documento'] == 'VENTA' || $kardex[$i]['documento'] == 'DEVOLUCION' ? $kardex[$i]['codproceso'] : "")),
        utf8_decode(date("d-m-Y",strtotime($kardex[$i]['fechakardex'])))));
  }
   }
   
    $this->Cell(325,5,'',0,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(120,5,'DETALLES DEL COMBO',1,0,'C', True);
    $this->Ln();
    
    $this->Cell(35,5,'CÓDIGO',1,0,'C', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode($detalle[0]['codcombo']),1,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'DESCRIPCIÓN',1,0,'C', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,portales(utf8_decode($detalle[0]['nomcombo'])),1,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'ENTRADAS',1,0,'C', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode(number_format($TotalEntradas, 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'SALIDAS',1,0,'C', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode(number_format($TotalSalidas, 2, '.', ',')),1,0,'C');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'DEVOLUCIÓN',1,0,'C', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(85,5,utf8_decode(number_format($TotalDevolucion, 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'EXISTENCIA',1,0,'C', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode(number_format($detalle[0]['existencia'], 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'PRECIO COMPRA',1,0,'C', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode($simbolo.number_format($detalle[0]['preciocompra'], 2, '.', ',')),1,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'PRECIO VENTA',1,0,'C', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,utf8_decode($simbolo.number_format($detalle[0]['precioventa'], 2, '.', ',')),1,0,'C');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR KARDEX POR COMBO ########################

####################### FUNCION LISTAR KARDEX VALORIZADO DE COMBOS ###########################
function TablaListarKardexValorizadoCombos()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarCombos(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,"LISTADO DE KARDEX VALORIZADO DE COMBOS",0,1,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIÓN DE COMBO',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(20,8,$impuesto,1,0,'C', True);
    $this->Cell(15,8,'DESC %',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(42,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(42,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(46,8,'GANANCIAS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,70,30,20,15,25,42,42,46));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $PagoTotal=0;
    $compraTotal=0;
    $TotalGanancia=0;
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $PrecioTotal+=$reg[$i]['precioventa'];
    $ExisteTotal+=$reg[$i]['existencia'];
    $PagoTotal+=$reg[$i]['precioventa']*$reg[$i]['existencia']-$reg[$i]['desccombo']/100;
    $compraTotal+=$reg[$i]['preciocompra']*$reg[$i]['existencia'];

    $sumventa = $reg[$i]['precioventa']*$reg[$i]['existencia']-$reg[$i]['desccombo']/100; 
    $sumcompra = $reg[$i]['preciocompra']*$reg[$i]['existencia'];
    $TotalGanancia+=$sumventa-$sumcompra;  

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["codcombo"]),
        portales(utf8_decode($reg[$i]["nomcombo"])),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode($reg[$i]['ivacombo'] == 'SI' ? number_format($valor, 2, '.', ',')."%" : "(E)"),
        utf8_decode(number_format($reg[$i]['desccombo'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa']*$reg[$i]['existencia']-$reg[$i]['desccombo']/100, 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra']*$reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($sumventa-$sumcompra, 2, '.', ','))));
  }
   }
   
    $this->Cell(175,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(42,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(42,5,utf8_decode($simbolo.number_format($compraTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(46,5,utf8_decode($simbolo.number_format($TotalGanancia, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR KARDEX VALORIZADO DE COMBOS ##########################

####################### FUNCION LISTAR KARDEX COMBOS VALORIZADO POR FECHAS ###########################
function TablaListarKardexValorizadoCombosxFechas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarKardexCombosValorizadoxFechas(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,"LISTADO DE KARDEX COMBOS VALORIZADO POR FECHAS",0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(20,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIÓN DE COMBO',1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'VENDIDO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(30,8,'GANANCIAS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,70,25,35,30,25,40,40,30));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $VendidosTotal=0;
    $PagoTotal=0;
    $compraTotal=0;
    $TotalGanancia=0;
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $PrecioTotal+=$reg[$i]['precioventa'];
    $ExisteTotal+=$reg[$i]['existencia'];
    $VendidosTotal+=$reg[$i]['cantidad']; 
    $PagoTotal+=$reg[$i]['precioventa']*$reg[$i]['cantidad']-$reg[$i]['descproducto']/100;
    $compraTotal+=$reg[$i]['preciocompra']*$reg[$i]['cantidad'];

    $sumventa = $reg[$i]['precioventa']*$reg[$i]['cantidad']-$reg[$i]['descproducto']/100; 
    $sumcompra = $reg[$i]['preciocompra']*$reg[$i]['cantidad'];
    $TotalGanancia+=$sumventa-$sumcompra;  

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["codproducto"]),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode(number_format($reg[$i]['descproducto'], 2, '.', ',')."%"),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['precioventa']*$reg[$i]['cantidad']-$reg[$i]['descproducto']/100, 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['preciocompra']*$reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($sumventa-$sumcompra, 2, '.', ','))));
  }
   }
   
    $this->Cell(130,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($PrecioTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode(number_format($VendidosTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($compraTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalGanancia, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR KARDEX COMBOS VALORIZADO POR FECHAS ##########################

############################### REPORTES DE MANTENIMIENTO ##############################



































############################### REPORTES DE COMPRAS ##################################

########################## FUNCION FACTURA COMPRA ##############################
function FacturaCompra()
{
        
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ComprasPorId();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

    //Logo
    if (isset($reg[0]['cuitsucursal'])) {
             if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

        $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo, 15, 11, 66, 18, "PNG");

    } else {

        $logo = "./fotos/logo_principal.png";                         
        $this->Image($logo, 15, 10, 64, 20, "PNG");  
   }                                      
    }                                     


######################### BLOQUE N° 1 ######################### 
   //BLOQUE DE DATOS DE PRINCIPAL
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 10, 260, 20, '1.5', '');
    
    //Bloque de membrete principal
    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(127, 13, 13, 13, '1.5', 'F');

    //Bloque de membrete principal
    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(127, 13, 13, 13, '1.5', '');

    $this->SetFont('Courier','B',16);
    $this->SetXY(130, 14);
    $this->Cell(20, 5, 'C', 0 , 0);
    $this->SetFont('Courier','B',9);
    $this->SetXY(126.5, 19);
    $this->Cell(20, 5, 'Compra', 0, 0);
    
    $this->SetFont('Courier','B',12);
    $this->SetXY(200, 12);
    $this->Cell(42, 5, 'N° DE COMPRA ', 0, 0);
    $this->SetFont('Courier','B',12);
    $this->SetXY(235, 12);
    $this->CellFitSpace(30, 5,utf8_decode($reg[0]['codcompra']), 0, 0, "R");
    
    $this->SetFont('Courier','B',10);
    $this->SetXY(200, 16);
    $this->Cell(42, 5, 'FECHA DE EMISIÓN ', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(235, 16);
    $this->CellFitSpace(30, 5,utf8_decode(date("d-m-Y",strtotime($reg[0]['fechaemision']))), 0, 0, "R");
    
    $this->SetFont('Courier','B',10);
    $this->SetXY(200, 20);
    $this->Cell(42, 5, 'FECHA DE RECEPCIÓN ', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(235, 20);
    $this->CellFitSpace(30, 5,utf8_decode(date("d-m-Y",strtotime($reg[0]['fecharecepcion']))), 0, 0, "R");
    
    $this->SetFont('Courier','B',10);
    $this->SetXY(200, 24);
    $this->Cell(42, 5, 'ESTADO DE COMPRA', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(235, 24);
    
    if($reg[0]['fechavencecredito']== '0000-00-00') { 
    $this->Cell(30, 5,utf8_decode($reg[0]['statuscompra']), 0, 0, "R");
    } elseif($reg[0]['fechavencecredito'] >= date("Y-m-d")) { 
    $this->Cell(30, 5,utf8_decode($reg[0]['statuscompra']), 0, 0, "R");
    } elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) { 
    $this->Cell(30, 5,utf8_decode("VENCIDA"), 0, 0, "R");
    }
######################### BLOQUE N° 1 ######################### 

############################## BLOQUE N° 2 #####################################   
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 32, 260, 16, '1.5', '');

    //DATOS DE SUCURSAL LINEA 1
    $this->SetFont('Courier','B',11);
    $this->SetXY(12, 33);
    $this->Cell(256, 5, 'DATOS DE SUCURSAL ', 0, 0);
    //DATOS DE SUCURSAL LINEA 1

    //DATOS DE SUCURSAL LINEA 2
    $this->SetFont('Courier','B',10);
    $this->SetXY(12, 38);
    $this->CellFitSpace(22, 5, 'Nº DE '.$documento = ($reg[0]['documsucursal'] == '0' ? "REG.:" : $reg[0]['documento'].":"), 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(34, 38);
    $this->CellFitSpace(32, 5,utf8_decode($reg[0]['cuitsucursal']), 0, 0);

    $this->SetFont('Courier','B',10);
    $this->SetXY(66, 38);
    $this->Cell(30, 5, 'RAZÓN SOCIAL:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(96, 38);
    $this->CellFitSpace(54, 5,utf8_decode($reg[0]['nomsucursal']), 0, 0);

    $this->SetFont('Courier','B',10);
    $this->SetXY(150, 38);
    $this->Cell(16, 5, 'EMAIL:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(166, 38);
    $this->CellFitSpace(58, 5,utf8_decode($reg[0]['correosucursal']), 0, 0);

    $this->SetFont('Courier','B',10);
    $this->SetXY(224, 38);
    $this->Cell(12, 5, 'TLF:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(236, 38);
    $this->CellFitSpace(32, 5,utf8_decode($reg[0]['tlfsucursal']), 0, 0);
    //DATOS DE SUCURSAL LINEA 2

    //DATOS DE SUCURSAL LINEA 3
    $this->SetFont('Courier','B',10);
    $this->SetXY(12, 43);
    $this->Cell(22, 5, 'DIRECCIÓN:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(34, 43);
    $this->CellFitSpace(86, 5,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia'])." ".$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento'])." ".$reg[0]['direcsucursal']), 0, 0);

    $this->SetFont('Courier','B',10);
    $this->SetXY(120, 43);
    $this->Cell(28, 5, 'RESPONSABLE:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(148, 43);
    $this->CellFitSpace(76, 5,utf8_decode($reg[0]['nomencargado']), 0, 0);

    $this->SetFont('Courier','B',10);
    $this->SetXY(224, 43);
    $this->CellFitSpace(12, 5,$documento = ($reg[0]['documencargado'] == '0' ? "DOC:" : $reg[0]['documento2'].":"), 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(236, 43);
    $this->CellFitSpace(32, 5,utf8_decode($reg[0]['dniencargado']), 0, 0);
    //DATOS DE SUCURSAL LINEA 3

################################# BLOQUE N° 2 #######################################   

################################# BLOQUE N° 3 #######################################     
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 50, 260, 16, '1.5', '');

    //DATOS DE SUCURSAL LINEA 4
    $this->SetFont('Courier','B',11);
    $this->SetXY(12, 50);
    $this->Cell(256, 5, 'DATOS DE PROVEEDOR', 0, 0);
    //DATOS DE SUCURSAL LINEA 4

    //DATOS DE SUCURSAL LINEA 5
    $this->SetFont('Courier','B',10);
    $this->SetXY(12, 55);
    $this->CellFitSpace(22, 5, 'Nº DE '.$documento = ($reg[0]['documproveedor'] == '0' ? "DOC:" : $reg[0]['documento3'].":"), 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(34, 55);
    $this->CellFitSpace(32, 5,utf8_decode($reg[0]['cuitproveedor']), 0, 0);

    $this->SetFont('Courier','B',10);
    $this->SetXY(66, 55);
    $this->Cell(30, 5, 'RAZÓN SOCIAL:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(96, 55);
    $this->CellFitSpace(54, 5,utf8_decode($reg[0]['nomproveedor']), 0, 0);

    $this->SetFont('Courier','B',10);
    $this->SetXY(150, 55);
    $this->Cell(16, 5, 'EMAIL:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(166, 55);
    $this->CellFitSpace(58, 5,utf8_decode($reg[0]['emailproveedor']), 0, 0);

    $this->SetFont('Courier','B',10);
    $this->SetXY(224, 55);
    $this->Cell(12, 5, 'TLF:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(236, 55);
    $this->CellFitSpace(32, 5,utf8_decode($reg[0]['tlfproveedor']), 0, 0);
    //DATOS DE SUCURSAL LINEA 5

    //DATOS DE SUCURSAL LINEA 6
    $this->SetFont('Courier','B',10);
    $this->SetXY(12, 60);
    $this->Cell(22, 5, 'DIRECCIÓN:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(34, 60);
    $this->CellFitSpace(86, 5,utf8_decode($provincia = ($reg[0]['provincia2'] == '' ? "" : $reg[0]['provincia2'])." ".$departamento = ($reg[0]['departamento2'] == '' ? "" : $reg[0]['departamento2'])." ".$reg[0]['direcproveedor']), 0, 0);
    

    $this->SetFont('Courier','B',10);
    $this->SetXY(120, 60);
    $this->Cell(28, 5, 'VENDEDOR:', 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(148, 60);
    $this->CellFitSpace(76, 5,utf8_decode($reg[0]['vendedor']), 0, 0);

    $this->SetFont('Courier','B',10);
    $this->SetXY(224, 60);
    $this->CellFitSpace(12, 5,"TLF", 0, 0);
    $this->SetFont('Courier','',10);
    $this->SetXY(236, 60);
    $this->CellFitSpace(32, 5,utf8_decode($reg[0]['tlfvendedor']), 0, 0);
    //DATOS DE SUCURSAL LINEA 6
################################# BLOQUE N° 3 #######################################   

################################# BLOQUE N° 4 #######################################   
    //Bloque Cuadro de Detalles de Productos
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 74, 260, 86, '0', '');

    /*$this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 68, 260, 6, '20', '');*/

    $this->SetFont('Courier','B',9);
    $this->SetXY(10, 68);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS 229)
    $this->Cell(10,6,'N°',1,0,'C', True);
    $this->Cell(20,6,'CÓDIGO',1,0,'C', True);
    $this->Cell(15,6,'LOTE',1,0,'C', True);
    $this->Cell(60,6,'DESCRIPCIÓN DE PRODUCTO',1,0,'C', True);
    $this->Cell(27,6,'CATEGORIA',1,0,'C', True);
    $this->Cell(15,6,'CANT',1,0,'C', True);
    $this->Cell(14,6,"IMP.",1,0,'C', True);
    $this->Cell(25,6,'PRECIO UNIT',1,0,'C', True);
    $this->Cell(28,6,'VALOR TOTAL',1,0,'C', True);
    $this->Cell(15,6,'DESC %',1,0,'C', True);
    $this->Cell(31,6,'VALOR NETO',1,1,'C', True);
    //$this->Ln(1);
################################# BLOQUE N° 4 ####################################### 

################################# BLOQUE N° 5 ####################################### 
    $tra = new Login();
    $detalle = $tra->VerDetallesCompras();
    $cantidad = 0;
    $SubTotal = 0;

     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,20,15,60,27,15,14,25,28,15,31));
    //verifica

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){ 
    $cantidad += $detalle[$i]['cantcompra'];
    $valortotal = $detalle[$i]["preciocomprac"]*$detalle[$i]["cantcompra"];
    $SubTotal += $detalle[$i]['valorneto'];

    $this->SetX(10);
    $this->SetFont('Courier','',9);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es BLANCO)
    $this->RowFactureCompra(array($a++,
        utf8_decode($detalle[$i]["codproducto"]),
        utf8_decode($detalle[$i]["lotec"]),
        portales(utf8_decode($detalle[$i]["producto"])),
        utf8_decode($detalle[$i]['tipo'] == 1 ? $detalle[$i]['nomcategoria'] : $detalle[$i]['nommedida']),
        utf8_decode($detalle[$i]["cantcompra"]),
        utf8_decode($detalle[$i]["ivaproductoc"] != '0.00' ? number_format($detalle[$i]["ivaproductoc"], 2, '.', ',')."%" : "(E)"),
        utf8_decode($simbolo.number_format($detalle[$i]['preciocomprac'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($detalle[$i]['valortotal'], 2, '.', ',')),
        utf8_decode(number_format($detalle[$i]['descfactura'], 2, '.', ',')."%"),
        utf8_decode($simbolo.number_format($detalle[$i]['valorneto'], 2, '.', ','))));
  }
################################# BLOQUE N° 5 ####################################### 

    ########################### BLOQUE N° 5 DE TOTALES #############################    
    //Bloque de Informacion adicional
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 162, 168, 38, '1.5', '');

    //Linea de membrete Nro 1
    $this->SetFont('Courier','B',14);
    $this->SetXY(12, 164);
    $this->Cell(162, 5, 'INFORMACIÓN ADICIONAL', 0, 0, 'C');
       
    //Linea de membrete Nro 2
    $this->SetFont('Courier','B',10);
    $this->SetXY(12, 170);
    $this->Cell(52, 5, 'CANTIDAD DE PRODUCTOS:', 0, 0);
    $this->SetXY(64, 170);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(40, 5,utf8_decode(number_format($cantidad, 2, '.', ',')), 0, 0);
       
    //Linea de membrete Nro 3
    $this->SetFont('Courier','B',10);
    $this->SetXY(104, 170);
    $this->CellFitSpace(40, 5, 'TIPO DE DOCUMENTO:', 0, 0);
    $this->SetXY(144, 170);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(30, 5,utf8_decode("FACTURA"), 0, 0);
       
    //Linea de membrete Nro 4
    $this->SetFont('Courier','B',10);
    $this->SetXY(12, 175);
    $this->Cell(52, 5, 'TIPO DE PAGO:', 0, 0);
    $this->SetXY(64, 175);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(40, 5,utf8_decode($reg[0]['tipocompra']), 0, 0);
       
    if($reg[0]['tipocompra']=="CREDITO"){

   //Linea de membrete Nro 5
    $this->SetFont('Courier','B',10);
    $this->SetXY(104, 175);
    $this->CellFitSpace(40, 5, 'FECHA VENCIMIENTO:', 0, 0);
    $this->SetXY(144, 175);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(30, 5,utf8_decode($vence = ( $reg[0]['fechavencecredito'] == '0000-00-00' ? "0" : date("d-m-Y",strtotime($reg[0]['fechavencecredito'])))), 0, 0);
        
    }
    
    //Linea de membrete Nro 4
    $this->SetFont('Courier','B',10);
    $this->SetXY(12, 180);
    $this->Cell(52, 5, 'MEDIO DE PAGO:', 0, 0);
    $this->SetXY(64, 180);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(40, 5,utf8_decode($reg[0]['formacompra']), 0, 0);

    if($reg[0]['tipocompra']=="CREDITO"){

    //Linea de membrete Nro 6
    $this->SetFont('Courier','B',10);
    $this->SetXY(104, 180);
    $this->CellFitSpace(40, 5, 'DIAS VENCIDOS:', 0, 0);
    $this->SetXY(144, 180);
    $this->SetFont('Courier','',10);
        
      if($reg[0]['fechavencecredito']== '0000-00-00') { 
        $this->CellFitSpace(30, 5,utf8_decode("0"), 0, 0);
 } elseif($reg[0]['fechavencecredito'] >= date("Y-m-d")) { 
        $this->CellFitSpace(30, 5,utf8_decode("0"), 0, 0);
 } elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) { 
        $this->CellFitSpace(30, 5,utf8_decode(Dias_Transcurridos(date("Y-m-d"),$reg[0]['fechavencecredito'])), 0, 0);
 }
    }
 
    //Linea de membrete Nro 4
    $this->SetFont('Courier','B',10);
    $this->SetXY(12, 185);
    $this->MultiCell(162,4,$this->SetFont('Courier','',10).utf8_decode(numtoletras(number_format($reg[0]["totalpagoc"], 2, '.', ''))),0,'J');

    
    //Bloque de Totales de factura
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(180, 162, 91, 38, '1.5', '');

     //Linea de membrete Nro 1
    $this->SetFont('Courier','B',10);
    $this->SetXY(182, 164);
    $this->CellFitSpace(40, 5, 'SUBTOTAL:', 0, 0);
    $this->SetXY(222, 164);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]['subtotalivasic']+$reg[0]['subtotalivanoc'], 2, '.', ',')), 0, 0, "R");

     //Linea de membrete Nro 2
    $this->SetFont('Courier','B',10);
    $this->SetXY(182, 168);
    $this->CellFitSpace(40, 5, 'GRAVADO ('.number_format($reg[0]["ivac"], 2, '.', ',').'%):', 0, 0);
    $this->SetXY(222, 168);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["subtotalivasic"], 2, '.', ',')), 0, 0, "R");

     //Linea de membrete Nro 3
    $this->SetFont('Courier','B',10);
    $this->SetXY(182, 172);
    $this->CellFitSpace(40, 5, 'EXENTO (0%):', 0, 0);
    $this->SetXY(222, 172);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["subtotalivanoc"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 3
    $this->SetFont('courier','B',10);
    $this->SetXY(182, 176);
    $this->CellFitSpace(44, 5, 'DESCONTADO %:', 0, 0);
    $this->SetXY(222, 176);
    $this->SetFont('courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["descontadoc"], 2, '.', ',')), 0, 0, "R");

     //Linea de membrete Nro 4
    $this->SetFont('Courier','B',10);
    $this->SetXY(182, 180);
    $this->CellFitSpace(40, 5, $impuesto." (".number_format($reg[0]["ivac"], 2, '.', ',')."%):", 0, 0);
    $this->SetXY(222, 180);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["totalivac"], 2, '.', ',')), 0, 0, "R");

     //Linea de membrete Nro 5
    $this->SetFont('Courier','B',10);
    $this->SetXY(182, 184);
    $this->CellFitSpace(40, 5, "DESCUENTO (".$reg[0]["descuentoc"].'%):', 0, 0);
    $this->SetXY(222, 184);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["totaldescuentoc"], 2, '.', ',')), 0, 0, "R");

     //Linea de membrete Nro 6
    $this->SetFont('Courier','B',10);
    $this->SetXY(182, 189);
    $this->CellFitSpace(40, 5, 'IMPORTE TOTAL:', 0, 0);
    $this->SetXY(222, 189);
    $this->SetFont('Courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["totalpagoc"], 2, '.', ',')), 0, 0, "R");
    
}
########################## FUNCION FACTURA COMPRA ##############################

########################## FUNCION LISTAR COMPRAS ##############################
function TablaListarCompras()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->ListarCompras();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COMPRAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(13,8,'Nº',1,0,'C', True);
    $this->Cell(50,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(30,8,'Nº DE COMPRA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIÓN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(30,8,'EMISIÓN',1,0,'C', True);
    $this->Cell(25,8,'Nº ARTIC.',1,0,'C', True);
    $this->Cell(37,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(40,8,'TOTAL IMPORTE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(13,50,30,60,30,25,37,25,25,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 

    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasic']+$reg[$i]['subtotalivanoc'];
    $TotalIva+=$reg[$i]['totalivac'];
    $TotalDescuento+=$reg[$i]['totaldescuentoc'];
    $TotalImporte+=$reg[$i]['totalpagoc'];
 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),utf8_decode($reg[$i]["codcompra"]),portales(utf8_decode($reg[$i]["nomproveedor"])),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaemision']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasic']+$reg[$i]['subtotalivanoc'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalivac'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuentoc'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpagoc'], 2, '.', ','))));
   }
   
    $this->Cell(183,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(37,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();

       }

    } else {

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE COMPRA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIÓN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(35,8,'EMISIÓN',1,0,'C', True);
    $this->Cell(35,8,'Nº ARTIC.',1,0,'C', True);
    $this->Cell(40,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESC %',1,0,'C', True);
    $this->Cell(45,8,'TOTAL IMPORTE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,70,35,35,40,30,30,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 

    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasic']+$reg[$i]['subtotalivanoc'];
    $TotalIva+=$reg[$i]['totalivac'];
    $TotalDescuento+=$reg[$i]['totaldescuentoc'];
    $TotalImporte+=$reg[$i]['totalpagoc'];
 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codcompra"]),portales(utf8_decode($reg[$i]["nomproveedor"])),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaemision']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasic']+$reg[$i]['subtotalivanoc'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalivac'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuentoc'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpagoc'], 2, '.', ','))));
   }
   
    $this->Cell(155,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(45,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();

       }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMPRAS ##############################

########################## FUNCION LISTAR CUENTAS POR PAGAR #########################
function TablaListarCuentasxPagar()
   {

    $tra = new Login();
    $reg = $tra->ListarCuentasxPagar();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE CUENTAS POR PAGAR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(50,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(30,8,'Nº DE COMPRA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIÓN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(30,8,'STATUS',1,0,'C', True);
    $this->Cell(35,8,'FECHA VENCE',1,0,'C', True);
    $this->Cell(30,8,'EMISIÓN',1,0,'C', True);
    $this->Cell(30,8,'Nº ARTICULOS',1,0,'C', True);
    $this->Cell(45,8,'TOTAL IMPORTE',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,50,30,70,30,35,30,30,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalImporte+=$reg[$i]['totalpagoc'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),utf8_decode($reg[$i]["codcompra"]),portales(utf8_decode($reg[$i]["nomproveedor"])),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statuscompra"]),utf8_decode($reg[$i]['fechavencecredito'] == '0000-00-00' ? "*********" : date("d-m-Y",strtotime($reg[$i]['fechavencecredito']))),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaemision']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpagoc'], 2, '.', ','))));
   }
   
    $this->Cell(260,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(45,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }

    } else { 

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE COMPRA',1,0,'C', True);
    $this->Cell(85,8,'DESCRIPCIÓN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(35,8,'STATUS',1,0,'C', True);
    $this->Cell(40,8,'FECHA VENCE',1,0,'C', True);
    $this->Cell(40,8,'EMISIÓN',1,0,'C', True);
    $this->Cell(35,8,'Nº ARTICULOS',1,0,'C', True);
    $this->Cell(50,8,'TOTAL IMPORTE',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,85,35,40,40,35,50));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalImporte+=$reg[$i]['totalpagoc'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codcompra"]),portales(utf8_decode($reg[$i]["nomproveedor"])),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statuscompra"]),utf8_decode($reg[$i]['fechavencecredito'] == '0000-00-00' ? "*********" : date("d-m-Y",strtotime($reg[$i]['fechavencecredito']))),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaemision']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpagoc'], 2, '.', ','))));
   }
   
    $this->Cell(250,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(50,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CUENTAS POR PAGAR #########################

####################### FUNCION LISTAR COMPRAS POR FECHAS #########################
function TablaListarComprasxFechas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarComprasxFechas();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE COMPRAS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(13,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE COMPRA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIÓN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(24,8,'STATUS',1,0,'C', True);
    $this->Cell(30,8,'FECHA VENCE',1,0,'C', True);
    $this->Cell(24,8,'EMISIÓN',1,0,'C', True);
    $this->Cell(30,8,'Nº ARTICULOS',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(13,30,60,24,30,24,30,35,25,30,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 

    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasic']+$reg[$i]['subtotalivanoc'];
    $TotalIva+=$reg[$i]['totalivac'];
    $TotalDescuento+=$reg[$i]['totaldescuentoc'];
    $TotalImporte+=$reg[$i]['totalpagoc'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codcompra"]),portales(utf8_decode($reg[$i]["nomproveedor"])),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statuscompra"]),utf8_decode($reg[$i]['fechavencecredito'] == '0000-00-00' ? "*********" : date("d-m-Y",strtotime($reg[$i]['fechavencecredito']))),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaemision']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasic']+$reg[$i]['subtotalivanoc'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalivac'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuentoc'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpagoc'], 2, '.', ','))));
   }
   
    $this->Cell(180,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMPRAS POR FECHAS #########################

####################### FUNCION LISTAR COMPRAS POR PROVEEDORES ########################
function TablaListarComprasxProveedor()
   {
    
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarComprasxProveedor();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL ################################# 

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE COMPRAS POR PROVEEDOR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"Nº DE ".utf8_decode($documento = ($reg[0]['documproveedor'] == '0' ? "DOCUMENTO" : $reg[0]['documento']).": ".$reg[0]["cuitproveedor"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"PROVEEDOR: ".portales(utf8_decode($reg[0]["nomproveedor"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"Nº DE TELÉFONO: ".utf8_decode($reg[0]["tlfproveedor"]),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(13,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE COMPRA',1,0,'C', True);
    $this->Cell(35,8,'STATUS',1,0,'C', True);
    $this->Cell(40,8,'FECHA VENCE',1,0,'C', True);
    $this->Cell(30,8,'EMISIÓN',1,0,'C', True);
    $this->Cell(30,8,'Nº ARTICULOS',1,0,'C', True);
    $this->Cell(45,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESC %',1,0,'C', True);
    $this->Cell(45,8,'TOTAL IMPORTE',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(13,35,35,40,30,30,45,30,30,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 

    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasic']+$reg[$i]['subtotalivanoc'];
    $TotalIva+=$reg[$i]['totalivac'];
    $TotalDescuento+=$reg[$i]['totaldescuentoc'];
    $TotalImporte+=$reg[$i]['totalpagoc'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codcompra"]),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statuscompra"]),utf8_decode($reg[$i]['fechavencecredito'] == '0000-00-00' ? "*********" : date("d-m-Y",strtotime($reg[$i]['fechavencecredito']))),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaemision']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasic']+$reg[$i]['subtotalivanoc'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalivac'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuentoc'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpagoc'], 2, '.', ','))));
   }
   
    $this->Cell(153,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(45,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(45,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
####################### FUNCION LISTAR COMPRAS POR PROVEEDORES #########################

############################### REPORTES DE COMPRAS #################################


































############################### REPORTES DE TRASPASOS ################################

########################## FUNCION FACTURA TRASPASOS ##############################
function FacturaTraspaso()
{
        
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == '' ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->TraspasosPorId();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

    //Logo
    if (isset($reg[0]['cuitsucursal'])) {
             
        if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

        $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo, 15, 10, 60, 20, "PNG");

        } elseif (file_exists("./fotos/logo_principal.png")) {

        $logo = "./fotos/logo_principal.png";
        $this->Image($logo, 15, 10, 60, 20, "PNG");

        } else {

        $logo = "./assets/images/null.png";                         
        $this->Image($logo, 15, 10, 60, 20, "PNG");  

        }                                      
    }

    ######################### BLOQUE N° 1 ######################### 
   //BLOQUE DE DATOS DE PRINCIPAL
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 10, 335, 20, '1.5', '');
    
    //Bloque de membrete principal
    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(161, 13, 13, 13, '1.5', 'F');

    //Bloque de membrete principal
    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(161, 13, 13, 13, '1.5', '');

    $this->SetFont('courier','B',16);
    $this->SetXY(164.5, 14);
    $this->Cell(20, 5, 'T', 0 , 0);
    $this->SetFont('courier','B',9);
    $this->SetXY(161, 19);
    $this->Cell(20, 5, 'Trasp.', 0, 0);
    
    $this->SetFont('courier','B',14);
    $this->SetXY(260, 12);
    $this->Cell(46, 6, 'N° DE TRASPASO ', 0, 0);
    $this->SetFont('courier','B',14);
    $this->SetXY(306, 12);
    $this->CellFitSpace(36, 6,utf8_decode($reg[0]['codtraspaso']), 0, 0, "R");
    
    $this->SetFont('courier','B',11);
    $this->SetXY(260, 18);
    $this->Cell(46, 5, 'FECHA DE EMISIÓN ', 0, 0);
    $this->SetFont('courier','',11);
    $this->SetXY(306, 18);
    $this->CellFitSpace(36, 5,utf8_decode(date("d-m-Y H:i:s",strtotime($reg[0]['fechatraspaso']))), 0, 0, "R");
    
    $this->SetFont('courier','B',11);
    $this->SetXY(260, 23);
    $this->Cell(46, 5, 'FECHA DE RECEPCIÓN ', 0, 0);
    $this->SetFont('courier','',11);
    $this->SetXY(306, 23);
    $this->CellFitSpace(36, 5,utf8_decode(date("d-m-Y H:i:s")), 0, 0, "R");
    ######################### BLOQUE N° 1 ######################### 

    ############################## BLOQUE N° 2 #####################################   
    //BLOQUE DE DATOS DE SUCURSAL QUE ENVIA
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 32, 335, 32, '1.5', '');

    //DATOS DE SUCURSAL LINEA 1
    $this->SetFont('courier','B',12);
    $this->SetXY(12, 33);
    $this->Cell(330, 5, 'DATOS DE SUCURSAL QUE ENVIA', 0, 0);
    //DATOS DE SUCURSAL LINEA 1

    //DATOS DE SUCURSAL LINEA 2
    $this->SetFont('courier','B',10);
    $this->SetXY(12, 38);
    $this->CellFitSpace(28, 5, 'Nº DE '.$documento = ($reg[0]['documsucursal'] == '0' ? "REG.:" : $reg[0]['documento'].":"), 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(40, 38);
    $this->CellFitSpace(30, 5,utf8_decode($reg[0]['cuitsucursal']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(70, 38);
    $this->Cell(30, 5, 'RAZÓN SOCIAL:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(100, 38);
    $this->CellFitSpace(60, 5,utf8_decode($reg[0]['nomsucursal']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(160, 38);
    $this->Cell(24, 5, 'DIRECCIÓN:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(184, 38);
    $this->CellFitSpace(106, 5,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia'])." ".$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento'])." ".$reg[0]['direcsucursal']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(290, 38);
    $this->Cell(22, 5, 'N° DE TLF:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(312, 38);
    $this->CellFitSpace(30, 5,utf8_decode($reg[0]['tlfsucursal']), 0, 0);
    //DATOS DE SUCURSAL LINEA 2

    //DATOS DE SUCURSAL LINEA 3
    $this->SetFont('courier','B',10);
    $this->SetXY(12, 43);
    $this->Cell(18, 5, 'EMAIL:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(30, 43);
    $this->CellFitSpace(80, 5,utf8_decode($reg[0]['correosucursal']), 0, 0);
    //DATOS DE SUCURSAL LINEA 3

    //DATOS DE SUCURSAL LINEA 4
    $this->SetFont('courier','B',10);
    $this->SetXY(110, 43);
    $this->Cell(30, 5, 'RESPONSABLE:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(140, 43);
    $this->CellFitSpace(90, 5,utf8_decode($reg[0]['nomencargado']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(230, 43);
    $this->CellFitSpace(26, 5,'Nº DE '.$documento = ($reg[0]['documencargado'] == '0' ? "DOC.:" : $reg[0]['documento2'].":"), 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(256, 43);
    $this->CellFitSpace(34, 5,utf8_decode($reg[0]['dniencargado']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(290, 43);
    $this->Cell(22, 5, 'N° DE TLF:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(312, 43);
    $this->CellFitSpace(30, 5,utf8_decode($tlf = ($reg[0]['tlfencargado'] == '' ? "******" : $reg[0]['tlfencargado'])), 0, 0);
    //DATOS DE SUCURSAL LINEA 4
    ################################# BLOQUE N° 2 #######################################  

    ################################# BLOQUE N° 3 #######################################   
    //BLOQUE DE DATOS DE SUCURSAL QUE RECIBE

    //DATOS DE SUCURSAL LINEA 5
    $this->SetFont('courier','B',12);
    $this->SetXY(12, 50);
    $this->Cell(330, 4, 'DATOS DE SUCURSAL QUE RECIBE', 0, 0);
    //DATOS DE SUCURSAL LINEA 5

    //DATOS DE SUCURSAL LINEA 6
    $this->SetFont('courier','B',10);
    $this->SetXY(12, 54);
    $this->CellFitSpace(28, 5, 'Nº DE '.$documento = ($reg[0]['documsucursal2'] == '0' ? "REG.:" : $reg[0]['documento3'].":"), 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(40, 54);
    $this->CellFitSpace(30, 5,utf8_decode($reg[0]['cuitsucursal2']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(70, 54);
    $this->Cell(30, 5, 'RAZÓN SOCIAL:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(100, 54);
    $this->CellFitSpace(50, 5,utf8_decode($reg[0]['nomsucursal2']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(150, 54);
    $this->Cell(24, 5, 'DIRECCIÓN:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(174, 54);
    $this->CellFitSpace(116, 5,utf8_decode($provincia = ($reg[0]['provincia2'] == '' ? "" : $reg[0]['provincia2'])." ".$departamento = ($reg[0]['departamento2'] == '' ? "" : $reg[0]['departamento2'])." ".$reg[0]['direcsucursal2']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(290, 54);
    $this->Cell(22, 5, 'N° DE TLF:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(312, 54);
    $this->CellFitSpace(30, 5,utf8_decode($reg[0]['tlfsucursal2']), 0, 0);
    //DATOS DE SUCURSAL LINEA 6

    //DATOS DE SUCURSAL LINEA 7
    $this->SetFont('courier','B',10);
    $this->SetXY(12, 59);
    $this->Cell(28, 5, 'EMAIL:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(30, 59);
    $this->CellFitSpace(80, 5,utf8_decode($reg[0]['correosucursal2']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(110, 59);
    $this->Cell(30, 5, 'RESPONSABLE:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(140, 59);
    $this->CellFitSpace(90, 5,utf8_decode($reg[0]['nomencargado2']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(230, 59);
    $this->CellFitSpace(26, 5,'Nº DE '.$documento = ($reg[0]['documencargado2'] == '0' ? "DOC.:" : $reg[0]['documento4'].":"), 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(256, 59);
    $this->CellFitSpace(34, 5,utf8_decode($reg[0]['dniencargado2']), 0, 0);

    $this->SetFont('courier','B',10);
    $this->SetXY(290, 59);
    $this->Cell(22, 5, 'N° DE TLF:', 0, 0);
    $this->SetFont('courier','',10);
    $this->SetXY(312, 59);
    $this->CellFitSpace(30, 5,utf8_decode($tlf = ($reg[0]['tlfencargado2'] == '' ? "******" : $reg[0]['tlfencargado2'])), 0, 0);
    //DATOS DE SUCURSAL LINEA 7
    ################################# BLOQUE N° 3 #######################################   

    ################################# BLOQUE N° 4 #######################################   
    //Bloque Cuadro de Detalles de Productos
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 68, 335, 93, '0', '');

    $this->SetFont('courier','B',9);
    $this->SetXY(10, 66);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,8,'N°',1,0,'C', True);
    $this->Cell(30,8,'CÓDIGO',1,0,'C', True);
    $this->Cell(25,8,'F.VCTO',1,0,'C', True);
    $this->Cell(76,8,'DESCRIPCIÓN DE PRODUCTO',1,0,'C', True);
    $this->Cell(45,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(15,8,'CANT',1,0,'C', True);
    $this->Cell(15,8,"IMP.",1,0,'C', True);
    $this->Cell(30,8,'PRECIO UNIT',1,0,'C', True);
    $this->Cell(34,8,'VALOR TOTAL',1,0,'C', True);
    $this->Cell(18,8,'DESC %',1,0,'C', True);
    $this->Cell(37,8,'VALOR NETO',1,1,'C', True);
    //$this->Ln(1);
    ################################# BLOQUE N° 4 ####################################### 

    ################################# BLOQUE N° 5 ####################################### 
    $new = new Login();
    $detalle = $new->VerDetallesTraspasos();
    $cantidad = 0;
    $SubTotal = 0;

    $this->SetWidths(array(10,30,25,76,45,15,15,30,34,18,37));

    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){ 
    $cantidad += $detalle[$i]['cantidad'];
    $valortotal = $detalle[$i]["precioventa"]*$detalle[$i]["cantidad"];
    $SubTotal += $detalle[$i]['valorneto'];

    $this->SetX(10);
    $this->SetFont('Courier','',9);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->RowFacture(array($a++,
        utf8_decode($detalle[$i]["codproducto"]),
        utf8_decode($detalle[$i]["fechaexpiracion"] == '0000-00-00' ? "******" : $detalle[$i]["fechaexpiracion"]),
        portales(utf8_decode($detalle[$i]["producto"])),
        utf8_decode($detalle[$i]['tipo'] == 1 ? $detalle[$i]['nomcategoria'] : $detalle[$i]['nommedida']),
        utf8_decode($detalle[$i]["cantidad"]),
        utf8_decode($detalle[$i]["ivaproducto"] != '0.00' ? $detalle[$i]["ivaproducto"]."%" : "(E)"),
        utf8_decode($simbolo.number_format($detalle[$i]['precioventa'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($detalle[$i]['valortotal'], 2, '.', ',')),
        utf8_decode(number_format($detalle[$i]['descproducto'], 2, '.', ',')."%"),
        utf8_decode($simbolo.number_format($detalle[$i]['valorneto'], 2, '.', ','))));
    }
    ################################# BLOQUE N° 5 ####################################### 

    ########################### BLOQUE N° 5 DE TOTALES #############################    
    //Bloque de Informacion adicional
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 162, 240, 38, '1.5', '');

    //Linea de membrete Nro 1
    $this->SetFont('courier','B',14);
    $this->SetXY(115, 164);
    $this->Cell(20, 5, 'INFORMACIÓN ADICIONAL', 0 , 0);
       
    //Linea de membrete Nro 2
    $this->SetFont('courier','B',10);
    $this->SetXY(12, 172);
    $this->Cell(20, 5, 'CANTIDAD DE PRODUCTOS:', 0 , 0);
    $this->SetXY(64, 172);
    $this->SetFont('courier','',10);
    $this->Cell(20, 5,utf8_decode($cantidad), 0 , 0);
       
    //Linea de membrete Nro 3
    $this->SetFont('courier','B',10);
    $this->SetXY(12, 178);
    $this->Cell(20, 5, 'TIPO DE DOCUMENTO:', 0 , 0);
    $this->SetXY(64, 178);
    $this->SetFont('courier','',10);
    $this->Cell(20, 5,utf8_decode("FACTURA"), 0 , 0);
       
    //Linea de membrete Nro 4
    $this->SetFont('courier','B',10);
    $this->SetXY(12, 184);
    $this->Cell(20, 5, 'OBSERVACIONES:', 0 , 0);
    $this->SetXY(64, 184);
    $this->MultiCell(236,4,$this->SetFont('Courier','',10).utf8_decode($reg[0]['observaciones'] == '' ? "**********" : $reg[0]['observaciones']),0,'J');
    
    //Bloque de Totales de factura
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(253, 162, 91, 38, '1.5', '');

    //Linea de membrete Nro 1
    $this->SetFont('courier','B',10);
    $this->SetXY(254, 164);
    $this->CellFitSpace(44, 5, 'SUBTOTAL:', 0, 0);
    $this->SetXY(298, 164);
    $this->SetFont('courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]['subtotalivasi']+$reg[0]['subtotalivano'], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 2
    $this->SetFont('courier','B',10);
    $this->SetXY(254, 168);
    $this->CellFitSpace(44, 5, 'GRAVADO ('.$reg[0]["iva"].'%):', 0, 0);
    $this->SetXY(298, 168);
    $this->SetFont('courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["subtotalivasi"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 3
    $this->SetFont('courier','B',10);
    $this->SetXY(254, 172);
    $this->CellFitSpace(44, 5, 'EXENTO (0%):', 0, 0);
    $this->SetXY(298, 172);
    $this->SetFont('courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["subtotalivano"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 3
    $this->SetFont('courier','B',10);
    $this->SetXY(254, 176);
    $this->CellFitSpace(44, 5, 'DESCONTADO %:', 0, 0);
    $this->SetXY(298, 176);
    $this->SetFont('courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["descontado"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 4
    $this->SetFont('courier','B',10);
    $this->SetXY(254, 180);
    $this->CellFitSpace(44, 5, $impuesto == '' ? "TOTAL IMP." : "TOTAL ".$imp[0]['nomimpuesto']." (".$reg[0]["iva"]."%):", 0, 0);
    $this->SetXY(298, 180);
    $this->SetFont('courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["totaliva"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 5
    $this->SetFont('courier','B',10);
    $this->SetXY(254, 184);
    $this->CellFitSpace(44, 5, "DESC. GLOBAL (".$reg[0]["descuento"].'%):', 0, 0);
    $this->SetXY(298, 184);
    $this->SetFont('courier','',10);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["totaldescuento"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 6
    $this->SetFont('courier','B',11);
    $this->SetXY(254, 189);
    $this->CellFitSpace(44, 5, 'IMPORTE TOTAL:', 0, 0);
    $this->SetXY(298, 189);
    $this->SetFont('courier','B',11);
    $this->CellFitSpace(46, 5,utf8_decode($simbolo.number_format($reg[0]["totalpago"], 2, '.', ',')), 0, 0, "R");
    
}
########################## FUNCION FACTURA TRASPASOS ##############################

########################## FUNCION LISTAR TRASPASOS ##############################
function TablaListarTraspasos()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == '' ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == '' ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarTraspasos();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE TRASPASOS',0,0,'C');

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE TRASPASO',1,0,'C', True);
    $this->Cell(45,8,'SUCURSAL ENVIA',1,0,'C', True);
    $this->Cell(45,8,'SUCURSAL RECIBE',1,0,'C', True);
    $this->Cell(40,8,'FECHA DE EMISIÓN',1,0,'C', True);
    $this->Cell(30,8,'Nº ARTICULOS',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC%',1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,45,45,40,30,35,25,25,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalImpuesto=0;
    $TotalDescuento=0;
    $TotalImporte=0;


    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);  
    
    $TotalArticulos+=$reg[$i]['sumarticulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalImpuesto+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];
 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codtraspaso"]),portales(utf8_decode($reg[$i]["nomsucursal"])),portales(utf8_decode($reg[$i]["nomsucursal2"])),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechatraspaso']))),utf8_decode($reg[$i]["sumarticulos"]),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
        }
   
    $this->Cell(180,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($TotalArticulos),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
      }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TRASPASOS ##############################

########################## FUNCION LISTAR TRASPASOS POR SUCURSAL ##############################
function TablaListarTraspasosxSucursal()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == '' ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == '' ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarTraspasosxSucursal();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE TRASPASOS POR SUCURSAL',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(335,6,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,6,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE TRASPASO',1,0,'C', True);
    $this->Cell(45,8,'SUCURSAL RECIBE',1,0,'C', True);
    $this->Cell(45,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(40,8,'FECHA DE EMISIÓN',1,0,'C', True);
    $this->Cell(30,8,'Nº ARTICULOS',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC%',1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,45,45,40,30,35,25,25,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalImpuesto=0;
    $TotalDescuento=0;
    $TotalImporte=0;


    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalArticulos+=$reg[$i]['sumarticulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalImpuesto+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];
 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codtraspaso"]),portales(utf8_decode($reg[$i]["nomsucursal2"])),portales(utf8_decode($reg[$i]['observaciones'] == "" ? "**********" : $reg[$i]['observaciones'])),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechatraspaso']))),utf8_decode($reg[$i]["sumarticulos"]),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
        }
   
    $this->Cell(180,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($TotalArticulos),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
      }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TRASPASOS POR SUCURSAL ##############################

########################## FUNCION LISTAR TRASPASOS POR FECHAS ##############################
function TablaListarTraspasosxFechas()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == '' ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == '' ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarTraspasosxFechas();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE TRASPASOS POR FECHAS',0,0,'C');

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE TRASPASO',1,0,'C', True);
    $this->Cell(45,8,'SUCURSAL ENVIA',1,0,'C', True);
    $this->Cell(45,8,'SUCURSAL RECIBE',1,0,'C', True);
    $this->Cell(40,8,'FECHA DE EMISIÓN',1,0,'C', True);
    $this->Cell(30,8,'Nº ARTICULOS',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC%',1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,45,45,40,30,35,25,25,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalImpuesto=0;
    $TotalDescuento=0;
    $TotalImporte=0;


    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalArticulos+=$reg[$i]['sumarticulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalImpuesto+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];
 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codtraspaso"]),portales(utf8_decode($reg[$i]["nomsucursal"])),portales(utf8_decode($reg[$i]["nomsucursal2"])),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechatraspaso']))),utf8_decode($reg[$i]["sumarticulos"]),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
        }
   
    $this->Cell(180,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($TotalArticulos),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
      }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TRASPASOS POR FECHAS ##############################

####################### FUNCION LISTAR DETALLES TRASPASOS POR FECHAS ###########################
function TablaListarDetallesTraspasosxFechas()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == '' ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == '' ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarDetallesTraspasosxFechas(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE DETALLES TRASPASOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'TIPO',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(40,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(40,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,'TRASPASO',1,0,'C', True);
    $this->Cell(40,8,'MONTO TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,30,60,40,30,30,40,30,20,40));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $VendidosTotal=0;
    $TotalDescuento=0;
    $TotalImpuesto=0;
    $PagoTotal=0;

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal+=$reg[$i]['precioventa'];

    if($reg[$i]['tipo'] == 1){

        $Tipo="PRODUCTO";
        $Categoria=$reg[$i]['nomcategoria'];
        $Existencia=$reg[$i]['existencia'];
        $ExisteTotal+=$reg[$i]['existencia'];

    } else {

        $Tipo="INGREDIENTE";
        $Categoria=$reg[$i]['nommedida'];
        $Existencia=$reg[$i]['cantingrediente'];
        $ExisteTotal+=$reg[$i]['cantingrediente'];
    }

    $VendidosTotal+=$reg[$i]['cantidad'];

    $Descuento = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $CalculoDescuento = $PrecioDescuento*$reg[$i]['cantidad'];
    $PrecioFinal = $reg[$i]['precioventa']-$PrecioDescuento;

    $ivg = $reg[$i]['ivaproducto']/100;
    $SubtotalImpuesto = $PrecioFinal*$ivg;
    $CalculoImpuesto = $SubtotalImpuesto*$reg[$i]['cantidad'];

    $TotalDescuento+=$CalculoDescuento; 
    $TotalImpuesto+=$CalculoImpuesto; 
    $PagoTotal+=$PrecioFinal*$reg[$i]['cantidad']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($Tipo),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($Categoria),
        utf8_decode($reg[$i]['ivaproducto'] != '0.00' ? number_format($reg[$i]['ivaproducto'], 2, '.', ',')."%" : "(E)"),
        utf8_decode($simbolo.number_format($reg[$i]['descproducto'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 2, '.', ','))));
  }
   }
   
    $this->Cell(205,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PrecioTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode(number_format($VendidosTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();  

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR DETALLES TRASPASOS POR FECHAS ##########################

####################### FUNCION LISTAR PRODUCTOS TRASPASOS POR SUCURSAL ###########################
function TablaListarDetallesTraspasosxSucursal()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == '' ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == '' ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarDetallesTraspasosxSucursal(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE DETALLES TRASPASOS POR SUCURSAL',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->SetFont('Courier','B',14);
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    ########################################## DATOS DE SUCURSAL ENVIA ##########################################
    $this->SetXY(10,62);
    $this->SetFont('Courier','B',14);
    $this->CellFitSpace(168,4,utf8_decode($reg[0]['nomsucursal'])." (ENVIA)", 0, 0, 'J');

    $this->SetX(176);
    $this->SetFont('Courier','B',14);
    $this->CellFitSpace(167,4,utf8_decode($reg[0]['nomsucursal2'])." (RECIBE)", 0, 1, 'R');

    $this->SetX(10);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(168,4,utf8_decode($reg[0]['nomencargado']), 0, 0, 'J');

    $this->SetX(176);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(167,4,utf8_decode($reg[0]['nomencargado2']), 0, 1, 'R');

    $this->SetX(10);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(168,4,utf8_decode($reg[0]['direcsucursal']), 0, 0, 'J');

    $this->SetX(176);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(167,4,utf8_decode($reg[0]['direcsucursal2']), 0, 1, 'R');

    if($reg[0]['id_provincia']!='0'){

    $this->SetX(10);
    $this->CellFitSpace(167,4,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia'])." ".$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento'])),0,0,'J');

    }

    if($reg[0]['id_provincia2']!='0'){

    $this->SetX(176);
    $this->CellFitSpace(167,4,utf8_decode($provincia = ($reg[0]['provincia2'] == '' ? "" : $reg[0]['provincia2'])." ".$departamento = ($reg[0]['departamento2'] == '' ? "" : $reg[0]['departamento2'])),0,1,'R');

    }

    $this->SetX(10);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(168,4,utf8_decode($reg[0]['tlfsucursal']),0,0,'J');
    $this->SetX(176);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(167,4,utf8_decode($reg[0]['tlfsucursal2']),0,1,'R');

    $this->SetX(10);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(168,4,$reg[0]['documsucursal'] == '0' ? "" : $reg[0]['documento'].": ".utf8_decode($reg[0]['cuitsucursal']),0,0,'J');

    $this->SetX(176);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(167,4,$reg[0]['documsucursal2'] == '0' ? "" : $reg[0]['documento3'].": ".utf8_decode($reg[0]['cuitsucursal2']),0,1,'R');
    ########################################## DATOS DE SUCURSAL ENVIA ##########################################

    } else {

    ########################################## DATOS DE SUCURSAL ENVIA ##########################################
    $this->SetXY(10,52);
    $this->SetFont('Courier','B',14);
    $this->CellFitSpace(168,4,utf8_decode($reg[0]['nomsucursal2'])." (RECIBE)", 0, 0, 'J');

    $this->SetX(176);
    $this->SetFont('Courier','B',14);
    $this->CellFitSpace(167,4,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])), 0, 1, 'R');

    $this->SetX(10);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(168,4,utf8_decode($reg[0]['nomencargado2']), 0, 0, 'J');

    $this->SetX(176);
    $this->SetFont('Courier','B',14);
    $this->CellFitSpace(167,4,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])), 0, 1, 'R');

    $this->SetX(10);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(168,4,utf8_decode($reg[0]['direcsucursal2']), 0, 0, 'J');

    $this->SetX(176);
    $this->SetFont('Courier','',12);
    $this->Cell(167,4,"", 0, 1, 'R');

    if($reg[0]['id_provincia']!='0'){

    $this->SetX(10);
    $this->CellFitSpace(167,4,utf8_decode($provincia = ($reg[0]['provincia2'] == '' ? "" : $reg[0]['provincia2'])." ".$departamento = ($reg[0]['departamento2'] == '' ? "" : $reg[0]['departamento2'])),0,0,'J');

    }

    if($reg[0]['id_provincia2']!='0'){

    $this->SetX(176);
    $this->Cell(167,4,"",0,1,'R');

    }

    $this->SetX(10);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(168,4,utf8_decode($reg[0]['tlfsucursal2']),0,0,'J');
    $this->SetX(176);
    $this->SetFont('Courier','',12);
    $this->Cell(167,4,"",0,1,'R');

    $this->SetX(10);
    $this->SetFont('Courier','',12);
    $this->CellFitSpace(168,4,$reg[0]['documsucursal2'] == '0' ? "" : $reg[0]['documento3'].": ".utf8_decode($reg[0]['cuitsucursal2']),0,0,'J');

    $this->SetX(176);
    $this->SetFont('Courier','',12);
    $this->Cell(167,4,"",0,1,'R');
    ########################################## DATOS DE SUCURSAL ENVIA ##########################################    

    }

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'TIPO',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(40,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(40,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,'TRASPASO',1,0,'C', True);
    $this->Cell(40,8,'MONTO TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,30,60,40,30,30,40,30,20,40));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $VendidosTotal=0;
    $TotalDescuento=0;
    $TotalImpuesto=0;
    $PagoTotal=0;

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal+=$reg[$i]['precioventa'];

    if($reg[$i]['tipo'] == 1){

        $Tipo="PRODUCTO";
        $Categoria=$reg[$i]['nomcategoria'];
        $Existencia=$reg[$i]['existencia'];
        $ExisteTotal+=$reg[$i]['existencia'];

    } else {

        $Tipo="INGREDIENTE";
        $Categoria=$reg[$i]['nommedida'];
        $Existencia=$reg[$i]['cantingrediente'];
        $ExisteTotal+=$reg[$i]['cantingrediente'];
    }

    $VendidosTotal+=$reg[$i]['cantidad'];

    $Descuento = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $CalculoDescuento = $PrecioDescuento*$reg[$i]['cantidad'];
    $PrecioFinal = $reg[$i]['precioventa']-$PrecioDescuento;

    $ivg = $reg[$i]['ivaproducto']/100;
    $SubtotalImpuesto = $PrecioFinal*$ivg;
    $CalculoImpuesto = $SubtotalImpuesto*$reg[$i]['cantidad'];

    $TotalDescuento+=$CalculoDescuento; 
    $TotalImpuesto+=$CalculoImpuesto; 
    $PagoTotal+=$PrecioFinal*$reg[$i]['cantidad']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($Tipo),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($Categoria),
        utf8_decode($reg[$i]['ivaproducto'] != '0.00' ? number_format($reg[$i]['ivaproducto'], 2, '.', ',')."%" : "(E)"),
        utf8_decode($simbolo.number_format($reg[$i]['descproducto'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 2, '.', ','))));
  }
   }
   
    $this->Cell(205,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PrecioTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode(number_format($VendidosTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();  
   

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR PRODUCTOS TRASPASOS POR SUCURSAL ##########################

############################### REPORTES DE TRASPASOS ##################################









































############################### REPORTES DE COTIZACIONES #############################

########################## FUNCION FACTURA COTIZACION ##############################
function FacturaCotizacion()
{     
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->CotizacionesPorId();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

    //Logo
    if (isset($reg[0]['cuitsucursal'])) {
             if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

        $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo, 15, 11, 40, 14, "PNG");

    } else {

        $logo = "./fotos/logo_principal.png";                         
        $this->Image($logo, 15, 10, 4, 20, "PNG");  
   }                                      
    } 

    ############################# BLOQUE N° 1 FACTURA ###############################   
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 10, 190, 16, '1.5', '');
    
    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(98, 12, 12, 12, '1.5', 'F');

    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(98, 12, 12, 12, '1.5', '');

    $this->SetFont('courier','B',16);
    $this->SetXY(101, 14);
    $this->Cell(20, 5, 'C', 0 , 0);
    $this->SetFont('courier','B',8);
    $this->SetXY(98, 19);
    $this->Cell(20, 5, 'Cotiz.', 0, 0);
    
    $this->SetFont('courier','B',11);
    $this->SetXY(120, 12);
    $this->Cell(40, 4, 'N° DE COTIZACIÓN ', 0, 0);
    $this->SetFont('courier','B',11);
    $this->SetXY(160, 12);
    $this->CellFitSpace(38, 4,utf8_decode($reg[0]['codcotizacion']), 0, 0, "R");

    $this->SetFont('courier','B',9);
    $this->SetXY(120, 16);
    $this->Cell(40, 4, 'FECHA DE COTIZACIÓN ', 0, 0);
    $this->SetFont('courier','',9);
    $this->SetXY(160, 16);
    $this->CellFitSpace(38, 4,utf8_decode(date("d-m-Y",strtotime($reg[0]['fechacotizacion']))), 0, 0, "R");

    $this->SetFont('courier','B',9);
    $this->SetXY(120, 20);
    $this->Cell(40, 4, 'FECHA DE EMISIÓN', 0, 0);
    $this->SetFont('courier','',9);
    $this->SetXY(160, 20);
    $this->CellFitSpace(38, 4,utf8_decode(date("d-m-Y H:i:s")), 0, 0, "R");
    ################################# BLOQUE N° 1 FACTURA ################################ 

    ############################# BLOQUE N° 2 SUCURSAL ###############################   
   //Bloque de datos de empresa
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 27, 190, 18, '1.5', '');
    //DATOS DE SUCURSAL LINEA 1
    $this->SetFont('courier','B',9);
    $this->SetXY(12, 28);
    $this->Cell(186, 4, 'DATOS DE SUCURSAL ', 0, 0);
    //DATOS DE SUCURSAL LINEA 1

    //DATOS DE SUCURSAL LINEA 2
    $this->SetFont('courier','B',8);
    $this->SetXY(12, 32);
    $this->Cell(24, 4, 'RAZÓN SOCIAL:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(36, 32);
    $this->CellFitSpace(66, 4,utf8_decode($reg[0]['nomsucursal']), 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(102, 32);
    $this->CellFitSpace(22, 4, 'Nº DE '.$documento = ($reg[0]['documsucursal'] == '0' ? "REG.:" : $reg[0]['documento'].":"), 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(124, 32);
    $this->CellFitSpace(28, 4,utf8_decode($reg[0]['cuitsucursal']), 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(152, 32);
    $this->Cell(18, 4, 'N° DE TLF:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(170, 32);
    $this->Cell(28, 4,utf8_decode($reg[0]['tlfsucursal']), 0, 0);
    //DATOS DE SUCURSAL LINEA 2

    //DATOS DE SUCURSAL LINEA 3
    $this->SetFont('courier','B',8);
    $this->SetXY(12, 36);
    $this->Cell(24, 4, 'DIRECCIÓN:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(36, 36);
    $this->CellFitSpace(96, 4,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia'])." ".$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento'])." ".$reg[0]['direcsucursal']), 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(132, 36);
    $this->Cell(12, 4, 'EMAIL:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(144, 36);
    $this->Cell(54, 4,utf8_decode($reg[0]['correosucursal']), 0, 0);
    //DATOS DE SUCURSAL LINEA 3

    //DATOS DE SUCURSAL LINEA 4
    $this->SetFont('courier','B',8);
    $this->SetXY(12, 40);
    $this->Cell(24, 4, 'RESPONSABLE:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(36, 40);
    $this->CellFitSpace(66, 4,utf8_decode($reg[0]['nomencargado']), 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(102, 40);
    $this->CellFitSpace(22, 4, 'Nº DE '.$documento = ($reg[0]['documencargado'] == '0' ? "DOC.:" : $reg[0]['documento2'].":"), 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(124, 40);
    $this->CellFitSpace(28, 4,utf8_decode($reg[0]['dniencargado']), 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(152, 40);
    $this->Cell(18, 4, 'N° DE TLF:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(170, 40);
    $this->Cell(28, 4,utf8_decode($tlf = ($reg[0]['tlfencargado'] == '' ? "" : $reg[0]['tlfencargado'])), 0, 0);
    //DATOS DE SUCURSAL LINEA 4
    ############################ BLOQUE N° 2 SUCURSAL ###############################   


    ############################## BLOQUE N° 3 CLIENTE #################################  
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 46, 190, 14, '1.5', '');

    $this->SetFont('courier','B',9);
    $this->SetXY(12, 47);
    $this->Cell(186, 4, 'DATOS DE CLIENTE ', 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(12, 51);
    $this->Cell(20, 4, 'NOMBRES:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(32, 51);
    $this->CellFitSpace(58, 4,utf8_decode($nombre = ($reg[0]['nomcliente'] == '' ? "CONSUMIDOR FINAL" : $reg[0]['nomcliente'])), 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(90, 51);
    $this->CellFitSpace(20, 4, 'Nº DE '.$documento = ($reg[0]['documcliente'] == '0' ? "DOC.:" : $reg[0]['documento3'].":"), 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(110, 51);
    $this->CellFitSpace(24, 4,utf8_decode($nombre = ($reg[0]['dnicliente'] == '' ? "*********" : $reg[0]['dnicliente'])), 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(134, 51);
    $this->Cell(12, 4, 'EMAIL:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(146, 51);
    $this->CellFitSpace(52, 4,utf8_decode($email = ($reg[0]['emailcliente'] == '' ? "*********" : $reg[0]['emailcliente'])), 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(12, 55);
    $this->Cell(20, 4, 'DIRECCIÓN:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(32, 55);
    $this->CellFitSpace(124, 4,getSubString(utf8_decode($provincia = ($reg[0]['provincia2'] == '' ? "" : $reg[0]['provincia2'])." ".$departamento = ($reg[0]['departamento2'] == '' ? "" : $reg[0]['departamento2'])." ".$reg[0]['direccliente']), 70), 0, 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(156, 55);
    $this->Cell(20, 4, 'N° DE TLF:', 0, 0);
    $this->SetFont('courier','',8);
    $this->SetXY(176, 55);
    $this->CellFitSpace(22, 4,utf8_decode($tlf = ($reg[0]['tlfcliente'] == '' ? "*********" : $reg[0]['tlfcliente'])), 0, 0); 
    ############################## BLOQUE N° 3 CLIENTE ################################# 

    ################################# BLOQUE N° 4 #######################################   
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 69, 190, 180, '0', '');

    $this->SetFont('courier','B',9);
    $this->SetXY(10, 61);
    $this->SetTextColor(3,3,3);
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(8, 8,"Nº", 1, 0, 'C', True);
    $this->Cell(66, 8,"DESCRIPCIÓN DE PRODUCTO", 1, 0, 'C', True);
    $this->Cell(10, 8,"CANT", 1, 0, 'C', True);
    $this->Cell(25, 8,"P/UNIT", 1, 0, 'C', True);
    $this->Cell(25, 8,"V/TOTAL", 1, 0, 'C', True);
    $this->Cell(15, 8,"DESC %", 1, 0, 'C', True);
    $this->Cell(16, 8,$impuesto, 1, 0, 'C', True);
    $this->Cell(25, 8,"V/NETO", 1, 1, 'C', True);
################################# BLOQUE N° 4 #######################################  

################################# BLOQUE N° 5 ####################################### 
    $tra = new Login();
    $detalle = $tra->VerDetallesCotizaciones();
    $cantidad = 0;
    $SubTotal = 0;

     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(8,66,10,25,25,15,16,25));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){ 
    $cantidad += $detalle[$i]['cantcotizacion'];
    $valortotal = $detalle[$i]["precioventa"]*$detalle[$i]["cantcotizacion"];
    $SubTotal += $detalle[$i]['valorneto'];

    $this->SetX(10);
    $this->SetFont('Courier','',7);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->RowFacture2(array($a++,
        portales(utf8_decode($detalle[$i]["producto"].$observacion = ($detalle[$i]['detallesobservaciones'] == '' ? "" : "(".$detalle[$i]['detallesobservaciones'].")").$salsas = ($detalle[$i]['detallesalsas'] == '' ? "" : "(".$detalle[$i]['detallesalsas'].")"))),
        utf8_decode($detalle[$i]["cantcotizacion"]),
        utf8_decode($simbolo.number_format($detalle[$i]['precioventa'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($detalle[$i]['valortotal'], 2, '.', ',')),
        utf8_decode(number_format($detalle[$i]['descproducto'], 2, '.', ',')),
        utf8_decode($detalle[$i]["ivaproducto"] != "0.00" ? $detalle[$i]["ivaproducto"] : "(E)"),
        utf8_decode($simbolo.number_format($detalle[$i]['valorneto'], 2, '.', ','))));
  }
################################# BLOQUE N° 5 #######################################  

########################### BLOQUE N° 6 #############################    
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 250, 110, 26, '1.5', '');

    $this->SetFont('courier','B',12);
    $this->SetXY(36, 250);
    $this->Cell(20, 5, 'INFORMACIÓN ADICIONAL', 0 , 0);
    
    $this->SetFont('courier','B',8);
    $this->SetXY(11, 254);
    $this->Cell(20, 5, 'CANTIDAD DE PRODUCTOS:', 0 , 0);
    $this->SetXY(56, 254);
    $this->SetFont('courier','',8);
    $this->Cell(20, 5,utf8_decode(number_format($cantidad, 2, '.', ',')), 0 , 0);
    
    $this->SetFont('courier','B',8);
    $this->SetXY(11, 258);
    $this->Cell(20, 5, 'TIPO DE DOCUMENTO:', 0 , 0);
    $this->SetXY(56, 258);
    $this->SetFont('courier','',8);
    $this->Cell(20, 5,"COTIZACIÓN", 0 , 0);

    $this->SetFont('courier','B',8);
    $this->SetXY(11, 263);
    $this->MultiCell(106,2.5,$this->SetFont('Courier','',7).utf8_decode(numtoletras(number_format($reg[0]["totalpago"], 2, '.', ''))),0,'J');

    //Linea de membrete Nro 5
    $this->SetFont('courier','B',7);
    $this->SetXY(11, 266);
    $this->MultiCell(106,3,$this->SetFont('Courier','',7).utf8_decode($reg[0]["observaciones"]=="" ? "" : "OBSERVACIONES: ".$reg[0]["observaciones"]), 0,'J');
########################### BLOQUE N° 6 ############################# 

################################# BLOQUE N° 7 #######################################  
    //Bloque de Totales de factura
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(122, 250, 78, 26, '1.5', '');

    //Linea de membrete Nro 1
    $this->SetFont('courier','B',9);
    $this->SetXY(124, 249.5);
    $this->CellFitSpace(36, 5, 'SUBTOTAL:', 0, 0);
    $this->SetXY(160, 249.5);
    $this->SetFont('courier','',9);
    $this->CellFitSpace(40, 5,utf8_decode($simbolo.number_format($reg[0]['subtotalivasi']+$reg[0]['subtotalivano'], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 2
    $this->SetFont('courier','B',9);
    $this->SetXY(124, 252.5);
    $this->CellFitSpace(36, 5, 'GRAVADO ('.number_format($reg[0]["iva"], 2, '.', ',').'%):', 0, 0);
    $this->SetXY(160, 252.5);
    $this->SetFont('courier','',9);
    $this->CellFitSpace(40, 5,utf8_decode($simbolo.number_format($reg[0]["subtotalivasi"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 3
    $this->SetFont('courier','B',9);
    $this->SetXY(124, 255.5);
    $this->CellFitSpace(36, 5, 'EXENTO (0%):', 0, 0);
    $this->SetXY(160, 255.5);
    $this->SetFont('courier','',9);
    $this->CellFitSpace(40, 5,utf8_decode($simbolo.number_format($reg[0]["subtotalivano"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 4
    $this->SetFont('courier','B',9);
    $this->SetXY(124, 258.5);
    $this->CellFitSpace(36, 5, $impuesto == '' ? "TOTAL IMP." : "TOTAL ".$impuesto." (".number_format($reg[0]["iva"], 2, '.', ',')."%):", 0, 0);
    $this->SetXY(160, 258.5);
    $this->SetFont('courier','',9);
    $this->CellFitSpace(40, 5,utf8_decode($simbolo.number_format($reg[0]["totaliva"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 3
    $this->SetFont('courier','B',9);
    $this->SetXY(124, 261.5);
    $this->CellFitSpace(36, 5, 'DESCONTADO %:', 0, 0);
    $this->SetXY(160, 261.5);
    $this->SetFont('courier','',9);
    $this->CellFitSpace(40, 5,utf8_decode($simbolo.number_format($reg[0]["descontado"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 5
    $this->SetFont('courier','B',9);
    $this->SetXY(124, 264.5);
    $this->CellFitSpace(36, 5, "DESC. GLOBAL (".number_format($reg[0]["descuento"], 2, '.', ',').'%):', 0, 0);
    $this->SetXY(160, 264.5);
    $this->SetFont('courier','',9);
    $this->CellFitSpace(40, 5,utf8_decode($simbolo.number_format($reg[0]["totaldescuento"], 2, '.', ',')), 0, 0, "R");

    //Linea de membrete Nro 6
    $this->SetFont('courier','B',9);
    $this->SetXY(124, 267.5);
    $this->CellFitSpace(36, 5, 'IMPORTE TOTAL:', 0, 0);
    $this->SetXY(160, 267.5);
    $this->SetFont('courier','',9);
    $this->CellFitSpace(40, 5,utf8_decode($simbolo.number_format($reg[0]["totalpago"], 2, '.', ',')), 0, 0, "R");
################################# BLOQUE N° 7 ####################################### 
}
########################## FUNCION FACTURA COTIZACION ##############################

########################## FUNCION LISTAR COTIZACIONES ##############################
function TablaListarCotizaciones()
{
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->ListarCotizaciones();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COTIZACIONES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(35,8,'Nº DE COTIZACIÓN',1,0,'C', True);
    $this->Cell(40,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(35,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(25,8,'Nº ARTIC.',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'IMPORTE TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,35,40,35,35,25,35,25,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),utf8_decode($reg[$i]["codcotizacion"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]['observaciones'] == '' ? "***********" : $reg[$i]['observaciones']),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechacotizacion']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
    }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }

    } else { 

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE COTIZACIÓN',1,0,'C', True);
    $this->Cell(55,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(40,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(45,8,'FECHA DE EMISIÓN',1,0,'C', True);
    $this->Cell(25,8,'Nº ARTIC.',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'IMPORTE TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,55,40,45,25,35,30,20,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codcotizacion"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]['observaciones'] == '' ? "***********" : $reg[$i]['observaciones']),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechacotizacion']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
    }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COTIZACIONES ##############################

####################### FUNCION LISTAR COTIZACIONES POR FECHAS ########################
function TablaListarCotizacionesxFechas()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarCotizacionesxFechas();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE COTIZACIONES POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L'); 

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE COTIZACIÓN',1,0,'C', True);
    $this->Cell(50,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(40,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(45,8,'FECHA DE EMISIÓN',1,0,'C', True);
    $this->Cell(25,8,'Nº ARTIC.',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'IMPORTE TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,50,40,45,25,35,30,20,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codcotizacion"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]['observaciones'] == '' ? "***********" : $reg[$i]['observaciones']),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechacotizacion']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
    }
   
    $this->Cell(185,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }
   

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COTIZACIONES POR FECHAS ######################

####################### FUNCION LISTAR DETALLES COTIZACIONES POR FECHAS ###########################
function TablaListarDetallesCotizacionesxFechas()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == '' ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == '' ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarDetallesCotizacionesxFechas(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE DETALLES COTIZACIONES POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'TIPO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(30,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(40,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,'COTIZADO',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(40,8,'MONTO TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,30,70,30,40,30,20,30,30,40));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $VendidosTotal=0;
    $TotalDescuento=0;
    $TotalImpuesto=0;
    $PagoTotal=0;

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal+=$reg[$i]['precioventa'];

    if($reg[$i]['tipo'] == 1){

        $Tipo="PRODUCTO";
        $Categoria=$reg[$i]['nomcategoria'];
        $Existencia=$reg[$i]['existencia'];
        $ExisteTotal+=$reg[$i]['existencia'];

    } elseif($reg[$i]['tipo'] == 2){

        $Tipo="COMBO";
        $Categoria="********";
        $Existencia=$reg[$i]['cantcombo'];
        $ExisteTotal+=$reg[$i]['cantcombo'];

    } else {

        $Tipo="EXTRA";
        $Categoria=$reg[$i]['nommedida'];
        $Existencia=$reg[$i]['cantingrediente'];
        $ExisteTotal+=$reg[$i]['cantingrediente'];
    }

    $VendidosTotal+=$reg[$i]['cantidad'];

    $Descuento = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $CalculoDescuento = $PrecioDescuento*$reg[$i]['cantidad'];
    $PrecioFinal = $reg[$i]['precioventa']-$PrecioDescuento;

    $ivg = $reg[$i]['ivaproducto']/100;
    $SubtotalImpuesto = $PrecioFinal*$ivg;
    $CalculoImpuesto = $SubtotalImpuesto*$reg[$i]['cantidad'];

    $TotalDescuento+=$CalculoDescuento; 
    $TotalImpuesto+=$CalculoImpuesto; 
    $PagoTotal+=$PrecioFinal*$reg[$i]['cantidad']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($Tipo),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($Categoria),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoImpuesto, 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoDescuento, 2, '.', ',')),
        utf8_decode($simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 2, '.', ','))));
  }
   }
   
    $this->Cell(145,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PrecioTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode(number_format($VendidosTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR DETALLES COTIZACIONES POR FECHAS ##########################

####################### FUNCION LISTAR PRODUCTOS COTIZADOS POR VENDEDOR ###########################
function TablaListarDetallesCotizacionesxVendedor()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == '' ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == '' ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->BuscarDetallesCotizacionesxVendedor(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE DETALLES COTIZACIONES POR VENDEDOR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"VENDEDOR: ".portales(utf8_decode($reg[0]['nombres'])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'TIPO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(30,8,'CATEGORIA',1,0,'C', True);
    $this->Cell(40,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(20,8,'COTIZADO',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(40,8,'MONTO TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,30,70,30,40,30,20,30,30,40));

    $PrecioTotal=0;
    $ExisteTotal=0;
    $VendidosTotal=0;
    $TotalDescuento=0;
    $TotalImpuesto=0;
    $PagoTotal=0;

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal+=$reg[$i]['precioventa'];

    if($reg[$i]['tipo'] == 1){

        $Tipo="PRODUCTO";
        $Categoria=$reg[$i]['nomcategoria'];
        $Existencia=$reg[$i]['existencia'];
        $ExisteTotal+=$reg[$i]['existencia'];

    } elseif($reg[$i]['tipo'] == 2){

        $Tipo="COMBO";
        $Categoria="********";
        $Existencia=$reg[$i]['cantcombo'];
        $ExisteTotal+=$reg[$i]['cantcombo'];

    } else {

        $Tipo="EXTRA";
        $Categoria=$reg[$i]['nommedida'];
        $Existencia=$reg[$i]['cantingrediente'];
        $ExisteTotal+=$reg[$i]['cantingrediente'];
    }

    $VendidosTotal+=$reg[$i]['cantidad'];

    $Descuento = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $CalculoDescuento = $PrecioDescuento*$reg[$i]['cantidad'];
    $PrecioFinal = $reg[$i]['precioventa']-$PrecioDescuento;

    $ivg = $reg[$i]['ivaproducto']/100;
    $SubtotalImpuesto = $PrecioFinal*$ivg;
    $CalculoImpuesto = $SubtotalImpuesto*$reg[$i]['cantidad'];

    $TotalDescuento+=$CalculoDescuento; 
    $TotalImpuesto+=$CalculoImpuesto; 
    $PagoTotal+=$PrecioFinal*$reg[$i]['cantidad']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($Tipo),
        portales(utf8_decode($reg[$i]["producto"])),
        utf8_decode($Categoria),
        utf8_decode($simbolo.number_format($reg[$i]["precioventa"], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['existencia'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoImpuesto, 2, '.', ',')),
        utf8_decode($simbolo.number_format($CalculoDescuento, 2, '.', ',')),
        utf8_decode($simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 2, '.', ','))));
  }
   }
   
    $this->Cell(145,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PrecioTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode(number_format($ExisteTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode(number_format($VendidosTotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();
   

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR PRODUCTOS COTIZADOS POR VENDEDOR ##########################

########################### REPORTES DE COTIZACIONES ############################







































########################### REPORTES DE CAJAS DE VENTAS ##############################

########################## FUNCION LISTAR CAJAS ASIGNADAS ##############################
function TablaListarCajas()
   {

    $tra = new Login();
    $reg = $tra->ListarCajas();

    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE CAJAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(45,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(30,8,'Nº DE CAJA',1,0,'C', True);
    $this->Cell(50,8,'NOMBRE DE CAJA',1,0,'C', True);
    $this->Cell(55,8,'RESPONSABLE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,45,30,50,55));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),utf8_decode($reg[$i]["nrocaja"]),utf8_decode($reg[$i]['nomcaja']),utf8_decode($reg[$i]["nombres"])));
       }
      }
    } else {

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE CAJA',1,0,'C', True);
    $this->Cell(55,8,'NOMBRE DE CAJA',1,0,'C', True);
    $this->Cell(90,8,'RESPONSABLE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,55,90));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["nrocaja"]),utf8_decode($reg[$i]['nomcaja']),utf8_decode($reg[$i]["nombres"])));
         }
      }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CAJAS ASIGNADAS ##############################

########################## FUNCION TICKET CIERRE ARQUEO ##############################



function TicketCierre()
{   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ListarArqueoCaja();
    $reg = $reg[0]; // Selecciona el primer y más reciente arqueo
    $simbolo = ($reg['simbolo'] == "" ? "" : $reg['simbolo']);
    
    if (file_exists("fotos/sucursales/".$reg['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg['cuitsucursal'].".png";
    $this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);

    }
    
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE CIERRE", 0, 0, 'C');
    $this->Ln(5);
    
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reg['nomsucursal']), 0, 1, 'C');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(66,3,$reg['documsucursal'] == '0' ? "" : "Nº ".$reg['documento']." ".utf8_decode($reg['cuitsucursal']),0,1,'C');

    if(isset($reg['id_provincia']) && $reg['id_provincia']!='0' && isset($reg['provincia']) && isset($reg['departamento'])){

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg['provincia']." ".$reg['departamento']),0,1,'C');

    }

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg['direcsucursal']),0,1,'C');

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg['correosucursal']),0,1,'C');

    $this->SetX(4);
    $this->CellFitSpace(66,3,"OBLIGADO A LLEVAR CONTABILIDAD: ".utf8_decode($reg['llevacontabilidad']),0,1,'C');

    $this->SetX(4);
    $this->CellFitSpace(66,3,"AMBIENTE: PRODUCCIÓN",0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,"EMISIÓN: NORMAL",0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJA Nº:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg['nrocaja']."-".$reg['nomcaja']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg['nombres']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s"),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"HORA APERTURA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode(date("d-m-Y H:i:s",strtotime($reg['fechaapertura']))),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"HORA CIERRE:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode(date("d-m-Y H:i:s",strtotime($reg['fechacierre']))),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"MONTO APERTURA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($simbolo.number_format($reg["montoinicial"], 2, '.', ',')),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"TIPOS DOCUMENTOS",0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"CANT. TICKET:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($reg['nroticket']),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"CANT. BOLETA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($reg['nroboleta']),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"CANT. FACTURA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($reg['nrofactura']),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"CANT. N. CRÉDITO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($reg["nronota"]),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"DESGLOSE EN VENTAS",0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"EFECTIVO BS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["efectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"EFECTIVO $:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["cheque"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PAGO MOVIL:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["tcredito"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"YUMMY:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["tdebito"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"CONSUMO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["tprepago"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"BANFANB:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["transferencia"], 2, '.', ',')),0,1,'R');

    //$this->SetX(4);
    //$this->SetFont('Courier','B',8);
    //$this->CellFitSpace(30,3,"DIN. ELECTRÓNICO:",0,0,'L');
    //$this->SetFont('Courier',"B",8);
    //$this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["electronico"], 2, '.', ',')),0,1,'R');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"DEBITO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["otros"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"ZELLE:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["cupon"], 2, '.', ',')),0,1,'R');

    

    
    
    //$this->SetX(4);
    //$this->SetFont('Courier','B',8);
    //$this->CellFitSpace(30,3,"OTROS:",0,0,'L');
    //$this->SetFont('Courier',"B",8);
    //$this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["otros"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"PROPINAS",0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PROPINAS EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["propinasefectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PROPINAS OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["propinasotros"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"ABONO EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["abonosefectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"ABONO OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["abonosotros"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    // NUEVA SECCIÓN: PAGOS Y PROPINAS RECIBIDAS
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"RESUMEN DE PAGOS",0,1,'L');

    $TotalPagosRecibidos = $reg['efectivo']+$reg['cheque']+$reg['tcredito']+$reg['tdebito']+$reg['tprepago']+$reg['transferencia']+$reg['electronico']+$reg['cupon']+$reg['otros']+$reg["propinasefectivo"]+$reg["propinasotros"];
    $TotalPropinasRecibidas = $reg["propinasefectivo"]+$reg["propinasotros"];

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PAGOS RECIBIDOS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalPagosRecibidos, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PROPINAS RECIBIDAS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalPropinasRecibidas, 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);
    // FIN DE LA NUEVA SECCIÓN

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"MOVIMIENTOS EN CAJA",0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"INGRESO EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["ingresosefectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"INGRESOS OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["ingresosotros"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"EGRESOS EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["egresos"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"NOTAS DE CRÉDITO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["egresonotas"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"BALANCE EN CAJA",0,1,'L');

    // AQUÍ ESTÁ LA CORRECCIÓN
    // Se calcula el TotalVentas sumando cada método de pago disponible
    $TotalVentas = $reg['efectivo']+$reg['cheque']+$reg['tcredito']+$reg['tdebito']+$reg['tprepago']+$reg['transferencia']+$reg['electronico']+$reg['cupon']+$reg['otros'];

    $VentaOtros = $reg['cheque']+$reg['tcredito']+$reg['tdebito']+$reg['tprepago']+$reg['transferencia']+$reg['electronico']+$reg['cupon']+$reg['otros'];

    $TotalEfectivo = $reg['montoinicial']+$reg['efectivo']+$reg['propinasefectivo']+$reg['ingresosefectivo']+$reg['abonosefectivo']-$reg['egresos'];

    $TotalOtros = $reg['cheque']+$reg['tcredito']+$reg['tdebito']+$reg['tprepago']+$reg['transferencia']+$reg['electronico']+$reg['cupon']+$reg['otros']+$reg['abonosotros']+$reg['propinasotros']+$reg['ingresosotros'];

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TOTAL EN VENTAS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalVentas, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"VENTAS EN EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg['efectivo'], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"VENTAS OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($VentaOtros, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TOTAL EN EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalEfectivo, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TOTAL OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalOtros, 2, '.', ',')),0,1,'R');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PROPINAS DEL DIA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg['propinasefectivo']+$reg['propinasotros'], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"EFECTIVO EN CAJA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg["dineroefectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"DIF. EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    // Cálculo de la diferencia
    $diferencia = $reg["dineroefectivo"] - $TotalEfectivo;
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($diferencia, 2, '.', ',')),0,1,'R');


    if($reg["comentarios"]==""){

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);

    } else {    

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(4);
    $this->MultiCell(65,4,$this->SetFont('Courier',"",7).utf8_decode($reg["comentarios"]),0,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);

    }
 
    $this->SetFont('Courier','BI',9);
    $this->SetX(4);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66,3,"GRACIAS POR SU ATENCIÓN",0,1,'C');
    $this->Ln(3);
            
}













/*
function TicketCierre()
{   
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->ArqueoCajaPorId();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
   
    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);

    }
   
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE CIERRE", 0, 0, 'C');
    $this->Ln(5);
   
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(66,3,$reg[0]['documsucursal'] == '0' ? "" : "Nº ".$reg[0]['documento']." ".utf8_decode($reg[0]['cuitsucursal']),0,1,'C');

    if($reg[0]['id_provincia']!='0'){

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia'])." ".$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento'])),0,1,'C');

    }

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg[0]['direcsucursal']),0,1,'C');

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg[0]['correosucursal']),0,1,'C');

    $this->SetX(4);
    $this->CellFitSpace(66,3,"OBLIGADO A LLEVAR CONTABILIDAD: ".utf8_decode($reg[0]['llevacontabilidad']),0,1,'C');

    $this->SetX(4);
    $this->CellFitSpace(66,3,"AMBIENTE: PRODUCCIÓN",0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,"EMISIÓN: NORMAL",0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJA Nº:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nrocaja']."-".$reg[0]['nomcaja']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nombres']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s"),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"HORA APERTURA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode(date("d-m-Y H:i:s",strtotime($reg[0]['fechaapertura']))),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"HORA CIERRE:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode(date("d-m-Y H:i:s",strtotime($reg[0]['fechacierre']))),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"MONTO APERTURA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($simbolo.number_format($reg[0]["montoinicial"], 2, '.', ',')),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"TIPOS DOCUMENTOS",0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"CANT. TICKET:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($reg[0]['nroticket']),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"CANT. BOLETA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($reg[0]['nroboleta']),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"CANT. FACTURA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($reg[0]['nrofactura']),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"CANT. N. CRÉDITO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode($reg[0]["nronota"]),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"DESGLOSE EN VENTAS",0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["efectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"CHEQUE:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["cheque"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TARJ. CRÉDITO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["tcredito"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TARJ. DÉBITO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["tdebito"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TARJ. PREPAGO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["tprepago"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TRANSFERENCIA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["transferencia"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"DIN. ELECTRÓNICO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["electronico"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"CUPÓN:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["cupon"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["otros"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"CRÉDITOS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["creditos"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"PROPINAS",0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PROPINAS EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["propinasefectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PROPINAS OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["propinasotros"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"ABONO EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["abonosefectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"ABONO OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["abonosotros"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    // NUEVA SECCIÓN: PAGOS Y PROPINAS RECIBIDAS
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"RESUMEN DE PAGOS",0,1,'L');

    $TotalPagosRecibidos = $reg[0]['efectivo']+$reg[0]['cheque']+$reg[0]['tcredito']+$reg[0]['tdebito']+$reg[0]['tprepago']+$reg[0]['transferencia']+$reg[0]['electronico']+$reg[0]['cupon']+$reg[0]['otros']+$reg[0]["propinasefectivo"]+$reg[0]["propinasotros"];
    $TotalPropinasRecibidas = $reg[0]["propinasefectivo"]+$reg[0]["propinasotros"];

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PAGOS RECIBIDOS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalPagosRecibidos, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PROPINAS RECIBIDAS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalPropinasRecibidas, 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);
    // FIN DE LA NUEVA SECCIÓN

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"MOVIMIENTOS EN CAJA",0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"INGRESO EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["ingresosefectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"INGRESOS OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["ingresosotros"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"EGRESOS EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["egresos"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"NOTAS DE CRÉDITO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["egresonotas"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,3,"BALANCE EN CAJA",0,1,'L');

    $TotalVentas = $reg[0]['efectivo']+$reg[0]['cheque']+$reg[0]['tcredito']+$reg[0]['tdebito']+$reg[0]['tprepago']+$reg[0]['transferencia']+$reg[0]['electronico']+$reg[0]['cupon']+$reg[0]['otros'];

    $VentaOtros = $reg[0]['cheque']+$reg[0]['tcredito']+$reg[0]['tdebito']+$reg[0]['tprepago']+$reg[0]['transferencia']+$reg[0]['electronico']+$reg[0]['cupon']+$reg[0]['otros'];

    $TotalEfectivo = $reg[0]['montoinicial']+$reg[0]['efectivo']+$reg[0]['propinasefectivo']+$reg[0]['ingresosefectivo']+$reg[0]['abonosefectivo']-$reg[0]['egresos'];

    $TotalOtros = $reg[0]['cheque']+$reg[0]['tcredito']+$reg[0]['tdebito']+$reg[0]['tprepago']+$reg[0]['transferencia']+$reg[0]['electronico']+$reg[0]['cupon']+$reg[0]['otros']+$reg[0]['abonosotros']+$reg[0]['propinasotros']+$reg[0]['ingresosotros'];

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TOTAL EN VENTAS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalVentas, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"VENTAS EN EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]['efectivo'], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"VENTAS OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($VentaOtros, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TOTAL EN EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalEfectivo, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"TOTAL OTROS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($TotalOtros, 2, '.', ',')),0,1,'R');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"PROPINAS DEL DIA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["propinasefectivo"]+$reg[0]["propinasotros"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"EFECTIVO EN CAJA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["dineroefectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"DIF. EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(36,3,utf8_decode($simbolo.number_format($reg[0]["diferencia"], 2, '.', ',')),0,1,'R');


    if($reg[0]["comentarios"]==""){

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);

   } else { 

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(4);
    $this->MultiCell(65,4,$this->SetFont('Courier',"",7).utf8_decode($reg[0]["comentarios"]),0,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);

    }
 
    $this->SetFont('Courier','BI',9);
    $this->SetX(4);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66,3,"GRACIAS POR SU ATENCIÓN",0,1,'C');
    $this->Ln(3);
        
}


*/

########################## FUNCION TICKET CIERRE ARQUEO ##############################

########################## FUNCION LISTAR ARQUEOS DE CAJAS ##############################
function TablaListarArqueos()
   {
    $tra = new Login();
    $reg = $tra->ListarArqueoCaja();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE ARQUEOS EN CAJAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(40,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(28,8,'Nº DE CAJA',1,0,'C', True);
    $this->Cell(24,8,'INICIO',1,0,'C', True);
    $this->Cell(23,8,'CIERRE',1,0,'C', True);
    $this->Cell(23,8,'INICIAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL VENTAS',1,0,'C', True);
    $this->Cell(35,8,'TOTAL EFECT.',1,0,'C', True);
    $this->Cell(22,8,'EGRESOS',1,0,'C', True);
    $this->Cell(35,8,'EFECT. ESTIMADO',1,0,'C', True);
    $this->Cell(35,8,'EFECT. EN CAJA',1,0,'C', True);
    $this->Cell(25,8,'DIFERENCIA',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,40,28,24,23,23,35,35,22,35,35,25));

$TotalVentas = 0;
$VentasEfectivo = 0;
$VentasOtros = 0;
$OtrosEfectivo = 0;
$TotalCreditos = 0;
$AbonosEfectivo = 0;
$AbonosOtros = 0;
$IngresosEfectivo = 0;
$IngresosOtros = 0;
$TotalEgresos = 0;
$PropinasEfectivo = 0;
$PropinasOtros = 0;
$TotalEfectivo = 0;
$TotalCaja = 0;
$TotalDiferencia = 0;

$a=1; 
for($i=0;$i<sizeof($reg);$i++){
$simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

$TotalVentas += $reg[$i]['efectivo']+$reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'];

$VentasEfectivo += $reg[$i]['efectivo'];

$VentasOtros += $reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'];

$OtrosEfectivo += $reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo'];

$TotalEfectivo += $reg[$i]['montoinicial']+$reg[$i]['efectivo']+$reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo']-$reg[$i]['egresos'];

$TotalOtros = $reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros']+$reg[$i]['abonosotros']+$reg[$i]['propinasotros']+$reg[$i]['ingresosotros'];

$TotalCreditos += $reg[$i]['creditos'];
$AbonosEfectivo += $reg[$i]['abonosefectivo'];
$AbonosOtros += $reg[$i]['abonosotros'];
$IngresosEfectivo += $reg[$i]['ingresosefectivo'];
$IngresosOtros += $reg[$i]['ingresosotros'];
$TotalEgresos += $reg[$i]['egresos'];
$PropinasEfectivo += $reg[$i]['propinasefectivo'];
$PropinasOtros += $reg[$i]['propinasotros'];
$TotalCaja += $reg[$i]['dineroefectivo'];
$TotalDiferencia += $reg[$i]['diferencia'];
        
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),
        utf8_decode($reg[$i]['nrocaja'].": ".$reg[$i]['nomcaja']),
        utf8_decode( date("d-m-Y H:i:s",strtotime($reg[$i]['fechaapertura']))),
    utf8_decode($reg[$i]['fechacierre'] == '0000-00-00 00:00:00' ? "*********" : date("d-m-Y H:i:s",strtotime($reg[$i]['fechacierre']))),
        utf8_decode($simbolo.number_format($reg[$i]['montoinicial'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['efectivo']+$reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['efectivo'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['egresos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['montoinicial']+$reg[$i]['efectivo']+$reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo']-$reg[$i]['egresos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['dineroefectivo'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['diferencia'], 2, '.', ','))));
   }
   
    $this->Cell(148,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalVentas, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($VentasEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(22,5,utf8_decode($simbolo.number_format($TotalEgresos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalCaja, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDiferencia, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }

    } else {

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(24,8,'Nº DE CAJA',1,0,'C', True);
    $this->Cell(24,8,'INICIO',1,0,'C', True);
    $this->Cell(23,8,'CIERRE',1,0,'C', True);
    $this->Cell(23,8,'INICIAL',1,0,'C', True);
    $this->Cell(34,8,'TOTAL VENTAS',1,0,'C', True);
    $this->Cell(28,8,'TOTAL EFECT.',1,0,'C', True);
    $this->Cell(28,8,'TOTAL OTROS',1,0,'C', True);
    $this->Cell(28,8,'OTROS EFECT.',1,0,'C', True);
    $this->Cell(22,8,'EGRESOS',1,0,'C', True);
    $this->Cell(33,8,'EFECT. ESTIMADO',1,0,'C', True);
    $this->Cell(33,8,'EFECT. EN CAJA',1,0,'C', True);
    $this->Cell(25,8,'DIFERENCIA',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,24,24,23,23,34,28,28,28,22,33,33,25));

$TotalVentas = 0;
$VentasEfectivo = 0;
$VentasOtros = 0;
$OtrosEfectivo = 0;
$TotalCreditos = 0;
$AbonosEfectivo = 0;
$AbonosOtros = 0;
$IngresosEfectivo = 0;
$IngresosOtros = 0;
$TotalEgresos = 0;
$PropinasEfectivo = 0;
$PropinasOtros = 0;
$TotalEfectivo = 0;
$TotalCaja = 0;
$TotalDiferencia = 0;

$a=1; 
for($i=0;$i<sizeof($reg);$i++){
$simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

$TotalVentas += $reg[$i]['efectivo']+$reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'];

$VentasEfectivo += $reg[$i]['efectivo'];

$VentasOtros += $reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'];

$OtrosEfectivo += $reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo'];

$TotalEfectivo += $reg[$i]['montoinicial']+$reg[$i]['efectivo']+$reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo']-$reg[$i]['egresos'];

$TotalOtros = $reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros']+$reg[$i]['abonosotros']+$reg[$i]['propinasotros']+$reg[$i]['ingresosotros'];

$TotalCreditos += $reg[$i]['creditos'];
$AbonosEfectivo += $reg[$i]['abonosefectivo'];
$AbonosOtros += $reg[$i]['abonosotros'];
$IngresosEfectivo += $reg[$i]['ingresosefectivo'];
$IngresosOtros += $reg[$i]['ingresosotros'];
$TotalEgresos += $reg[$i]['egresos'];
$PropinasEfectivo += $reg[$i]['propinasefectivo'];
$PropinasOtros += $reg[$i]['propinasotros'];
$TotalCaja += $reg[$i]['dineroefectivo'];
$TotalDiferencia += $reg[$i]['diferencia'];
        
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]['nrocaja'].": ".$reg[$i]['nomcaja']),
        utf8_decode( date("d-m-Y H:i:s",strtotime($reg[$i]['fechaapertura']))),
    utf8_decode($reg[$i]['fechacierre'] == '0000-00-00 00:00:00' ? "*********" : date("d-m-Y H:i:s",strtotime($reg[$i]['fechacierre']))),
        utf8_decode($simbolo.number_format($reg[$i]['montoinicial'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['efectivo']+$reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['efectivo'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['egresos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['montoinicial']+$reg[$i]['efectivo']+$reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo']-$reg[$i]['egresos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['dineroefectivo'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['diferencia'], 2, '.', ','))));
   }
   
    $this->Cell(104,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(34,5,utf8_decode($simbolo.number_format($TotalVentas, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(28,5,utf8_decode($simbolo.number_format($VentasEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(28,5,utf8_decode($simbolo.number_format($VentasOtros, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(28,5,utf8_decode($simbolo.number_format($OtrosEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(22,5,utf8_decode($simbolo.number_format($TotalEgresos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(33,5,utf8_decode($simbolo.number_format($TotalEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(33,5,utf8_decode($simbolo.number_format($TotalCaja, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDiferencia, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR ARQUEOS DE CAJAS ##############################

####################### FUNCION LISTAR ARQUEOS DE CAJAS POR FECHAS ######################
function TablaListarArqueosxFechas()
   {

    $tra = new Login();
    $reg = $tra->BuscarArqueosxFechas();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE ARQUEOS POR CAJA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"CAJA Nº: ".utf8_decode($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"RESPONSABLE: ".utf8_decode($reg[0]["nombres"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(24,8,'INICIO',1,0,'C', True);
    $this->Cell(24,8,'CIERRE',1,0,'C', True);
    $this->Cell(26,8,'INICIAL',1,0,'C', True);
    $this->Cell(36,8,'TOTAL VENTAS',1,0,'C', True);
    $this->Cell(28,8,'TOTAL EFECT.',1,0,'C', True);
    $this->Cell(28,8,'TOTAL OTROS',1,0,'C', True);
    $this->Cell(28,8,'OTROS EFECT.',1,0,'C', True);
    $this->Cell(26,8,'EGRESOS',1,0,'C', True);
    $this->Cell(36,8,'EFECT. ESTIMADO',1,0,'C', True);
    $this->Cell(36,8,'EFECT. EN CAJA',1,0,'C', True);
    $this->Cell(28,8,'DIFERENCIA',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,24,24,26,36,28,28,28,26,36,36,28));

    $TotalVentas = 0;
$VentasEfectivo = 0;
$VentasOtros = 0;
$OtrosEfectivo = 0;
$TotalCreditos = 0;
$AbonosEfectivo = 0;
$AbonosOtros = 0;
$IngresosEfectivo = 0;
$IngresosOtros = 0;
$TotalEgresos = 0;
$PropinasEfectivo = 0;
$PropinasOtros = 0;
$TotalEfectivo = 0;
$TotalCaja = 0;
$TotalDiferencia = 0;

$a=1; 
for($i=0;$i<sizeof($reg);$i++){
$simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

$TotalVentas += $reg[$i]['efectivo']+$reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'];

$VentasEfectivo += $reg[$i]['efectivo'];

$VentasOtros += $reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'];

$OtrosEfectivo += $reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo'];

$TotalEfectivo += $reg[$i]['montoinicial']+$reg[$i]['efectivo']+$reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo']-$reg[$i]['egresos'];

$TotalOtros = $reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros']+$reg[$i]['abonosotros']+$reg[$i]['propinasotros']+$reg[$i]['ingresosotros'];

$TotalCreditos += $reg[$i]['creditos'];
$AbonosEfectivo += $reg[$i]['abonosefectivo'];
$AbonosOtros += $reg[$i]['abonosotros'];
$IngresosEfectivo += $reg[$i]['ingresosefectivo'];
$IngresosOtros += $reg[$i]['ingresosotros'];
$TotalEgresos += $reg[$i]['egresos'];
$PropinasEfectivo += $reg[$i]['propinasefectivo'];
$PropinasOtros += $reg[$i]['propinasotros'];
$TotalCaja += $reg[$i]['dineroefectivo'];
$TotalDiferencia += $reg[$i]['diferencia'];
        
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode( date("d-m-Y H:i:s",strtotime($reg[$i]['fechaapertura']))),
    utf8_decode($reg[$i]['fechacierre'] == '0000-00-00 00:00:00' ? "*********" : date("d-m-Y H:i:s",strtotime($reg[$i]['fechacierre']))),
        utf8_decode($simbolo.number_format($reg[$i]['montoinicial'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['efectivo']+$reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['efectivo'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['cheque']+$reg[$i]['tcredito']+$reg[$i]['tdebito']+$reg[$i]['tprepago']+$reg[$i]['transferencia']+$reg[$i]['electronico']+$reg[$i]['cupon']+$reg[$i]['otros'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['egresos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['montoinicial']+$reg[$i]['efectivo']+$reg[$i]['ingresosefectivo']+$reg[$i]['abonosefectivo']+$reg[$i]['propinasefectivo']-$reg[$i]['egresos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['dineroefectivo'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['diferencia'], 2, '.', ','))));
   }
   
    $this->Cell(84,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(36,5,utf8_decode($simbolo.number_format($TotalVentas, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(28,5,utf8_decode($simbolo.number_format($VentasEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(28,5,utf8_decode($simbolo.number_format($VentasOtros, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(28,5,utf8_decode($simbolo.number_format($OtrosEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(26,5,utf8_decode($simbolo.number_format($TotalEgresos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(36,5,utf8_decode($simbolo.number_format($TotalEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(36,5,utf8_decode($simbolo.number_format($TotalCaja, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(28,5,utf8_decode($simbolo.number_format($TotalDiferencia, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR ARQUEOS DE CAJAS POR FECHAS ######################

####################### FUNCION LISTAR MOVIMIENTOS EN CAJA ##########################
function TablaListarMovimientos()
   {
    
    $tra = new Login();
    $reg = $tra->ListarMovimientos();
    
    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE MOVIMIENTOS EN CAJA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(30,8,'Nº DE CAJA',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(35,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(30,8,'MEDIO',1,0,'C', True);
    $this->Cell(30,8,'MONTO',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,30,20,35,30,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte=0;
    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $TotalImporte+=$reg[$i]['montomovimiento'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),utf8_decode($reg[$i]['nrocaja'].": ".$reg[$i]['nomcaja']),utf8_decode($reg[$i]["tipomovimiento"]),utf8_decode($reg[$i]['descripcionmovimiento']),utf8_decode($reg[$i]["mediomovimiento"]),utf8_decode($simbolo.number_format($reg[$i]['montomovimiento'], 2, '.', ','))));
   }

    $this->Cell(160,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
        }

    } else {

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(40,8,'Nº DE CAJA',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(55,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(35,8,'MEDIO',1,0,'C', True);
    $this->Cell(30,8,'MONTO',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,40,20,55,35,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte=0;
    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $TotalImporte+=$reg[$i]['montomovimiento'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['nrocaja'].": ".$reg[$i]['nomcaja']),utf8_decode($reg[$i]["tipomovimiento"]),utf8_decode($reg[$i]['descripcionmovimiento']),utf8_decode($reg[$i]["mediomovimiento"]),utf8_decode($simbolo.number_format($reg[$i]['montomovimiento'], 2, '.', ','))));
   }

    $this->Cell(160,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
        }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR MOVIMIENTOS EN CAJAS #########################

##################### FUNCION LISTAR MOVIMIENTOS EN CAJA POR FECHAS #####################
function TablaListarMovimientosxFechas()
   {
    
    $tra = new Login();
    $reg = $tra->BuscarMovimientosxFechas();

    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,7,'LISTADO DE MOVIMIENTOS POR CAJA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(190,5,"CAJA Nº: ".utf8_decode($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"]),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"RESPONSABLE: ".utf8_decode($reg[0]["nombres"]),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(75,8,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(45,8,'MEDIO',1,0,'C', True);
    $this->Cell(40,8,'MONTO',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,20,75,45,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte=0;
    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $TotalImporte+=$reg[$i]['montomovimiento'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["tipomovimiento"]),utf8_decode($reg[$i]['descripcionmovimiento']),utf8_decode($reg[$i]["mediomovimiento"]),utf8_decode($simbolo.number_format($reg[$i]['montomovimiento'], 2, '.', ','))));
   }
}

    $this->Cell(150,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
##################### FUNCION LISTAR MOVIMIENTOS EN CAJAS POR FECHAS ###################

########################## FUNCION INFORME DE CAJAS POR FECHAS ##############################
function InformeCajasxFechas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $caja = new Login();
    $caja = $caja->CajasPorId();
    $simbolo = ($caja[0]['simbolo'] == "" ? "" : $caja[0]['simbolo']);

    $venta = new Login();
    $venta = $venta->SumarVentasCajasxFechas();

    $arqueo = new Login();
    $arqueo = $arqueo->SumarArqueosCajasxFechas();

    $balance = $venta[0]['totalventa']-$venta[0]['totaliva']+$arqueo[0]['totalingresos']+$arqueo[0]['totalabonos'];
    $ganancias = $balance-$arqueo[0]['totalegresos'];

    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'INFORME DE CAJAS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($caja[0]['documento'])." SUCURSAL: ".utf8_decode($caja[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($caja[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($caja[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"CAJA Nº: ".utf8_decode($caja[0]["nrocaja"].": ".$caja[0]["nomcaja"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"RESPONSABLE: ".utf8_decode($caja[0]["nombres"]),0,1,'L');
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'TOTAL DE VENTAS',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($venta[0]['totalventa'], 2, '.', ',')),0,0,'R');
    $this->Ln();

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'TOTAL DE INGRESOS',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($arqueo[0]['totalingresos'], 2, '.', ',')),0,0,'R');
    $this->Ln();

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'ABONOS A CRÉDITOS',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($arqueo[0]['totalabonos'], 2, '.', ',')),0,0,'R');
    $this->Ln();
   

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'TOTAL DE GASTOS (EGRESOS)',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($arqueo[0]['totalegresos'], 2, '.', ',')),0,0,'R');
    $this->Ln();
  
    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'TOTAL DE IMPUESTOS VENTAS '.$impuesto.' ('.$valor.'%)',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($venta[0]['totaliva'], 2, '.', ',')),0,0,'R');
    $this->Ln();

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'EFECTIVO EN CAJA SIN IVA ',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($ganancias, 2, '.', ',')),0,0,'R');
    $this->Ln();


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION INFORME DE CAJAS POR FECHAS ##############################

############################## REPORTES DE CAJAS DE VENTAS ##############################































################################### REPORTES DE PEDIDOS ##################################

########################## FUNCION LISTAR PEDIDOS ##############################
function TablaListarPedidos()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->ListarPedidos();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PEDIDOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(40,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(50,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,30,50,25,20,30,20,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+= $reg[$i]['articulos'];
    $TotalImporte+= $reg[$i]['totalpago'];
    $TotalAbono+= $reg[$i]['creditopagado'];
    $TotalDebe+= ($reg[$i]['tipopago'] == 'CONTADO' ? "0.00" : $reg[$i]['totalpago']-$reg[$i]['creditopagado']);

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),
        utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),
        utf8_decode($reg[$i]["statuspedido"] == 0 ? "ENTREGADA" : "PENDIENTE"),

        utf8_decode($reg[$i]["tipopago"]),
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),

        utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),
        utf8_decode($reg[$i]['tipopago'] == 'CONTADO' ? $simbolo."0.00" : $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));
   }
   
    $this->Cell(210,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }

    } else {

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(75,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,75,25,20,45,20,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+= $reg[$i]['articulos'];
    $TotalImporte+= $reg[$i]['totalpago'];
    $TotalAbono+= $reg[$i]['creditopagado'];
    $TotalDebe+= ($reg[$i]['tipopago'] == 'CONTADO' ? "0.00" : $reg[$i]['totalpago']-$reg[$i]['creditopagado']);

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),
        utf8_decode($reg[$i]["statuspedido"] == 0 ? "ENTREGADA" : "PENDIENTE"),
        utf8_decode($reg[$i]["tipopago"]),
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),
        utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),
        utf8_decode($reg[$i]['tipopago'] == 'CONTADO' ? $simbolo."0.00" : $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));
   }
   
    $this->Cell(210,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PEDIDOS ##############################

########################## FUNCION LISTAR PEDIDOS DIARIAS ##############################
function TablaListarPedidosDiarias()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->ListarPedidosDiarias();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PEDIDOS DIARIAS DEL (DIA '.date("d-m-Y").")",0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(75,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,75,25,20,45,20,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+= $reg[$i]['articulos'];
    $TotalImporte+= $reg[$i]['totalpago'];
    $TotalAbono+= $reg[$i]['creditopagado'];
    $TotalDebe+= ($reg[$i]['tipopago'] == 'CONTADO' ? "0.00" : $reg[$i]['totalpago']-$reg[$i]['creditopagado']);

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),
        utf8_decode($reg[$i]["statuspedido"] == 0 ? "ENTREGADA" : "PENDIENTE"),
        utf8_decode($reg[$i]["tipopago"]),
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),
        utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),
        utf8_decode($reg[$i]['tipopago'] == 'CONTADO' ? $simbolo."0.00" : $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));
   }
   
    $this->Cell(210,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PEDIDOS DIARIAS ##############################

########################## FUNCION LISTAR PEDIDOS POR CAJAS ##############################
function TablaListarPedidosxCajas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarPedidosxCajas(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE PEDIDOS POR CAJA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO SUCURSAL: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"CAJA Nº: ".utf8_decode($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"RESPONSABLE: ".utf8_decode($reg[0]["nombres"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(75,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,75,25,20,45,20,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+= $reg[$i]['articulos'];
    $TotalImporte+= $reg[$i]['totalpago'];
    $TotalAbono+= $reg[$i]['creditopagado'];
    $TotalDebe+= ($reg[$i]['tipopago'] == 'CONTADO' ? "0.00" : $reg[$i]['totalpago']-$reg[$i]['creditopagado']);

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),
        utf8_decode($reg[$i]["statuspedido"] == 0 ? "ENTREGADA" : "PENDIENTE"),
        utf8_decode($reg[$i]["tipopago"]),
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),
        utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),
        utf8_decode($reg[$i]['tipopago'] == 'CONTADO' ? $simbolo."0.00" : $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));
   }
   
    $this->Cell(210,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PEDIDOS POR CAJAS ##############################

########################## FUNCION LISTAR PEDIDOS POR FECHAS ##############################
function TablaListarPedidosxFechas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarPedidosxFechas(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE PEDIDOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO SUCURSAL: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(75,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,75,25,20,45,20,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+= $reg[$i]['articulos'];
    $TotalImporte+= $reg[$i]['totalpago'];
    $TotalAbono+= $reg[$i]['creditopagado'];
    $TotalDebe+= ($reg[$i]['tipopago'] == 'CONTADO' ? "0.00" : $reg[$i]['totalpago']-$reg[$i]['creditopagado']);

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),
        utf8_decode($reg[$i]["statuspedido"] == 0 ? "ENTREGADA" : "PENDIENTE"),
        utf8_decode($reg[$i]["tipopago"]),
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),
        utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),
        utf8_decode($reg[$i]['tipopago'] == 'CONTADO' ? $simbolo."0.00" : $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));
   }
   
    $this->Cell(210,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PEDIDOS POR FECHAS ##############################

########################## FUNCION LISTAR PEDIDOS POR FECHAS DE ENTREGA ##############################
function TablaListarPedidosxFechasEntrega()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarPedidosxFechasEntrega(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################


    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE PEDIDOS POR FECHAS DE ENTREGA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO SUCURSAL: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(55,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(30,8,'FECHA ENTREGA',1,0,'C', True);
    $this->Cell(30,8,'HORA EMISIÓN',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,25,55,25,20,30,30,30,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+= $reg[$i]['articulos'];
    $TotalImporte+= $reg[$i]['totalpago'];
    $TotalAbono+= $reg[$i]['creditopagado'];
    $TotalDebe+= ($reg[$i]['tipopago'] == 'CONTADO' ? "0.00" : $reg[$i]['totalpago']-$reg[$i]['creditopagado']);

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),
        utf8_decode($reg[$i]["statuspedido"] == 0 ? "ENTREGADA" : "PENDIENTE"),
        utf8_decode($reg[$i]["tipopago"]),
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),
        utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaentrega']))),
        utf8_decode(date("H:i:s",strtotime($reg[$i]['fechaentrega']))),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),
        utf8_decode($reg[$i]['tipopago'] == 'CONTADO' ? $simbolo."0.00" : $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));
   }
   
    $this->Cell(230,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PEDIDOS POR FECHAS DE ENTREGA ##############################

################################### REPORTES DE PEDIDOS ##################################






























########################## CLASE VENTAS DE PRODUCTOS ########################

########################## FUNCION TICKET GENERAL ##############################
function TicketGeneral()
{  

    $tra = new Login();
    $reg = $tra->DetallesPedidoComanda();
  
    if($reg!=""){
  
    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
   // $this->Image($logo , 14, 4, 50, 12, "PNG");
   //AQUI ESTA LA IMAGEN QUE VA EN EL TICKET
    $this->Ln(6);

    }    
  
  
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "CHOP CHOP", 0, 0, 'C');
    $this->Ln(5);
    
    
    
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE COCINA", 0, 0, 'C');
    $this->Ln(5);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');
    $this->Ln(2);
    
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]['tipopedido'] == 1){

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"SALA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nomsala']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"Nº MESA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,portales(utf8_decode($reg[0]['nommesa'])),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"MESERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nombre_mesero']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(12,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode($reg[0]['nombres']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
  
    }


    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,3,'CANT',0,0,'C');
    $this->Cell(56,3,'DESCRIPCIÓN DE PRODUCTO',0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){

    $this->SetX(4);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    
    //['cantventa'], 0,  en el cero se coloca la cantidad de decimales
    $this->Cell(10,3,utf8_decode(number_format($reg[$i]['cantventa'], 0, '.', ',')),0,0,'L');
    $this->Ln(3);
    
    //['cantventa'], 0,  en el Cell(56,3, se coloca la cantidad de espacio de izquierda a derecha ["producto"], 32)
    $this->Cell(56,2,portales(utf8_decode(getSubString($reg[$i]["producto"], 32))),0,0,'L');



//OBSERVACIONES EN EL MISMO PRODUCTO
//OBSERVACIONES EN EL MISMO PRODUCTO
//OBSERVACIONES EN EL MISMO PRODUCTO
//OBSERVACIONES EN EL MISMO PRODUCTO
//OBSERVACIONES EN EL MISMO PRODUCTO
//OBSERVACIONES EN EL MISMO PRODUCTO
//OBSERVACIONES EN EL MISMO PRODUCTO
//OBSERVACIONES EN EL MISMO PRODUCTO
//OBSERVACIONES EN EL MISMO PRODUCTO
//OBSERVACIONES EN EL MISMO PRODUCTO//OBSERVACIONES EN EL MISMO PRODUCTO



    if($reg[$i]['observacionespedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',14);
    $this->Ln();
    $this->MultiCell(56,1,portales(utf8_decode($reg[$i]['observacionespedido'] == '' ? "" : "(".$reg[$i]['observacionespedido'].")")),0,'J');
    $this->Ln();
    }

    if($reg[$i]['salsaspedido'] != ""){ 
    $this->Ln();
    $this->Ln();
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(56,2,portales(utf8_decode($reg[$i]['salsaspedido'] == '' ? "" : "(".str_replace("_", " ", $reg[$i]['salsaspedido']).")")),0,'J');
    }

    $this->Ln();  
    }

    if($reg[0]['descripciones'] != ""){ 
    $this->Ln();
    $this->SetX(3);
    $this->SetFont('Courier','B',15);
    $this->MultiCell(66,2,portales(utf8_decode($reg[0]['descripciones'] == '' ? "" : $reg[0]['descripciones'])),0,'J');
    }

    $this->Ln(3);
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);
    }

    $new = new Login();
    $bar = $new->DetallesPedidoBar();

    //AQUI RELAIZO EL SALTO DE PAGINA
    if($reg!="" && $bar!=""){
    $this->AddPage();
    } 

    if($bar!=""){

    if (file_exists("fotos/sucursales/".$bar[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$bar[0]['cuitsucursal'].".png";
    //$this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);
     
    }    
    
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "CHOP CHOP", 0, 0, 'C');
    $this->Ln(5);
   
  
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE BAR", 0, 0, 'C');
    $this->Ln(5);
    

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($bar[0]['nomsucursal']), 0, 1, 'C');
    $this->Ln(2);
    
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]['tipopedido'] == 1){

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($bar[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"SALA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($bar[0]['nomsala']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',15);
    $this->CellFitSpace(16,3,"Nº MESA:",0,0,'L');
    $this->SetFont('Courier','B',15);
    $this->CellFitSpace(50,3,utf8_decode($bar[0]['nommesa']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"MESERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($bar[0]['nombre_mesero']),0,1,'L');
    
    
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($bar[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(12,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode($bar[0]['nombres']),0,1,'L');
    $this->CellFitSpace(54,3,utf8_decode($bar[0]['nommesa']),0,1,'L'); 
    
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,$tipo2 = ($bar[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
  
    }


    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,3,'CANT',0,0,'C');
    $this->Cell(56,3,'DESCRIPCIÓN DE PRODUCTO',0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);
    
    

    $a=1;
    for($i=0;$i<sizeof($bar);$i++){

    $this->SetX(4);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(10,3,utf8_decode(number_format($bar[$i]['cantventa'], 0, '.', ',')),0,0,'L');
    $this->Ln();
    $this->Cell(30,3,portales(utf8_decode(getSubString($bar[$i]["producto"], 32))),0,0,'L');
    $this->Ln();
    /*
    $this->Write(25, 'inicio prueba');
    $this->Cell(10,3,utf8_decode(number_format($bar[$i]['cantventa'], 2, '.', ',')),0,0,'L');
    $this->Write(32, 'fin prueba');
    */
    

    if($bar[$i]['observacionespedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',10);
    $this->MultiCell(56,2,portales(utf8_decode($bar[$i]['observacionespedido'] == '' ? "" : "(".$bar[$i]['observacionespedido'].")")),0,'J');
    }

    if($bar[$i]['salsaspedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(56,2,portales(utf8_decode($bar[$i]['salsaspedido'] == '' ? "" : "(".str_replace("_", " ", $bar[$i]['salsaspedido']).")")),0,'J');
    }

    $this->Ln();  
    }

    if($bar[0]['descripciones'] != ""){ 
    $this->Ln();
    $this->SetX(3);
    $this->SetFont('Courier','B',10);
    $this->MultiCell(66,2,portales(utf8_decode($bar[0]['descripciones'] == '' ? "" : $bar[0]['descripciones'])),0,'J');
    }

    $this->Ln(3);
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);
       
    }

    $new2 = new Login();
    $reposteria = $new2->DetallesPedidoReposteria();

    //AQUI RELAIZO EL SALTO DE PAGINA
    if($reg!="" && $bar!="" && $reposteria!="" || $bar!="" && $reposteria!="" || $reg!="" && $reposteria!=""){
    $this->AddPage();
    } 

    if($reposteria!=""){

    if (file_exists("fotos/sucursales/".$reposteria[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reposteria[0]['cuitsucursal'].".png";
    $this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);

    }    
  
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE REPOSTERIA", 0, 0, 'C');
    $this->Ln(5);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reposteria[0]['nomsucursal']), 0, 1, 'C');
    $this->Ln(2);
    
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]['tipopedido'] == 1){

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reposteria[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"SALA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reposteria[0]['nomsala']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"Nº MESA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reposteria[0]['nommesa']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"MESERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reposteria[0]['nombre_mesero']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reposteria[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(12,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode($reposteria[0]['nombres']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,$tipo2 = ($reposteria[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
  
    }


    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,3,'CANT',0,0,'C');
    $this->Cell(56,3,'DESCRIPCIÓN DE PRODUCTO',0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $a=1;
    for($i=0;$i<sizeof($reposteria);$i++){

    $this->SetX(4);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(10,3,utf8_decode(number_format($reposteria[$i]['cantventa'], 2, '.', ',')),0,0,'L');
    $this->Cell(56,3,portales(utf8_decode(getSubString($reposteria[$i]["producto"], 32))),0,0,'L');

    if($reposteria[$i]['observacionespedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',15);
    $this->MultiCell(56,2,portales(utf8_decode($reposteria[$i]['observacionespedido'] == '' ? "" : "(".$reposteria[$i]['observacionespedido'].")")),0,'J');
    }

    if($reposteria[$i]['salsaspedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(56,2,portales(utf8_decode($reposteria[$i]['salsaspedido'] == '' ? "" : "(".str_replace("_", " ", $reposteria[$i]['salsaspedido']).")")),0,'J');
    }

    $this->Ln();  
    }

    if($reposteria[0]['descripciones'] != ""){ 
    $this->Ln();
    $this->SetX(3);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(66,2,portales(utf8_decode($reposteria[0]['descripciones'] == '' ? "" : $reposteria[0]['descripciones'])),0,'J');
    }

    $this->Ln(3);
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);
       
    }

}
########################## FUNCION TICKET GENERAL ##############################

########################## FUNCION TICKET COMANDA ##############################
function TicketComanda()
{  

    $tra = new Login();
    $reg = $tra->DetallesPedidoComanda();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
  
    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);

    }

    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE COCINA", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');
    $this->Ln(2);
    
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]['tipopedido'] == 1){

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"SALA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nomsala']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"Nº MESA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,portales(utf8_decode($reg[0]['nommesa'])),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"MESERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nombre_mesero']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(12,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode($reg[0]['nombres']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
  
    }


    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,3,'CANT',0,0,'C');
    $this->Cell(56,3,'DESCRIPCIÓN DE PRODUCTO',0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){

    $this->SetX(4);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(10,3,utf8_decode(number_format($reg[$i]['cantventa'], 2, '.', ',')),0,0,'L');
    $this->Cell(56,3,portales(utf8_decode(getSubString($reg[$i]["producto"], 32))),0,0,'L');


//OBSERVACIONES MANUALES


    if($reg[$i]['observacionespedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',30);
    $this->MultiCell(56,2,portales(utf8_decode($reg[$i]['observacionespedido'] == '' ? "" : "(".$reg[$i]['observacionespedido'].")")),0,'J');
    $this->Ln();
    }

    if($reg[$i]['salsaspedido'] != ""){ 
    $this->Ln();
    $this->Ln();
    $this->Ln();
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(56,2,portales(utf8_decode($reg[$i]['salsaspedido'] == '' ? "" : "(".str_replace("_", " ", $reg[$i]['salsaspedido']).")")),0,'J');
    }

    $this->Ln();  
    }

    if($reg[0]['descripciones'] != ""){ 
    $this->Ln();
    $this->SetX(3);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(66,2,portales(utf8_decode($reg[0]['descripciones'] == '' ? "" : $reg[0]['descripciones'])),0,'J');
    }

    $this->Ln(3);
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);
}
########################## FUNCION TICKET COMANDA ##############################

########################## FUNCION TICKET BAR ##############################
function TicketBar()
{  

    $tra = new Login();
    $reg = $tra->DetallesPedidoBar();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
  
    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);

    }

    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE BAR", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');
    $this->Ln(2);
    
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]['tipopedido'] == 1){

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"SALA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nomsala']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"Nº MESA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,portales(utf8_decode($reg[0]['nommesa'])),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"MESERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nombre_mesero']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(12,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode($reg[0]['nombres']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
  
    }


    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,3,'CANT',0,0,'C');
    $this->Cell(56,3,'DESCRIPCIÓN DE PRODUCTO',0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){

    $this->SetX(4);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(10,3,utf8_decode(number_format($reg[$i]['cantventa'], 2, '.', ',')),0,0,'L');
    $this->Cell(56,3,portales(utf8_decode(getSubString($reg[$i]["producto"], 32))),0,0,'L');

    if($reg[$i]['observacionespedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',30);
    $this->MultiCell(56,2,portales(utf8_decode($reg[$i]['observacionespedido'] == '' ? "" : "(".$reg[$i]['observacionespedido'].")")),0,'J');
    }

    if($reg[$i]['salsaspedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(56,2,portales(utf8_decode($reg[$i]['salsaspedido'] == '' ? "" : "(".str_replace("_", " ", $reg[$i]['salsaspedido']).")")),0,'J');
    }

    $this->Ln();  
    }

    if($reg[0]['descripciones'] != ""){ 
    $this->Ln();
    $this->SetX(3);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(66,2,portales(utf8_decode($reg[0]['descripciones'] == '' ? "" : $reg[0]['descripciones'])),0,'J');
    }

    $this->Ln(3);
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);
}
########################## FUNCION TICKET BAR ##############################

########################## FUNCION TICKET REPOSTERIA ##############################
function TicketReposteria()
{  

    $tra = new Login();
    $reg = $tra->DetallesPedidoReposteria();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
  
    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);

    }

    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE REPOSTERIA", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');
    $this->Ln(2);
    
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]['tipopedido'] == 1){

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"SALA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nomsala']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"Nº MESA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,portales(utf8_decode($reg[0]['nommesa'])),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"MESERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nombre_mesero']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(12,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode($reg[0]['nombres']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
  
    }


    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,3,'CANT',0,0,'C');
    $this->Cell(56,3,'DESCRIPCIÓN DE PRODUCTO',0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){

    $this->SetX(4);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(10,3,utf8_decode(number_format($reg[$i]['cantventa'], 2, '.', ',')),0,0,'L');
    $this->Cell(56,3,portales(utf8_decode(getSubString($reg[$i]["producto"], 32))),0,0,'L');

    if($reg[$i]['observacionespedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',15);
    $this->MultiCell(56,2,portales(utf8_decode($reg[$i]['observacionespedido'] == '' ? "" : "(".$reg[$i]['observacionespedido'].")")),0,'J');
    }

    if($reg[$i]['salsaspedido'] != ""){ 
    $this->Ln();
    $this->SetX(14);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(56,2,portales(utf8_decode($reg[$i]['salsaspedido'] == '' ? "" : "(".str_replace("_", " ", $reg[$i]['salsaspedido']).")")),0,'J');
    }

    $this->Ln();  
    }

    if($reg[0]['descripciones'] != ""){ 
    $this->Ln();
    $this->SetX(3);
    $this->SetFont('Courier','B',6);
    $this->MultiCell(66,2,portales(utf8_decode($reg[0]['descripciones'] == '' ? "" : $reg[0]['descripciones'])),0,'J');
    }

    $this->Ln(3);
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);
}
########################## FUNCION TICKET REPOSTERIA ##############################

########################## FUNCION TICKET PREGUENTA ##############################

##############INICIO  FUNCION VIEJA TICKET DE PRECUENTA ###############

/*
function TicketPrecuenta()
    {
        $tra = new Login(); // Asumiendo que Login() contiene DetallesPedido()
        $reg_detalle = $tra->DetallesPedido(); // Obtiene los datos de la precuenta

        // Verifica si hay datos
        if (empty($reg_detalle)) {
            $this->SetX(4);
            $this->SetFont('Courier','B',10);
            $this->Cell(66, 5, utf8_decode("NO SE ENCONTRARON DETALLES PARA ESTA PRECUENTA"), 0, 0, 'C');
            $this->Output();
            return;
        }

        $simbolo = ($reg_detalle[0]['simbolo'] == "" ? "" : $reg_detalle[0]['simbolo']);

        // --- ENCABEZADO DE PRECUENTA ---
        $this->SetX(4);
        $this->SetFont('Courier','B',12);
        $this->SetFillColor(2,157,116);
        $this->Cell(66, 5, "TICKET DE PRECUENTA", 0, 0, 'C');
        $this->Ln(5);

        // Datos de la sucursal (generalmente ya están en reg_detalle[0])
        if (file_exists("fotos/sucursales/".$reg_detalle[0]['cuitsucursal'].".png")) {
            $logo = "./fotos/sucursales/".$reg_detalle[0]['cuitsucursal'].".png";
           // $this->Image($logo , 14, 4, 50, 12, "PNG");
            $this->Ln(6);
        }

        $this->SetX(4);
        $this->SetFont('Courier','B',10);
        $this->CellFitSpace(66,4,utf8_decode($reg_detalle[0]['nomsucursal']), 0, 1, 'C');
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(66,3,$reg_detalle[0]['documsucursal'] == '0' ? "" : "Nº ".$reg_detalle[0]['documento']." ".utf8_decode($reg_detalle[0]['cuitsucursal']),0,1,'C');
        $this->Ln(2);

        $this->SetFont('Courier','B',12);
        $this->SetX(2);
        $this->Cell(70,3,'--------------------------',0,0,'C');
        $this->Ln(3);

        // Detalles de Sala, Mesa y Mesero (de DetallesPedido())
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(26,3,utf8_decode("SALA:"),0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(40,3,utf8_decode($reg_detalle[0]['nomsala']),0,1,'L');

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(26,3,utf8_decode("Nº MESA:"),0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(40,3,utf8_decode($reg_detalle[0]['nommesa']),0,1,'L');

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(26,3,utf8_decode("MESERO:"),0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(40,3,utf8_decode($reg_detalle[0]['nombre_mesero']),0,1,'L');

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(26,3,utf8_decode("FECHA EMISIÓN:"),0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(40,3,date("d-m-Y H:i:s", strtotime($reg_detalle[0]['fechapedido'])),0,1,'L'); // Usar fechapedido

        $this->SetFont('Courier','B',12);
        $this->SetX(2);
        $this->Cell(70,3,'--------------------------',0,0,'C');
        $this->Ln(3);

        // --- DETALLES DE LOS PRODUCTOS AGRUPADOS ---
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->SetTextColor(3, 3, 3);
        $this->SetFillColor(229, 229, 229);
        $this->Cell(10,3,'CANT',0,0,'L');
        $this->Cell(46,3,'DESCRIPCIÓN DE PRODUCTO',0,0,'C');
        $this->Cell(10,3,"IMP.",0,1,'C');

        $this->SetX(4);
        $this->Cell(22,3,'PVP.',0,0,'C');
        $this->Cell(22,3,'DCTO.',0,0,'C');
        $this->Cell(22,3,'TOTAL IMPORTE',0,1,'C');

        $this->SetX(2);
        $this->SetFont('Courier','B',12);
        $this->Cell(70,3,'--------------------------',0,0,'C');
        $this->Ln(3);

        // Lógica para agrupar productos repetidos
        $productos_agrupados = [];
        $total_importe_precuenta = 0; // Para el total general de la precuenta

        foreach ($reg_detalle as $detalle_pedido_grupo) {
            // Parsear la cadena 'detalles'
            $items_str = $detalle_pedido_grupo['detalles'];
            $items_arr = explode('<br>', $items_str);

            foreach ($items_arr as $item_str) {
                if (empty(trim($item_str))) continue;

                $parts = explode('|', $item_str);
                if (count($parts) >= 3) {
                    $cantventa = (float)trim($parts[0]);
                    $producto_nombre = trim($parts[1]);
                    $valor_neto = (float)trim($parts[2]);

                    // Necesitamos precio unitario, descuento e IVA para la clave de agrupación,
                    // pero no están directamente en el GROUP_CONCAT.
                    // Para simplificar, agruparemos por nombre de producto y asumiremos el precio unitario del primer item.
                    // Idealmente, se pasaría más detalle de la consulta SQL o se modificaría DetallesPedido() para devolver los items individuales.
                    
                    // Como el GROUP_CONCAT no devuelve todos los detalles para una agrupación perfecta,
                    // asumiremos el precio unitario se calcula del valor_neto / cantventa.
                    // El IVA y el descuento por producto no se pueden inferir de esta cadena para agrupar con total exactitud.
                    // La clave de agrupación más segura aquí sería por 'producto_nombre'.
                    
                    // Nota: Para una agrupación perfecta, la consulta SQL de DetallesPedido()
                    // debería devolver cada detalle de producto individualmente (sin GROUP_CONCAT)
                    // y luego agrupar aquí, o modificar la consulta SQL de DetallesPedido()
                    // para agrupar por codproducto, codmesa, etc., directamente.
                    // Dado el formato actual de DetallesPedido(), esta es la mejor aproximación.

                    $key = $producto_nombre; // Agrupar solo por nombre de producto

                    if (isset($productos_agrupados[$key])) {
                        $productos_agrupados[$key]['cantventa'] += $cantventa;
                        $productos_agrupados[$key]['valorneto'] += $valor_neto;
                        // No podemos sumar ivaproducto o descproducto directamente aquí
                        // sin los datos originales individuales.
                    } else {
                        $productos_agrupados[$key] = [
                            'cantventa' => $cantventa,
                            'producto' => $producto_nombre,
                            'valorneto' => $valor_neto,
                            // Aquí se necesitarían más datos como precioventa, ivaproducto, descproducto
                            // del item original. Como no están en el string, los estimaremos o usaremos valores predeterminados.
                            // Para fines de visualización en precuenta, usaremos el valor neto total.
                            'precioventa_unitario_estimado' => $cantventa > 0 ? $valor_neto / $cantventa : 0,
                            'ivaproducto' => '0.00', // Valor por defecto, no disponible en la cadena 'detalles'
                            'descproducto' => '0.00' // Valor por defecto
                        ];
                    }
                }
            }
            $total_importe_precuenta += $detalle_pedido_grupo['suma']; // Suma el total de cada grupo numpedido
        }

        // Iterar sobre los productos agrupados para imprimirlos
        foreach($productos_agrupados as $item_agrupado){
            $this->SetX(4);
            $this->SetFillColor(192);
            $this->SetDrawColor(3,3,3);
            $this->SetLineWidth(.2);
            $this->SetFont('Courier','B',8);
            $this->SetTextColor(3,3,3);

            $this->CellFitSpace(10,3,utf8_decode(number_format($item_agrupado['cantventa'], 2)),0,0,'C');
            $this->CellFitSpace(46,3,portales(utf8_decode(getSubString($item_agrupado["producto"], 25))),0,0,'C');
            // Como no tenemos el IVA real de la cadena 'detalles', asumimos (E)
            $this->CellFitSpace(10,3,utf8_decode("(E)"),0,1,'C');
            
            $this->SetX(4);
            $this->CellFitSpace(24,3,utf8_decode($simbolo.number_format($item_agrupado["precioventa_unitario_estimado"], 2, '.', ',')),0,0,'C');
            $this->CellFitSpace(18,3,utf8_decode(number_format($item_agrupado["descproducto"], 2, '.', ',')),0,0,'C'); // Descuento por defecto
            $this->CellFitSpace(24,3,utf8_decode($simbolo.number_format($item_agrupado["valorneto"], 2, '.', ',')),0,0,'C');
            $this->Ln();
        }

        $this->SetX(2);
        $this->SetFont('Courier','B',12);
        $this->Cell(70,3,'--------------------------',0,0,'C');
        $this->Ln(3);

        // --- TOTALES DE PRECUENTA ---
        // El subtotal de la precuenta original es la suma de los subtotales de cada grupo de detalles.
        // Como ya sumamos 'suma' de cada grupo de numpedido, ese es el subtotal general.
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($total_importe_precuenta, 2, '.', ',')),0,1,'R');

        // Los campos de impuestos y descuentos detallados del ticket de venta
        // no suelen ir en la precuenta de detalle, según el ejemplo original.
        // Si necesitas alguno de estos, se pueden añadir.
        /*
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"DESC % (".number_format($reg[0]["descuento"], 2, '.', ',')."%):",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totaldescuento"], 2, '.', ',')),0,1,'R');
        */

      /*
      
      $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($total_importe_precuenta, 2, '.', ',')),0,1,'R'); // El mismo subtotal en este caso

        $this->SetFont('Courier','B',12);
        $this->SetX(2);
        $this->Cell(70,3,'--------------------------',0,0,'C');
        $this->Ln(3);
        $this->SetX(2);
        $this->SetFont('Courier','B',12);
        $this->Cell(70,3,'--------------------------',0,0,'C');
        $this->Ln(3);

        // Mensaje de agradecimiento
        $this->SetX(4);
        $this->SetFont('Courier','BI',10);
        $this->SetFillColor(3, 3, 3);
        $this->CellFitSpace(66,3,"GRACIAS POR PREFERIRNOS",0,1,'C');
        $this->Ln(3);

    }
    
    */
    
    
    ##############FIN  FUNCION VIEJA TICKET DE PRECUENTA ###############
    
    
    
    ##############INICIO  FUNCION NUEVA TICKET DE PRECUENTA ###############
    
    
     ##############INICIO  FUNCION NUEVA TICKET DE PRECUENTA ###############
    
    
    function TicketPrecuenta()
{
$imp = new Login();
$imp = $imp->ImpuestosPorId();
$impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
$valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

$tra = new Login();
$reg = $tra->DetallesPedido();
$simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

  // INCLUSIÓN DE LA LÓGICA DE TASA DE CAMBIO DEL TICKET DE VENTA
  $tipoCambio = $tra->ObtenerTipoCambio();
  $valorCambio = ($tipoCambio ? $tipoCambio['montocambio'] : 1.00);
  $simboloCambio = ($tipoCambio ? $tipoCambio['descripcioncambio'] : 'Bs.');

if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
$logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
$this->Image($logo , 14, 4, 50, 12, "PNG");
$this->Ln(6);
}

$this->SetX(4);
$this->SetFont('Courier','B',12);
$this->SetFillColor(2,157,116);
$this->Cell(66, 5, "TICKET DE PRECUENTA", 0, 0, 'C');
$this->Ln(5);

$this->SetX(4);
$this->SetFont('Courier','B',10);
$this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

if($reg[0]['tipopedido'] == 1){
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(16,3,"SALA:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(50,3,utf8_decode($reg[0]['nomsala']),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(16,3,"Nº MESA:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(50,3,portales(utf8_decode($reg[0]['nommesa'])),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(12,3,"MESERO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(54,3,utf8_decode($reg[0]['nombre_mesero']),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');
} else {
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(12,3,"CAJERO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(54,3,utf8_decode($reg[0]['nombres']),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
}

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->SetTextColor(3, 3, 3);
$this->SetFillColor(229, 229, 229);
$this->Cell(4,3,'Nº',0,0,'C');
$this->Cell(62,3,'DETALLES',0,1,'C');

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);

$this->SetWidths(array(4,62));

$cantidad = 0;
$SubTotal = 0;
$a=1;
for($i=0;$i<sizeof($reg);$i++){
$SubTotal += $reg[$i]['suma'];

$this->SetX(4);
$this->SetDrawColor(255, 255, 255);
$this->SetLineWidth(.1);
$detalles = str_replace("<br>","\n", $reg[$i]['detalles']);
$this->SetFont('Courier','B',7.8);
$this->SetTextColor(3,3,3);
$this->Row(array(utf8_decode($a++),portales(utf8_decode($detalles))));

// ** AQUI SE AÑADE EL ESPACIO **
$this->Ln(1); // Salto de linea de 1 mm para separar las salsas del subtotal

// Mostrar el subtotal del producto en Dólares y Bolívares
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->Cell(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[$i]['suma'], 2, '.', ',')),0,1,'R');
$this->Ln(0.5); // Salto de linea

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->Cell(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[$i]['suma']*$valorCambio, 2, '.', ',')),0,1,'R');
$this->Ln(0.5);
}

$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,3,'--------------------------',0,0,'C');
$this->Ln(3);


  // #############################################
  // # CÁLCULOS COHERENTES CON EL TICKET DE VENTA #
  // #############################################
 
  // Total del pedido (SubTotal - Descuento + Impuestos)
  $total_base_dolares = $reg[0]["totalpago"];

  // Servicio 10%
  $servicio_dolares = $total_base_dolares * 0.10;
  $servicio_bs = $servicio_dolares * $valorCambio;

  // IMPORTE TOTAL FINAL (Base + Servicio, SE QUITA EL DELIVERY)
  $importe_total_final_dolares = $total_base_dolares + $servicio_dolares;
  $importe_total_final_bs = $importe_total_final_dolares * $valorCambio;


// #############################################
  // # IMPRESIÓN DE TOTALES #
  // #############################################

// SUBTOTAL EN DÓLARES
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($SubTotal, 2, '.', ',')),0,1,'R');

// SUBTOTAL EN BOLÍVARES
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($SubTotal*$valorCambio, 2, '.', ',')),0,1,'R');

// DESCUENTO EN DÓLARES
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DESC % (".number_format($reg[0]["descuento"], 2, '.', ',')."%):",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totaldescuento"], 2, '.', ',')),0,1,'R');

// DESCUENTO EN BOLÍVARES
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"DESC % (".number_format($reg[0]["descuento"], 2, '.', ',')."%):",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["totaldescuento"]*$valorCambio, 2, '.', ',')),0,1,'R');

  // # SERVICIO #
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SERVICIO 10%:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($servicio_dolares, 2, '.', ',')),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"SERVICIO 10%:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($servicio_bs, 2, '.', ',')),0,1,'R');


  // # IMPORTE TOTAL (FINAL) #
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($importe_total_final_dolares, 2, '.', ',')),0,1,'R');

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($importe_total_final_bs, 2, '.', ',')),0,1,'R');
 
  // # TOTAL A CANCELAR: Mantiene el mismo valor que el Importe Total #
$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"TOTAL A CANCELAR:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($importe_total_final_dolares, 2, '.', ',')),0,1,'R');
$this->Ln(1);

$this->SetX(4);
$this->SetFont('Courier','B',8);
$this->CellFitSpace(36,3,"TOTAL A CANCELAR:",0,0,'R');
$this->SetFont('Courier','B',8);
$this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($importe_total_final_bs, 2, '.', ',')),0,1,'R');
$this->Ln(1);


$this->SetX(2);
$this->SetFont('Courier','B',12);
$this->Cell(70,0.5,'--------------------------',0,1,'C');
$this->SetX(2);
$this->Cell(70,0.5,'--------------------------',0,1,'C');
$this->Ln(3);

$this->SetX(4);
$this->SetFont('Courier','BI',9);
$this->SetFillColor(3, 3, 3);
$this->CellFitSpace(66,3,"GRACIAS POR PREFERIRNOS",0,1,'C');
$this->Ln(3);
}
    
########################## FUNCION TICKET PRECUENTA ###########
    
########################## FUNCION TICKET PRECUENTA ##############################

########################## FUNCION TICKET VENTA ##############################

function TicketVenta()
{
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->VentasPorId();
    
    // Nueva línea para obtener el tipo de cambio
    $tipoCambio = $tra->ObtenerTipoCambio();
    $valorCambio = ($tipoCambio ? $tipoCambio['montocambio'] : 1.00);
    
    $simboloCambio = ($tipoCambio ? $tipoCambio['descripcioncambio'] : 'Bs.');
    
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        //$logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        //$this->Image($logo , 14, 4, 50, 12, "PNG");
        //$this->Ln(6);
    }
    
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE VENTA", 0, 0, 'C');
    $this->Ln(5);
    
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(66,3,$reg[0]['documsucursal'] == '0' ? "" : "Nº ".$reg[0]['documento']." ".utf8_decode($reg[0]['cuitsucursal']),0,1,'C');

    if($reg[0]['id_provincia']!='0'){
        $this->SetX(4);
        $this->CellFitSpace(66,3,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia'])." ".$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento'])),0,1,'C');
    }

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg[0]['direcsucursal']),0,1,'C');

    // RESTAURADO: N° ACTIVIDAD/GIRO
    if($reg[0]['codgiro'] != "0"){
        $this->SetX(4);
        $this->CellFitSpace(66,3,"N° ACTIVIDAD/GIRO: ".utf8_decode($reg[0]['codgiro']),0,1,'C');
    }
    
    // RESTAURADO: FECHA AUTORIZACION
    if($reg[0]['fechaautorsucursal'] != "0000-00-00"){
        $this->SetX(4);
        $this->CellFitSpace(66,3,"DE:".utf8_decode($reg[0]['fechaautorsucursal']),0,1,'C');
    }
    
    // RESTAURADO: GIRO SUCURSAL
    if($reg[0]['girosucursal'] != "0"){
        $this->SetX(4);
        $this->CellFitSpace(66,3,utf8_decode($reg[0]['girosucursal']),0,1,'C');
    }

    /* ################################################################################
    # INICIO DE CÓDIGO COMENTADO (DATOS FISCALES EXTENSOS NO DESEADOS)
    ################################################################################
    
    // OBLIGADO A LLEVAR CONTABILIDAD
    //$this->SetX(4);
    //$this->CellFitSpace(66,3,"OBLIGADO A LLEVAR CONTABILIDAD: ".utf8_decode($reg[0]['llevacontabilidad']),0,1,'C');
    
    // AMBIENTE
    //$this->SetX(4);
    //$this->CellFitSpace(66,3,"AMBIENTE: PRODUCCIÓN",0,1,'C');
    
    // EMISIÓN
    //$this->SetX(4);
    //$this->CellFitSpace(66,3,"EMISIÓN: NORMAL",0,1,'C');
    
    // CLAVE DE ACCESO - N° DE AUTORIZACIÓN
    //$this->SetX(4);
    //$this->CellFitSpace(66,3,"CLAVE DE ACCESO - N° DE AUTORIZACIÓN",0,1,'C');
    
    // CÓDIGO DE AUTORIZACIÓN
    //$this->SetX(4);
    //$this->CellFitSpace(66,3,utf8_decode($reg[0]['codautorizacion']),0,1,'C');

    ################################################################################
    # FIN DE CÓDIGO COMENTADO
    ################################################################################
    */
    
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(20,3,"Nº TICKET:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(46,3,utf8_decode($reg[0]['codfactura']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJA Nº:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nrocaja']."-".$reg[0]['nomcaja']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nombres']),0,1,'L');

    if($reg[0]['delivery']=="1"){
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
    }

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA VENTA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",strtotime($reg[0]['fechaventa'])),0,1,'L');

    if($reg[0]['tipoventa'] == 2){
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(26,3,"FECHA ENTREGA:",0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(40,3,date("d-m-Y",strtotime($reg[0]['fechaentrega'])),0,1,'L');

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(26,3,"HORA ENTREGA:",0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(40,3,date("H:i:s",strtotime($reg[0]['fechaentrega'])),0,1,'L');

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(26,3,"STATUS PEDIDO:",0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(40,3,$reg[0]['statuspedido'] == 1 ? "PENDIENTE" : "ENTREGADO",0,1,'L');
    }
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s"),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]['nomcliente']==""){
        $this->SetFont('Courier','B',8);
        $this->SetX(4);
        $this->CellFitSpace(66, 3, "CONSUMIDOR FINAL",0,1,'C');
    } else {
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(15,3,$documento = ($reg[0]['documcliente'] == '0' ? "Nº DOC:" : "Nº ".$reg[0]['documento3'].": "),0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(51,3,utf8_decode($reg[0]['dnicliente']),0,1,'L');

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(15,3,"SEÑOR(A):",0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->MultiCell(52,3,$this->SetFont('Courier','B',8).utf8_decode($reg[0]['nomcliente']),0,'L');

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(15,3,"DIREC:",0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->MultiCell(52,3,$this->SetFont('Courier','B',8).portales(utf8_decode($reg[0]['direccliente'])),0,'L');

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(15,3,"TELEFONO:",0,0,'L');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(51,3,utf8_decode($reg[0]['tlfcliente'] == "" ? "**********" : $reg[0]['tlfcliente']),0,1,'L');
    }

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3, 3, 3);
    $this->SetFillColor(229, 229, 229);
    $this->Cell(10,3,'CANT',0,0,'L');
    $this->Cell(46,3,'DESCRIPCIÓN DE PRODUCTO',0,0,'C');
    $this->Cell(10,3,"IMP.",0,1,'C');

    $this->SetX(4);
    $this->Cell(22,3,'PVP.',0,0,'C');
    $this->Cell(22,3,'DCTO.',0,0,'C');
    $this->Cell(22,3,'TOTAL IMPORTE',0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $tra = new Login();
    $detalle = $tra->VerDetallesVentas();

    $productos_agrupados = [];
    foreach ($detalle as $item) {
        $key = $item['codproducto'].'-'.$item['precioventa'].'-'.$item['descproducto'].'-'.$item['ivaproducto'];
        
        if (isset($productos_agrupados[$key])) {
            $productos_agrupados[$key]['cantventa'] += $item['cantventa'];
            // Se asume que el descuento ya viene por línea y no es sumable aquí a menos que se agrupen productos idénticos
            // La suma de valorneto si es correcta ya que es el total final de la línea.
            $productos_agrupados[$key]['valorneto'] += $item['valorneto'];
        } else {
            $productos_agrupados[$key] = $item;
        }
    }

    $detalle_agrupado = array_values($productos_agrupados);

    for($i=0;$i<sizeof($detalle_agrupado);$i++){
        $this->SetX(4);
        $this->SetFillColor(192);
        $this->SetDrawColor(3,3,3);
        $this->SetLineWidth(.2);
        $this->SetFont('Courier','B',8);
        $this->SetTextColor(3,3,3);
        $this->CellFitSpace(10,3,utf8_decode($detalle_agrupado[$i]['cantventa']),0,0,'C');
        $this->CellFitSpace(46,3,portales(utf8_decode(getSubString($detalle_agrupado[$i]["producto"], 25))),0,0,'C');
        $this->CellFitSpace(10,3,utf8_decode($iva = ($detalle_agrupado[$i]['ivaproducto'] != '0.00' ? number_format($detalle_agrupado[$i]['ivaproducto'], 2, '.', ',')."%" : "(E)")),0,1,'C');
        $this->SetX(4);
        
        // ** CÁLCULO PARA REFLEJAR DESCUENTO CORRECTAMENTE (MANTENIDO) **
        $precioUnitario = $detalle_agrupado[$i]["precioventa"];
        $cantidad = $detalle_agrupado[$i]['cantventa'];
        $lineaAntesDescuento = $precioUnitario * $cantidad; // Precio Total de la Línea (PVP.)
        
        $precioDolares = number_format($lineaAntesDescuento, 2, '.', ',');
        $precioBolivares = number_format($lineaAntesDescuento * $valorCambio, 2, '.', ',');
        
        $totalDolares = number_format($detalle_agrupado[$i]["valorneto"], 2, '.', ','); // Total Neto de la Línea (TOTAL IMPORTE)
        $totalBolivares = number_format($detalle_agrupado[$i]["valorneto"] * $valorCambio, 2, '.', ',');
        
        // El campo `descproducto` contiene el monto total de descuento aplicado a esta línea.
        $descuentoDolares = number_format($detalle_agrupado[$i]["descproducto"], 2, '.', ',');
        $descuentoBolivares = number_format($detalle_agrupado[$i]["descproducto"] * $valorCambio, 2, '.', ',');
        
        // Líneas para los precios
        $this->CellFitSpace(24,3,utf8_decode($simbolo.$precioDolares),0,0,'C'); // PVP. (Total Línea)
        $this->CellFitSpace(18,3,utf8_decode($descuentoDolares),0,0,'C');       // DCTO. (Total Descuento de Línea)
        $this->CellFitSpace(24,3,utf8_decode($simbolo.$totalDolares),0,1,'C');  // TOTAL IMPORTE (Total Línea Neto)
        
        $this->SetX(4);
        $this->CellFitSpace(24,3,utf8_decode($simboloCambio." ".number_format($lineaAntesDescuento * $valorCambio, 2, '.', ',')),0,0,'C'); // PVP. (Total Línea)
        $this->CellFitSpace(18,3,utf8_decode($simboloCambio." ".$descuentoBolivares),0,0,'C');                         // DCTO. (Total Descuento de Línea)
        $this->CellFitSpace(24,3,utf8_decode($simboloCambio." ".$totalBolivares),0,1,'C');                            // TOTAL IMPORTE (Total Línea Neto)
        // ** FIN DE CÁLCULO **
        
        $this->Ln();
    }

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    // TOTALES EN AMBAS MONEDAS
    $totalSinIva = $reg[0]["subtotalivasi"] + $reg[0]["subtotalivano"]; // 7.00
    $totalSinIvaBs = $totalSinIva * $valorCambio;
    $totalIva = $reg[0]["totaliva"];
    $totalIvaBs = $totalIva * $valorCambio;
    
    // ********************************************************************************
    // *** INICIO DE LÓGICA CONDICIONAL DE COBRO DE SERVICIO/RECARGO SEGÚN LA SALA ***
    // ********************************************************************************
    // 1. Obtener el nombre de la sala (asumiendo que viene en $reg[0]['nomsala'] - puede ser vacío).
    $sala = strtoupper(trim($reg[0]['nomsala'] ?? ''));

    // 2. Definir la tasa y el nombre del recargo
    $surchargeRate = 0.00;
    $surchargeName = "SERVICIO 10%"; // Nombre por defecto

    if ($sala === 'YUMMY') {
        $surchargeRate = 0.20; // 20% de incremento para sala YUMMY
        $surchargeName = "RECARGO 20% (YUMMY)";
        
    } else {
        // Salas que SÍ cobran el 10% (SALON PRINCIPAL, VIP, TERRAZA).
        $salasConServicio = [
            'SALON PRINCIPAL', 
            'VIP', 
            'TERRAZA'
        ];

        if (in_array($sala, $salasConServicio)) {
            $surchargeRate = 0.10; 
            $surchargeName = "SERVICIO 10%";
        }
    }
    // ********************************************************************************
    // *** FIN DE LÓGICA CONDICIONAL DE COBRO DE SERVICIO/RECARGO ***
    // ********************************************************************************

    // Variables para almacenar los valores corregidos/calculados
    $totalDescuento = $reg[0]["totaldescuento"]; // 0.00 (Valor inicial)
    // Cálculo del servicio/recargo usando la tasa condicional
    $CalculatedServiceAmount = $reg[0]["totalpago"] * $surchargeRate; 
    $montoFinal = $reg[0]["totalpago"] + $reg[0]["montodelivery"] + $CalculatedServiceAmount; // El total ahora incluye el servicio/recargo condicional
    $montoPagadoReferencia = $reg[0]["montopagado"] + $reg[0]["montopropina"];
    
    // --- LÓGICA DE CÁLCULO DE DESCUENTO IMPLÍCITO (CORRECCIÓN) ---
    // Esta lógica ANULA el servicio si se detecta un descuento implícito para cuadrar el total.
    if ($reg[0]["totaldescuento"] == 0.00 && $montoPagadoReferencia < $totalSinIva) {

        // 1. El IMPORTE TOTAL final deseado es el MONTO PAGO (5.60 en el ejemplo del 20%).
        $montoFinal = $montoPagadoReferencia + $reg[0]["montodelivery"]; 
        
        // 2. Descuento Calculado (BS): SUBTOTAL - IMPORTE TOTAL.
        $totalDescuento = $totalSinIva - $montoFinal; 
        
        // 3. Porcentaje de Descuento Calculado.
        if ($totalSinIva > 0) {
            $reg[0]["descuento"] = ($totalDescuento / $totalSinIva) * 100; 
        } else {
             $reg[0]["descuento"] = 0.00;
        }

        // 4. Servicio 10%/Recargo 20% forzado a 0.00 para que el descuento del 20% cuadre el total.
        $CalculatedServiceAmount = 0.00; 
    }
    
    $totalDescuentoBs = $totalDescuento * $valorCambio;
    $montoFinalBs = $montoFinal * $valorCambio;
    // --- FIN DE LÓGICA DE CÁLCULO DE DESCUENTO IMPLÍCITO (CORRECCIÓN) ---


    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($totalSinIva, 2, '.', ',')),0,1,'R');
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($totalSinIvaBs, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"GRAVADO (".number_format($reg[0]["iva"], 2, '.', ',')."%):",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["subtotalivasi"], 2, '.', ',')),0,1,'R');
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"GRAVADO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["subtotalivasi"] * $valorCambio, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"EXENTO (0%):",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["subtotalivano"], 2, '.', ',')),0,1,'R');
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"EXENTO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["subtotalivano"] * $valorCambio, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"TOTAL ".$impuesto." (".number_format($reg[0]["iva"], 2, '.', ',')."%):",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($totalIva, 2, '.', ',')),0,1,'R');
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"TOTAL IMPUESTO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($totalIvaBs, 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"DESCONTADO %:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["descontado"], 2, '.', ',')),0,1,'R');
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"DESCONTADO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["descontado"] * $valorCambio, 2, '.', ',')),0,1,'R');

    // Descuento % (en porcentaje - CORREGIDO si aplica)
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,utf8_decode("DESCTO. PORCENTUAL:"),0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode(number_format($reg[0]["descuento"], 2, '.', ',')."%"),0,1,'R'); 
    
    // Descuento $ (equivalente en moneda extranjera - CORREGIDO si aplica)
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,utf8_decode("DESCTO. MONEDA EXTR.:"),0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($totalDescuento, 2, '.', ',')),0,1,'R'); 
    
    // Descuento Bs. (equivalente en bs - CORREGIDO si aplica)
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,utf8_decode("DESCTO. MONEDA LOCAL:"),0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($totalDescuentoBs, 2, '.', ',')),0,1,'R'); 

    if($reg[0]["repartidor"] != 0){
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"COSTO DELIVERY:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montodelivery"], 2, '.', ',')),0,1,'R');
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"COSTO DELIVERY:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["montodelivery"] * $valorCambio, 2, '.', ',')),0,1,'R');
    }
    
    // Cargo por Servicio/Recargo (Monto ajustado por lógica condicional de sala o anulación por descuento implícito)
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    // CAMBIO APLICADO AQUÍ: Muestra el nombre dinámico del recargo (10% o 20% YUMMY)
    $this->CellFitSpace(36,3,utf8_decode($surchargeName.":"),0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($CalculatedServiceAmount, 2, '.', ',')),0,1,'R'); 
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    // CAMBIO APLICADO AQUÍ: Muestra el nombre dinámico del recargo (10% o 20% YUMMY)
    $this->CellFitSpace(36,3,utf8_decode($surchargeName.":"),0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($CalculatedServiceAmount * $valorCambio, 2, '.', ',')),0,1,'R'); 
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($montoFinal, 2, '.', ',')),0,1,'R'); 
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($montoFinalBs, 2, '.', ',')),0,1,'R'); 

    // --- INICIO DE NUEVA LÓGICA: TOTAL A PAGAR (IMPORTE TOTAL + PROPINA) ---
    // Calcular Total a Pagar
    $TotalAPagar = $montoFinal + $reg[0]["montopropina"]; // Se suma el IMPORTE TOTAL + PROPINA RECIBIDA
    $TotalAPagarBs = $TotalAPagar * $valorCambio;

    // Imprimir TOTAL A PAGAR (Moneda Extranjera)
    $this->SetX(4);
    $this->SetFont('Courier','B',10); // Fuente más grande para destacar el total
    $this->CellFitSpace(36,3,utf8_decode("TOTAL A PAGAR:"),0,0,'R');
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($TotalAPagar, 2, '.', ',')),0,1,'R');

    // Imprimir TOTAL A PAGAR (Moneda Local)
    $this->SetX(4);
    $this->SetFont('Courier','B',10); // Fuente más grande para destacar el total
    $this->CellFitSpace(36,3,utf8_decode("TOTAL A PAGAR:"),0,0,'R');
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($TotalAPagarBs, 2, '.', ',')),0,1,'R');
    // --- FIN DE NUEVA LÓGICA ---
    
    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    // Propina
    if($reg[0]["montopropina"] != 0.00){
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"PROPINA RECIBIDA:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopropina"], 2, '.', ',')),0,1,'R');
        
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"PROPINA RECIBIDA:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["montopropina"] * $valorCambio, 2, '.', ',')),0,1,'R');
    }

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,utf8_decode("CONDICIÓN DE PAGO:"),0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($reg[0]["tipopago"]),0,1,'R');

    if($reg[0]['tipopago']=="CREDITO"){
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"STATUS PAGO:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($reg[0]['fechavencecredito'] < date("Y-m-d") && $reg[0]['fechapagado'] == "0000-00-00" && $reg[0]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[0]["statusventa"]),0,1,'R');

        if($reg[0]['tipoventa']==1){
            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,utf8_decode("VENCE CRÉDITO:"),0,0,'R');
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(30,3,utf8_decode(date("d-m-Y",strtotime($reg[0]["fechavencecredito"]))),0,1,'R');

            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,"DIAS VENCIDOS:",0,0,'R');
            if($reg[0]['fechavencecredito']== '0000-00-00') {
                $this->CellFitSpace(30,3,utf8_decode("0"),0,1,'R');
            } elseif($reg[0]['fechavencecredito'] >= date("Y-m-d")) {
                $this->CellFitSpace(30,3,utf8_decode("0"),0,1,'R');
            } elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) {
                $this->CellFitSpace(30,3,utf8_decode(Dias_Transcurridos(date("Y-m-d"),$reg[0]['fechavencecredito'])),0,1,'R');
            }
        } else {
            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,"FECHA DE ENTREGA:",0,0,'R');
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(30,3,utf8_decode(date("d-m-Y",strtotime($reg[0]["fechaentrega"]))),0,1,'R');
        }

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"TOTAL ABONO:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["creditopagado"], 2, '.', ',')),0,1,'R');

        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"TOTAL DEBE:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totalpago"]+$reg[0]["montodelivery"]-$reg[0]["creditopagado"], 2, '.', ',')),0,1,'R');
        $this->Ln(1);

    } else {
        if($reg[0]["formapago2"]=="0"){
            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,utf8_decode("MÉTODO PAGO:"),0,0,'R');
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(30,3,utf8_decode($reg[0]["formapago"]),0,1,'R');

            // MONTO PAGO (Dólares)
            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,"MONTO PAGO:",0,0,'R');
            // Nota: Aquí se usa $TotalAPagar porque es el valor que debería igualar el pago total, que incluye la propina
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado"]+$reg[0]["montopropina"], 2, '.', ',')),0,1,'R');
            
            // MONTO PAGO (Bolívares)
            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,"MONTO PAGO:",0,0,'R');
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format(($reg[0]["montopagado"]+$reg[0]["montopropina"])*$valorCambio, 2, '.', ',')),0,1,'R');

        } else {
            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,utf8_decode("MÉTODO PAGO Nº 1:"),0,0,'R');
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(30,3,utf8_decode($reg[0]["formapago"]),0,1,'R');

            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,utf8_decode("MONTO PAGO Nº 1:"),0,0,'R');
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado"]+$reg[0]["montopropina"], 2, '.', ',')),0,1,'R');

            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,utf8_decode("MÉTODO PAGO Nº 2:"),0,0,'R');
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(30,3,utf8_decode($reg[0]["formapago2"]),0,1,'R');

            $this->SetX(4);
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(36,3,utf8_decode("MONTO PAGO Nº 2:"),0,0,'R');
            $this->SetFont('Courier','B',8);
            $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado2"], 2, '.', ',')),0,1,'R');
        }

        // DEVUELTO (Dólares)
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"DEVUELTO:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montodevuelto"], 2, '.', ',')),0,1,'R');
        
        // DEVUELTO (Bolívares)
        $this->SetX(4);
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(36,3,"DEVUELTO:",0,0,'R');
        $this->SetFont('Courier','B',8);
        $this->CellFitSpace(30,3,utf8_decode($simboloCambio." ".number_format($reg[0]["montodevuelto"] * $valorCambio, 2, '.', ',')),0,1,'R');
    }

    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->SetX(4);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);

    if($reg[0]['descripciones'] != ""){
        $this->SetX(3);
        $this->SetFont('Courier','B',7);
        $this->MultiCell(66,2,portales(utf8_decode($reg[0]['descripciones'] == '' ? "" : $reg[0]['descripciones'])),0,'J');
        $this->Ln();

        $this->SetX(4);
        $this->SetFont('Courier','B',12);
        $this->Cell(66,0.5,'--------------------------',0,1,'C');
        $this->SetX(4);
        $this->Cell(66,0.5,'--------------------------',0,1,'C');
        $this->Ln(3);
    }

    if($reg[0]['observaciones'] != ""){
        $this->SetX(3);
        $this->SetFont('Courier','B',7);
        $this->MultiCell(66,2,portales(utf8_decode($reg[0]['observaciones'] == '' ? "" : $reg[0]['observaciones'])),0,'J');
        $this->Ln();

        $this->SetX(4);
        $this->SetFont('Courier','B',12);
        $this->Cell(66,0.5,'--------------------------',0,1,'C');
        $this->SetX(4);
        $this->Cell(66,0.5,'--------------------------',0,1,'C');
        $this->Ln(3);
    }

    $timbre = './fotos/timbres/'.substr($reg[0]['tipodocumento'],0,1).$reg[0]['codfactura'].'.jpg';

    if (file_exists($timbre)) {
        $this->SetX(4);
        $this->Cell(66,25, $this->Image($timbre, $this->GetX(), $this->GetY(),66,25),0,1);
        $this->SetX(4);
        $this->SetFont('courier','B',10);
        $this->SetFillColor(3, 3, 3);
        $this->CellFitSpace(66,6,"TIMBRE ELECTRÓNICO SII",0,1,'C');
        $this->Ln(2);
    } else {
        $this->SetX(4);
        $this->SetFont('Courier','BI',10);
        $this->SetFillColor(3, 3, 3);
        $this->CellFitSpace(66,3,"GRACIAS POR SU COMPRA",0,1,'C');
        $this->Ln(1);
    }

    // LÍNEA DE CONTROL INTERNO - NO FISCAL
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(66,3,"CONTROL INTERNO - NO FISCAL",0,1,'C');
    $this->Ln(3);
}
########################## FUNCION TICKET VENTA ##############################

########################## FUNCION BOLETA VENTA ##############################
function BoletaVenta()
{  
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->VentasPorId();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);

    }
  
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "BOLETA DE VENTA", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(66,3,$reg[0]['documsucursal'] == '0' ? "" : "Nº ".$reg[0]['documento']." ".utf8_decode($reg[0]['cuitsucursal']),0,1,'C');

    if($reg[0]['id_provincia']!='0'){

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia'])." ".$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento'])),0,1,'C');

    }

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg[0]['direcsucursal']),0,1,'C');

    if($reg[0]['codgiro'] != "0"){
    $this->SetX(4);
    $this->CellFitSpace(66,3,"N° ACTIVIDAD/GIRO: ".utf8_decode($reg[0]['codgiro']),0,1,'C');
    }
    
    if($reg[0]['fechaautorsucursal'] != "0000-00-00"){
    $this->SetX(4);
    $this->CellFitSpace(66,3,"DE:".utf8_decode($reg[0]['fechaautorsucursal']),0,1,'C');
    }
    
    if($reg[0]['girosucursal'] != "0"){
    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg[0]['girosucursal']),0,1,'C');
    }

    $this->SetX(4);
    $this->CellFitSpace(66,3,"OBLIGADO A LLEVAR CONTABILIDAD: ".utf8_decode($reg[0]['llevacontabilidad']),0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,"AMBIENTE: PRODUCCIÓN",0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,"EMISIÓN: NORMAL",0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,"CLAVE DE ACCESO - N° DE AUTORIZACIÓN",0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg[0]['codautorizacion']),0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(20,3,"Nº BOLETA:",0,0,'L');
    $this->SetFont('Courier','B',13);
    $this->CellFitSpace(46,3,utf8_decode($reg[0]['codfactura']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJA Nº:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nrocaja']."-".$reg[0]['nomcaja']),0,1,'L');
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nombres']),0,1,'L');

    if($reg[0]['delivery']=="1"){

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
    
    }

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA VENTA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",strtotime($reg[0]['fechaventa'])),0,1,'L');

    if($reg[0]['tipoventa'] == 2){

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA ENTREGA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y",strtotime($reg[0]['fechaentrega'])),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"HORA ENTREGA:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("H:i:s",strtotime($reg[0]['fechaentrega'])),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"STATUS PEDIDO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,$reg[0]['statuspedido'] == 1 ? "PENDIENTE" : "ENTREGADO",0,1,'L');

    }
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s"),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]['nomcliente']==""){

    $this->SetFont('Courier','B',8);
    $this->SetX(4);
    $this->CellFitSpace(66, 3, "CONSUMIDOR FINAL",0,1,'C');

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(15,3,$documento = ($reg[0]['documcliente'] == '0' ? "Nº DOC:" : "Nº ".$reg[0]['documento3'].": "),0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(51,3,utf8_decode($reg[0]['dnicliente']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(15,3,"SEÑOR(A):",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->MultiCell(52,3,$this->SetFont('Courier','B',8).utf8_decode($reg[0]['nomcliente']),0,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(15,3,"DIREC:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->MultiCell(52,3,$this->SetFont('Courier','B',8).portales(utf8_decode($reg[0]['direccliente'])),0,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(15,3,"TELEFONO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(51,3,utf8_decode($reg[0]['tlfcliente'] == "" ? "**********" : $reg[0]['tlfcliente']),0,1,'L');
        
    }

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,3,'CANT',0,0,'L');
    $this->Cell(46,3,'DESCRIPCIÓN DE PRODUCTO',0,0,'C');
    $this->Cell(10,3,"IMP.",0,1,'C');

    $this->SetX(4);
    $this->Cell(22,3,'PVP.',0,0,'C');
    $this->Cell(22,3,'DCTO.',0,0,'C');
    $this->Cell(22,3,'TOTAL IMPORTE',0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $tra = new Login();
    $detalle = $tra->VerDetallesVentas();
    $cantidad = 0;
    $SubTotal = 0;
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){

    $this->SetX(4);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->CellFitSpace(10,3,utf8_decode($detalle[$i]['cantventa']),0,0,'C');
    $this->CellFitSpace(46,3,portales(utf8_decode(getSubString($detalle[$i]["producto"], 25))),0,0,'C');
    $this->CellFitSpace(10,3,utf8_decode($iva = ($detalle[$i]['ivaproducto'] != '0.00' ? number_format($detalle[$i]['ivaproducto'], 2, '.', ',')."%" : "(E)")),0,1,'C');
    $this->SetX(4);
    $this->CellFitSpace(24,3,utf8_decode($simbolo.number_format($detalle[$i]["precioventa"], 2, '.', ',')),0,0,'C');
    $this->CellFitSpace(18,3,utf8_decode(number_format($detalle[$i]["descproducto"], 2, '.', ',')),0,0,'C');
    $this->CellFitSpace(24,3,utf8_decode($simbolo.number_format($detalle[$i]["valorneto"], 2, '.', ',')),0,0,'C');
    $this->Ln();  
    }

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"SUBTOTAL:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"GRAVADO (".number_format($reg[0]["iva"], 2, '.', ',')."%):",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["subtotalivasi"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"EXENTO (0%):",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["subtotalivano"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"TOTAL ".$impuesto." (".number_format($reg[0]["iva"], 2, '.', ',')."%):",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totaliva"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"DESCONTADO %:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["descontado"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"DESC % (".number_format($reg[0]["descuento"], 2, '.', ',')."%):",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totaldescuento"], 2, '.', ',')),0,1,'R');

    if($reg[0]["repartidor"] != 0){

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"MONTO DELIVERY:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montodelivery"], 2, '.', ',')),0,1,'R');

    }

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totalpago"]+$reg[0]["montodelivery"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]["montopropina"] != 0.00){

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"PROPINA RECIBIDA:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopropina"], 2, '.', ',')),0,1,'R');

    }

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"CONDICIÓN DE PAGO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($reg[0]["tipopago"]),0,1,'R');

    if($reg[0]['tipopago']=="CREDITO"){

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"STATUS PAGO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($reg[0]['fechavencecredito'] < date("Y-m-d") && $reg[0]['fechapagado'] == "0000-00-00" && $reg[0]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[0]["statusventa"]),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"VENCE CRÉDITO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode(date("d-m-Y",strtotime($reg[0]["fechavencecredito"]))),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"DIAS VENCIDOS:",0,0,'R');
    $this->SetFont('Courier','B',8);
    if($reg[0]['fechavencecredito']== '0000-00-00') { 
        $this->CellFitSpace(30,3,utf8_decode("0"),0,1,'R');
    } elseif($reg[0]['fechavencecredito'] >= date("Y-m-d")) { 
        $this->CellFitSpace(30,3,utf8_decode("0"),0,1,'R');
    } elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) { 
        $this->CellFitSpace(30,3,utf8_decode(Dias_Transcurridos(date("Y-m-d"),$reg[0]['fechavencecredito'])),0,1,'R');
    }

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"TOTAL ABONO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["creditopagado"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"TOTAL DEBE:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totalpago"]+$reg[0]["montodelivery"]-$reg[0]["creditopagado"], 2, '.', ',')),0,1,'R');
    $this->Ln(1);

    } else {

    if($reg[0]["formapago2"]=="0"){
    
    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"MÉTODO PAGO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($reg[0]["formapago"]),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"MONTO PAGO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    //$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado"], 2, '.', ',')),0,1,'R');
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado"]+$reg[0]["montopropina"], 2, '.', ',')),0,1,'R');

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"MÉTODO PAGO Nº 1:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($reg[0]["formapago"]),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"MONTO PAGO Nº 1:",0,0,'R');
    $this->SetFont('Courier','B',8);
    //$this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado"], 2, '.', ',')),0,1,'R');
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado"]+$reg[0]["montopropina"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"MÉTODO PAGO Nº 2:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($reg[0]["formapago2"]),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"MONTO PAGO Nº 2:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montopagado2"], 2, '.', ',')),0,1,'R');
    
    }

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"DEVUELTO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["montodevuelto"], 2, '.', ',')),0,1,'R');

    }

    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->SetX(4);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);


    if($reg[0]['descripciones'] != ""){ 

    $this->SetX(3);
    $this->SetFont('Courier','B',7);
    $this->MultiCell(66,2,portales(utf8_decode($reg[0]['descripciones'] == '' ? "" : $reg[0]['descripciones'])),0,'J');
    $this->Ln();

    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->SetX(4);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);

    }

    if($reg[0]['observaciones'] != ""){ 

    $this->SetX(3);
    $this->SetFont('Courier','B',7);
    $this->MultiCell(66,2,portales(utf8_decode($reg[0]['observaciones'] == '' ? "" : $reg[0]['observaciones'])),0,'J');
    $this->Ln();

    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->SetX(4);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);

    }

    $timbre = './fotos/timbres/'.substr($reg[0]['tipodocumento'],0,1).$reg[0]['codfactura'].'.jpg';

    if (file_exists($timbre)) {

    $this->SetX(4);
    //$this->Image('./fotos/image1.png',4,150,66,20,'JPG');
    $this->Cell(66,25, $this->Image($timbre, $this->GetX(), $this->GetY(),66,25),0,1);     

    $this->SetX(4);
    $this->SetFont('courier','B',10);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66,6,"TIMBRE ELECTRÓNICO SII",0,1,'C');
    $this->Ln(2);

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','BI',10);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66,3,"GRACIAS POR SU COMPRA",0,1,'C');
    $this->Ln(3);

   }
    
}
########################## FUNCION BOLETA VENTA ##############################

########################## FUNCION FACTURA VENTA #############################
function FacturaVenta()
{
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->VentasPorId();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

    //Logo
    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 10, 4.5, 30, 10, "PNG");
    }
        
    //Bloque datos de empresa
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(5, 15, 42, 25, '1.5', "");
    
    $this->SetFont('Courier','BI',8);
    $this->SetTextColor(3,3,3); // Establece el color del texto (en este caso es Negro)
    $this->SetXY(5, 15);
    $this->CellFitSpace(42, 5,utf8_decode($reg[0]['nomsucursal']), 0, 1); //Membrete Nro 1

    $this->SetFont('Courier','B',6);
    if($reg[0]['id_provincia']!='0'){
    $this->SetX(5);
    $this->CellFitSpace(42, 3,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia']." ").$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento']." ")), 0,1);
    }

   $this->SetX(5);
    $this->CellFitSpace(42, 3,$reg[0]['direcsucursal'], 0,1);

    $this->SetXY(5,23);
    $this->CellFitSpace(42, 3,'Nº ACTIVIDAD/GIRO: '.$cgiro = ($reg[0]['codgiro'] == "0" ? "******" : $reg[0]['codgiro']), 0,1);

    $this->SetXY(5,26);
    $this->CellFitSpace(42, 3,$giro = ($reg[0]['girosucursal'] == "0" ? "******" : $reg[0]['girosucursal']), 0,1);

    $this->SetXY(5,29);
    $this->CellFitSpace(42, 3,'Nº TLF: '.utf8_decode($reg[0]['tlfsucursal']), 0,1);

    $this->SetXY(5,33);
    $this->CellFitSpace(42, 3,utf8_decode($reg[0]['correosucursal']), 0,1);

    $this->SetXY(5,36);
    $this->CellFitSpace(42, 3,'OBLIGADO A LLEVAR CONTABILIDAD: '.utf8_decode($reg[0]['llevacontabilidad']), 0 , 0); 
      
    //Bloque datos de factura
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(48, 5, 57, 35, '1.5', "");

    $this->SetFont('Courier','B',10);
    $this->SetXY(48, 4);
    $this->Cell(5, 7, 'FACTURA DE VENTA', 0 , 0);


    $this->SetFont('Courier','B',7);
    $this->SetXY(48, 7);
    $this->Cell(5, 7, 'Nº DE '.$documento = ($reg[0]['documsucursal'] == '0' ? "REG.:" : $reg[0]['documento'].":"), 0 , 0);
    $this->SetXY(78, 7);
    $this->CellFitSpace(28, 7,utf8_decode($reg[0]['cuitsucursal']), 0, 0);

    $this->SetXY(48, 10);
    $this->SetFont('Courier','B',8);
    $this->Cell(5, 7, 'Nº DE FACTURA', 0 , 0);
    $this->SetXY(78, 10);
    $this->CellFitSpace(28, 7,utf8_decode($reg[0]['codfactura']), 0, 0);

    $this->SetXY(48, 13);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,'NÚMERO DE AUTORIZACIÓN:', 0, 0);
    $this->SetXY(48, 16);
    $this->CellFitSpace(56, 7,utf8_decode($reg[0]['codautorizacion']), 0, 0);

    $this->SetXY(48, 19);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,'NÚMERO DE SERIE:', 0, 0);
    $this->SetXY(48, 22);
    $this->CellFitSpace(56, 7,utf8_decode($reg[0]['codserie']), 0, 0);

    $this->SetXY(48, 25);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,"FECHA DE AUTORIZACIÓN:", 0, 0);
    $this->SetXY(78, 25);
    $this->Cell(28, 7,$fecha = ($reg[0]['fechaautorsucursal'] == '0000-00-00' ? "" : date("d-m-Y",strtotime($reg[0]['fechaautorsucursal']))), 0, 0);

    $this->SetXY(48, 28);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,"FECHA DE VENTA:", 0, 0);
    $this->SetXY(78, 28);
    $this->Cell(28, 7,date("d-m-Y H:i:s",strtotime($reg[0]['fechaventa'])), 0, 0);


    $this->SetXY(48, 31);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,'AMBIENTE: ', 0 , 0);
    $this->SetXY(78, 31);
    $this->Cell(28, 7,'PRODUCCIÓN', 0 , 0);

    $this->SetXY(48, 34);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,'EMISIÓN: ', 0 , 0);
    $this->SetXY(78, 34);
    $this->Cell(28, 7,'NORMAL', 0 , 0);
     
    //Bloque datos de cliente
    $this->SetLineWidth(0.3);
    $this->SetFillColor(192);
    $this->RoundedRect(5, 41, 100, 10, '1.5', "");
    $this->SetFont('Courier','B',6);

    $this->SetXY(6, 40.2);
    $this->CellFitSpace(66, 5,'RAZÓN SOCIAL: '.utf8_decode($reg[0]['nomcliente']), 0, 0);
    $this->CellFitSpace(32, 5,'Nº DE '.$documento = ($reg[0]['documcliente'] == '' ? "DOC: " : $reg[0]['documento3'].": ").$dni = ($reg[0]['dnicliente'] == '' ? "CONSUMIDOR FINAL" : $reg[0]['dnicliente']), 0, 0);

    $this->SetXY(6, 43.2);
    $this->CellFitSpace(66, 5,'GIRO: '.utf8_decode($reg[0]['girocliente'] == '' ? "**********" : $reg[0]['girocliente']), 0, 0);
    $this->CellFitSpace(32, 5,'Nº DE TLF: '.($reg[0]['tlfcliente'] == '' ? "**********" : $reg[0]['tlfcliente']), 0, 0);

    $this->SetXY(6, 46.2);
    $this->CellFitSpace(92, 5,'DIRECCIÓN: '.utf8_decode($reg[0]['direccliente'] == '' ? "**********" : $reg[0]['direccliente']), 0, 0);

    $this->Ln(6);
    $this->SetX(5);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(5,3,'N°',1,0,'C', True);
    $this->Cell(50,3,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(12,3,'CANTIDAD',1,0,'C', True);
    $this->Cell(14,3,'PRECIO',1,0,'C', True);
    $this->Cell(19,3,'IMPORTE',1,1,'C', True);
    
    $tra = new Login();
    $detalle = $tra->VerDetallesVentas();
    $cantidad = 0;
    $SubTotal = 0;

    $this->SetWidths(array(5,50,12,14,19));

    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){ 
    $cantidad += $detalle[$i]['cantventa'];
    $valortotal = $detalle[$i]["precioventa"]*$detalle[$i]["cantventa"];
    $SubTotal += $detalle[$i]['valorneto'];

    $this->SetX(5);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier',"",6);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->RowFacture(array($a++,utf8_decode($detalle[$i]["producto"]),utf8_decode($detalle[$i]['cantventa']),utf8_decode(number_format($detalle[$i]["precioventa"], 2, '.', ',')),utf8_decode(number_format($detalle[$i]['valorneto'], 2, '.', ','))));
       
    }
     
    $this->Ln(1);
    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'INFORMACIÓN ADICIONAL',1,0,'C');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->SetFont('Courier','B',6);
    $this->CellFitSpace(20,3.5,'SUBTOTAL ',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'Nº DE CAJA: '.utf8_decode($reg[0]['nrocaja']."-".$reg[0]['nomcaja']),1,0,'L');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,'GRAVADO ('.number_format($reg[0]["iva"], 2, '.', ',').'%):',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["subtotalivasi"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'CAJERO(A): '.utf8_decode($reg[0]['nombres']),1,0,'L');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,'EXENTO (0%):',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["subtotalivano"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'FECHA DE EMISIÓN: '.date("d-m-Y H:i:s"),1,0,'L');

    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,$impuesto." (".number_format($reg[0]["iva"], 2, '.', ',')."%):",1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["totaliva"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'CONDICIÓN DE PAGO: '.utf8_decode($reg[0]['tipopago'])."          ".utf8_decode($reg[0]['tipopago'] == 'CONTADO' ? "" : "VENCIMIENTO: ".date("d-m-Y",strtotime($reg[0]['fechavencecredito']))),1,0,'L');

    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,"DESCONTADO %:",1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["descontado"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'MEDIO DE PAGO: '.utf8_decode($medio = ($reg[0]['tipopago'] == 'CONTADO' ? $reg[0]['formapago'] : $reg[0]['formapago']))." ".utf8_decode($medio = ($reg[0]['formapago2'] == '0' || $reg[0]['formapago2'] == '' ? "" : "  -  ".$reg[0]['formapago2'])),1,0,'L');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,'DESC % ('.number_format($reg[0]["descuento"], 2, '.', ',').'%):',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["totaldescuento"], 2, '.', ','),1,0,'R');
    $this->Ln();


    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(59,3.5,'PROPINA RECIBIDA: '.$simbolo.number_format($reg[0]["montopropina"], 2, '.', ','),1,0,'L');

    $this->Cell(2,3.5,"",0,0,'C');
    $this->SetFont('Courier','B',6);
    $this->Cell(20,3.5,'MONTO DELIVERY:',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["montodelivery"], 2, '.', ','),1,0,'R');
    $this->Ln();


    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(59,3.5,'',0,0,'L');

    $this->Cell(2,3.5,"",0,0,'C');
    $this->SetFont('Courier','B',6);
    $this->Cell(20,3.5,'IMPORTE TOTAL:',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["totalpago"]+$reg[0]["montodelivery"], 2, '.', ','),1,0,'R');
    $this->Ln(4);
    
    $this->SetX(5);
    $this->SetDrawColor(3,3,3);
    $this->SetFont('Courier','BI',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(100,2,'MONTO EN LETRAS: '.utf8_decode(numtoletras(number_format($reg[0]['totalpago']+$reg[0]["montodelivery"], 2, '.', ''))),0,0,'L');
    $this->Ln(); 
}  
########################## FUNCION FACTURA VENTA ##############################

########################## FUNCION LISTAR VENTAS ##############################
function TablaListarVentas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->ListarVentas();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE VENTAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(40,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(38,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(22,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,30,38,22,20,30,20,35,25,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),utf8_decode($reg[$i]["tipopago"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
   }
   
    $this->Cell(195,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }

    } else {

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(60,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,60,25,20,45,20,35,25,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),utf8_decode($reg[$i]["tipopago"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
   }
   
    $this->Cell(195,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS ##############################

########################## FUNCION LISTAR VENTAS DIARIAS ##############################
function TablaListarVentasDiarias()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->ListarVentasDiarias();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE VENTAS DIARIAS DEL (DIA '.date("d-m-Y").")",0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(58,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(22,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,58,22,20,45,20,35,25,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),utf8_decode($reg[$i]["tipopago"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
   }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS DIARIAS ##############################

########################## FUNCION LISTAR VENTAS POR CAJAS ##############################
function TablaListarVentasxCajas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarVentasxCajas(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipopago']) == 1){ 
    $this->Cell(335,7,'LISTADO DE VENTAS GENERALES POR CAJA',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 2){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CONTADO POR CAJA',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 3){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CRÉDITO POR CAJA',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"CAJA Nº: ".utf8_decode($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"RESPONSABLE: ".utf8_decode($reg[0]["nombres"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(48,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    //$this->Cell(22,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(22,8,$impuesto,1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(28,8,'ABONADO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DISPONIBLE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,48,20,30,20,35,22,20,30,28,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;
    $TotalDisponible=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalAbono+=$reg[$i]['creditopagado'];
    $TotalDebe+=$reg[$i]['totalpago']-$reg[$i]['creditopagado'];
    $TotalDisponible+=($reg[$i]["tipopago"] == "CREDITO" ? number_format($reg[$i]['creditopagado'], 2, '.', '') : number_format($reg[$i]['totalpago'], 2, '.', ''));

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]["tipopago"]),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaventa']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),

        $var = ($reg[$i]["tipopago"] == "CREDITO" ? utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')) : utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')))

    ));
   }
   
    $this->Cell(143,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(22,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(28,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDisponible, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS POR CAJAS ##############################

########################## FUNCION LISTAR VENTAS POR FECHAS ##############################
function TablaListarVentasxFechas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarVentasxFechas(); 

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipopago']) == 1){ 
    $this->Cell(335,7,'LISTADO DE VENTAS GENERALES POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 2){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CONTADO POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 3){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CRÉDITO POR FECHAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(48,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    //$this->Cell(22,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(22,8,$impuesto,1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(28,8,'ABONADO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DISPONIBLE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,48,20,30,20,35,22,20,30,28,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;
    $TotalDisponible=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalAbono+=$reg[$i]['creditopagado'];
    $TotalDebe+=$reg[$i]['totalpago']-$reg[$i]['creditopagado'];
    $TotalDisponible+=($reg[$i]["tipopago"] == "CREDITO" ? number_format($reg[$i]['creditopagado'], 2, '.', '') : number_format($reg[$i]['totalpago'], 2, '.', ''));

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]["tipopago"]),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaventa']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),

        $var = ($reg[$i]["tipopago"] == "CREDITO" ? utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')) : utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')))

    ));
   }
   
    $this->Cell(143,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(22,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(28,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDisponible, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS POR FECHAS ##############################

########################## FUNCION LISTAR VENTAS POR CONDICION DE PAGO Y FECHAS ##############################
function TablaListarVentasxCondiciones()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarVentasxCondiciones(); 
    $formapago = utf8_decode($_GET["formapago"]);

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipopago']) == 1){ 
    $this->Cell(335,7,'LISTADO DE VENTAS GENERALES POR CONDICION DE PAGO',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 2){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CONTADO POR CONDICION DE PAGO',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 3){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CRÉDITO POR CONDICION DE PAGO',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"CAJA Nº: ".utf8_decode($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"RESPONSABLE: ".utf8_decode($reg[0]["nombres"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"CONDICIÓN DE PAGO: ".$formapago,0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(50,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(20,8,'STATUS',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(30,8,'DESC %',1,0,'C', True);
    $this->Cell(40,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL PAGO',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,25,50,20,30,20,35,30,30,40,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;
    $TotalPagado=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];

    if($reg[$i]['formapago'] == $formapago){

    $ImportePagado = $reg[$i]['montopagado']-$reg[$i]['montodevuelto'];
    $TotalPagado += $reg[$i]['montopagado']-$reg[$i]['montodevuelto'];

    } else {

    $ImportePagado = $reg[$i]['montopagado2'];
    $TotalPagado += $reg[$i]['montopagado2'];
   
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaventa']))),utf8_decode(number_format($reg[$i]['articulos'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($ImportePagado, 2, '.', ','))));
   }
   
    $this->Cell(140,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalPagado, 2, '.', ',')),0,0,'L');
    $this->Ln();
 }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS POR CONDICION DE PAGO Y FECHAS ##############################

######################## FUNCION LISTAR VENTAS POR TIPOS DE CLIENTES #########################
function TablaListarVentasxTipos()
   {

    $tra = new Login();
    $reg = $tra->BuscarVentasxTipos();

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################
    
    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,8,"LISTADO DE VENTAS DE CLIENTES ".$tipo = ($_GET["tipocliente"] == 'NATURAL' ? "NATURALES" : "JURIDICOS"),0,0,'C');
    $this->Ln();
    
    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(260,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE DOCUMENTO',1,0,'C', True);
    $this->Cell(100,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(38,8,'Nº DE TELÉFONO',1,0,'C', True);
    $this->Cell(30,8,'CANT. COMPRAS',1,0,'C', True);
    $this->Cell(42,8,'TOTAL COMPRAS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,100,38,30,42));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalGeneral=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $TotalArticulos+=$reg[$i]['cantidad'];
    $TotalGeneral+=$reg[$i]['totalcompras'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($documento = ($reg[$i]['documcliente'] == '0' ? "DOCUMENTO" : $reg[$i]['documento']).": ".$reg[$i]["dnicliente"]),utf8_decode($reg[$i]['nomcliente']),utf8_decode($reg[$i]['tlfcliente'] == '' ? "*********" : $reg[$i]['tlfcliente']),utf8_decode(number_format($reg[$i]['cantidad'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalcompras'], 2, '.', ','))));
   }
 }
   
    $this->Cell(188,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(42,5,utf8_decode($simbolo.number_format($TotalGeneral, 2, '.', ',')),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR VENTAS POR TIPOS DE CLIENTES ########################

######################## FUNCION LISTAR VENTAS POR CLIENTES #########################
function TablaListarVentasxClientes()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarVentasxClientes();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,"LISTADO DE DETALLES DE VENTAS POR CLIENTE ",0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"Nº DE ".utf8_decode($documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : $reg[0]['documento3']).": ".$reg[0]["dnicliente"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"NOMBRE DE CLIENTE: ".portales(utf8_decode($reg[0]["nomcliente"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"Nº DE TELÉFONO: ".portales(utf8_decode($reg[0]["tlfcliente"] == "" ? "********" : $reg[0]["tlfcliente"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"PROVINCIA: ".portales(utf8_decode($reg[0]["id_provincia"] == "0" ? "********" : $reg[0]["provincia2"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DEPARTAMENTO: ".portales(utf8_decode($reg[0]["id_departamento"] == "0" ? "********" : $reg[0]["departamento2"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DIRECCIÓN: ".portales(utf8_decode($reg[0]["direccliente"] == "" ? "********" : $reg[0]["direccliente"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"CORREO ELECTRONICO: ".portales(utf8_decode($reg[0]["emailcliente"] == "" ? "********" : $reg[0]["emailcliente"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(30,8,'STATUS',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(35,8,'Nº ARTICULOS',1,0,'C', True);
    $this->Cell(45,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(40,8,$impuesto,1,0,'C', True);
    $this->Cell(40,8,'DESC %',1,0,'C', True);
    $this->Cell(45,8,'TOTAL IMPORTE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,30,45,35,45,40,40,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalImpuesto=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalImpuesto+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),utf8_decode($reg[$i]['articulos']),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
   }
 }
   
    $this->Cell(125,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(45,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(45,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR VENTAS POR CLIENTES #########################

######################## FUNCION LISTAR DELIVERY POR VENTAS #########################
function TablaListarDeliveryxFechas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarDeliveryxFechas();

    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################
    
    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,7,"LISTADO DE DELIVERY POR FECHAS",0,0,'C');
    $this->Ln();

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(190,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(190,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Cell(190,5,"Nº DE DOCUMENTO: ".utf8_decode($reg[0]["dni2"]),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"REPARTIDOR: ".utf8_decode($reg[0]['nombres2']),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"PORCENTAJE COMISIÓN: ".utf8_decode($reg[0]['comision2'])."%",0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(26,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(24,8,'ARTICULOS',1,0,'C', True);
    $this->Cell(33,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(33,8,'TOTAL DELIVERY',1,0,'C', True);
    $this->Cell(33,8,'TOTAL COMISIÓN',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,26,30,24,33,33,33));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalGravado=0;
    $TotalExento=0;
    $TotalImpuesto=0;
    $TotalDescuento=0;
    $TotalImporte=0;
    $TotalDelivery=0;
    $TotalComision=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalGravado+=$reg[$i]['subtotalivasi'];
    $TotalExento+=$reg[$i]['subtotalivano'];
    $TotalImpuesto+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalDelivery+=$reg[$i]['montodelivery'];
    $TotalComision+=$reg[$i]['montodelivery']*$reg[$i]['comision2']/100;

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechaventa']))),utf8_decode($reg[$i]['articulos']),$simbolo.utf8_decode($reg[$i]['totalpago']),utf8_decode($simbolo.number_format($reg[$i]['montodelivery'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['montodelivery']*$reg[$i]['comision2']/100, 2, '.', ','))));
   }
 }
   
    $this->Cell(66,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(24,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(33,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(33,5,utf8_decode($simbolo.number_format($TotalDelivery, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(33,5,utf8_decode($simbolo.number_format($TotalComision, 2, '.', ',')),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR DELIVERY POR VENTAS #########################

######################## FUNCION LISTAR COMISION POR VENTAS #########################
function TablaListarComisionxVentas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarComisionxVentas();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,"LISTADO DE COMISIÓN POR VENTAS",0,0,'C');
    $this->Ln();

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Cell(335,5,"Nº DE DOCUMENTO: ".utf8_decode($reg[0]["dni"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"VENDEDOR: ".utf8_decode($reg[0]['nombres']),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"PORCENTAJE COMISIÓN: ".utf8_decode($reg[0]['comision'])."%",0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(25,8,'STATUS',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(25,8,'ARTICULOS',1,0,'C', True);
    $this->Cell(40,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,$impuesto,1,0,'C', True);
    $this->Cell(35,8,'DESC %',1,0,'C', True);
    $this->Cell(40,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(40,8,'TOTAL COMISIÓN',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,25,45,25,40,35,35,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalImpuesto=0;
    $TotalDescuento=0;
    $TotalImporte=0;
    $TotalComision=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalImpuesto+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalComision+=$reg[$i]['totalpago']*$reg[$i]['comision']/100;

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),utf8_decode($reg[$i]['articulos']),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago']*$reg[$i]['comision']/100, 2, '.', ','))));
   }
 }
   
    $this->Cell(115,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,utf8_decode(number_format($TotalArticulos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImpuesto, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalComision, 2, '.', ',')),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR COMISION POR VENTAS #########################

########################## FUNCION INFORME DE VENTAS POR FECHAS ##############################
function InformeVentasxFechas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $sucursal = new Login();
    $sucursal = $sucursal->SucursalesPorId();
    $simbolo = ($sucursal[0]['simbolo'] == "" ? "" : $sucursal[0]['simbolo']);

    $venta = new Login();
    $venta = $venta->SumarVentasxFechas();

    $compra = new Login();
    $compra = $compra->SumarComprasxFechas();

    $arqueo = new Login();
    $arqueo = $arqueo->SumarArqueosxFechas();

    $cartera = new Login();
    $cartera = $cartera->SumarCarteraxFechas();

    $utilidadneta = $venta[0]['totalventa']-$venta[0]['totalcompra']-$venta[0]['totaliva'];
    $balance = $venta[0]['totalventa']-$venta[0]['totaliva']+$arqueo[0]['totalingresos']+$arqueo[0]['totalabonos'];
    $balance2 = $compra[0]['totalcomprageneral']+$arqueo[0]['totalegresos'];
    $balancegeneral = $balance - $balance2;

    ################################# MEMBRETE A4 #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',11);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE A4 #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'INFORME DE VENTAS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($sucursal[0]['documento'])." SUCURSAL: ".utf8_decode($sucursal[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($sucursal[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($sucursal[0]["nomencargado"])),0,1,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'TOTAL DE VENTAS',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($venta[0]['totalventa'], 2, '.', ',')),0,0,'R');
    $this->Ln();

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'TOTAL DE INGRESOS',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($arqueo[0]['totalingresos'], 2, '.', ',')),0,0,'R');
    $this->Ln();

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'ABONOS A CRÉDITOS',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($arqueo[0]['totalabonos'], 2, '.', ',')),0,0,'R');
    $this->Ln();

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'TOTAL DE COMPRAS',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($compra[0]['totalcomprageneral'], 2, '.', ',')),0,0,'R');
    $this->Ln();
   
    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'TOTAL DE GASTOS (EGRESOS)',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($arqueo[0]['totalegresos'], 2, '.', ',')),0,0,'R');
    $this->Ln();

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'CARTERA DE CLIENTES',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($cartera[0]['totaldebe']-$cartera[0]['totalpagado'], 2, '.', ',')),0,0,'R');
    $this->Ln();
  
    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'TOTAL DE IMPUESTOS VENTAS '.$impuesto.' ('.$valor.'%)',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($venta[0]['totaliva'], 2, '.', ',')),0,0,'R');
    $this->Ln();

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'BALANCE GENERAL ',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($balancegeneral, 2, '.', ',')),0,0,'R');
    $this->Ln();

    $this->SetFont('courier','B',12);
    $this->Cell(120,8,'UTILIDAD NETA ',0,0,'L', false);
    $this->SetFont('courier','B',14);
    $this->Cell(70,8,utf8_decode($simbolo.number_format($utilidadneta, 2, '.', ',')),0,0,'R');
    $this->Ln();


    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION INFORME DE VENTAS POR FECHAS ##############################



########################## FUNCION LISTAR GANANCIAS EN VENTAS POR FECHAS ##############################
function TablaListarGananciasVentasxFechas()
{

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarGananciasVentasxFechas();

  ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(330,10,'LISTADO DE GANANCIAS VENTAS POR FECHAS',0,0,'C');

    
if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->Cell(335,6,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,6,"ENCARGADO SUCURSAL: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE CAJA',1,0,'C', True);
    $this->Cell(32,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(50,8,'DESCRIPCIÓN DE CLIENTE',1,0,'C', True);
    $this->Cell(20,8,'STATUS',1,0,'C', True);
    $this->Cell(20,8,'PAGO',1,0,'C', True);
    $this->Cell(32,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(20,8,'Nº ARTIC',1,0,'C', True);
    $this->Cell(30,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(20,8,'DESC',1,0,'C', True);
    $this->Cell(32,8,'IMPORTE TOTAL',1,0,'C', True);
    $this->Cell(30,8,'GANANCIAS',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,32,50,20,20,32,20,30,20,32,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalGravado=0;
    $TotalExento=0;
    $TotalImpuesto=0;
    $TotalDescuento=0;
    $TotalImporte=0;
    $TotalGanancia=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalGravado+=$reg[$i]['subtotalivasi'];
    $TotalExento+=$reg[$i]['subtotalivano'];
    $TotalImpuesto+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalGanancia+=$reg[$i]['totalpago']-$reg[$i]['totalcompra'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["nrocaja"].": ".$reg[$i]["nomcaja"]),utf8_decode($reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]["statusventa"]),utf8_decode($reg[$i]["tipopago"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),utf8_decode($reg[$i]["articulos"]),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['totalcompra'], 2, '.', ','))));
   }
 }
   
    $this->Cell(199,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,utf8_decode($TotalArticulos),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(20,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(32,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalGanancia, 2, '.', ',')),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR GANANCIAS EN VENTAS POR FECHAS ##############################

################################### REPORTES DE VENTAS ##################################

























############################## REPORTES DE CREDITOS ##################################

########################## FUNCION TICKET CREDITO ##############################
function TicketCredito()
{  

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->CreditosPorId();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);

    }
  
    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(66, 5, "TICKET DE CRÉDITO", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(4);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(66,3,$reg[0]['documsucursal'] == '0' ? "" : "Nº ".$reg[0]['documento']." ".utf8_decode($reg[0]['cuitsucursal']),0,1,'C');

    if($reg[0]['id_provincia']!='0'){

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia'])." ".$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento'])),0,1,'C');

    }

    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg[0]['direcsucursal']),0,1,'C');

    $this->SetX(4);
    $this->CellFitSpace(66,3,"OBLIGADO A LLEVAR CONTABILIDAD: ".utf8_decode($reg[0]['llevacontabilidad']),0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,"Nº ".utf8_decode($reg[0]['tipodocumento'].": ".$reg[0]['codfactura']),0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,"AMBIENTE: PRODUCCIÓN",0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,"EMISIÓN: NORMAL",0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,"CLAVE DE ACCESO - N° DE AUTORIZACIÓN",0,1,'C');
    
    $this->SetX(4);
    $this->CellFitSpace(66,3,utf8_decode($reg[0]['codautorizacion']),0,1,'C');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    if($reg[0]['nomcliente']==""){

    $this->SetFont('Courier','B',8);
    $this->SetX(4);
    $this->CellFitSpace(66, 3, "CONSUMIDOR FINAL",0,1,'C');

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(15,3,$documento = ($reg[0]['documcliente'] == '0' ? "Nº DOC:" : "Nº ".$reg[0]['documento3'].": "),0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(51,3,utf8_decode($reg[0]['dnicliente']),0,1,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(15,3,"SEÑOR(A):",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->MultiCell(41,3,$this->SetFont('Courier','B',8).utf8_decode($reg[0]['nomcliente']),0,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(15,3,"DIREC:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->MultiCell(51,3,$this->SetFont('Courier','B',8).portales(utf8_decode(getSubString($reg[0]['direccliente'],32))),0,'L');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(15,3,"TELEFONO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(51,3,utf8_decode($reg[0]['tlfcliente'] == "" ? "**********" : $reg[0]['tlfcliente']),0,1,'L');
 
    }

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s"),0,1,'L');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(16,3,"Nº CAJA",0,0,'C');
    $this->Cell(24,3,"MONTO ABONO",0,0,'C');
    $this->Cell(26,3,"FECHA",0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $tra = new Login();
    $detalle = $tra->VerDetallesAbonos();
    if($detalle==""){
        echo "";      
    } else {
    
    $this->SetWidths(array(22,22,22));

    $a=1;
    $cantidad=0;    
    for($i=0;$i<sizeof($detalle);$i++){

    $this->SetX(4);
    $this->SetFont('Courier','B',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->CellFitSpace(16,4,utf8_decode($detalle[$i]['nrocaja']),0,0,'C');
    $this->CellFitSpace(24,4,utf8_decode($simbolo.number_format($detalle[$i]['montoabono'], 2, '.', ',')),0,0,'C');
    $this->CellFitSpace(26,4,utf8_decode(date("d-m-Y H:i:s",strtotime($detalle[$i]['fechaabono']))),0,0,'C');
    $this->Ln();  
  }
    }

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(66,3,utf8_decode($reg[0]["tipopago"]." - ".$variable = ( $reg[0]['tipopago'] == 'CONTADO' ? $reg[0]['formapago'] : $reg[0]['formapago'])),0,1,'C');

    if($reg[0]['tipoventa']=='1'){

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"STATUS PAGO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($reg[0]['fechavencecredito'] < date("Y-m-d") && $reg[0]['fechapagado'] == "0000-00-00" && $reg[0]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[0]["statusventa"]),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"VENCE CRÉDITO",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode(date("d-m-Y",strtotime($reg[0]["fechavencecredito"]))),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"DIAS VENCIDOS:",0,0,'R');
    $this->SetFont('Courier','B',8);
    if($reg[0]['fechavencecredito']== '0000-00-00') { 
        $this->CellFitSpace(30,3,utf8_decode("0"),0,1,'R');
    } elseif($reg[0]['fechavencecredito'] >= date("Y-m-d")) { 
        $this->CellFitSpace(30,3,utf8_decode("0"),0,1,'R');
    } elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) { 
        $this->CellFitSpace(30,3,utf8_decode(Dias_Transcurridos(date("Y-m-d"),$reg[0]['fechavencecredito'])),0,1,'R');
    }

    } else {

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"FECHA DE ENTREGA:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode(date("d-m-Y",strtotime($reg[0]["fechaentrega"]))),0,1,'R');

    }

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"IMPORTE TOTAL:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totalpago"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"TOTAL ABONO:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["creditopagado"], 2, '.', ',')),0,1,'R');

    $this->SetX(4);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(36,3,"TOTAL DEBE:",0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode($simbolo.number_format($reg[0]["totalpago"]-$reg[0]["creditopagado"], 2, '.', ',')),0,1,'R');
    $this->Ln(1);

    $this->SetX(4);
    $this->SetFont('Courier','B',12);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->SetX(4);
    $this->Cell(66,0.5,'--------------------------',0,1,'C');
    $this->Ln(3);

    $this->SetFont('Courier','B',9);
    $this->SetX(4);
    $this->Cell(66,3,'FIRMA: ___________________________',0,1,'C');
    $this->Ln(4);

    $this->SetX(4);
    $this->SetFont('Courier','BI',9);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66,3,"GRACIAS POR PREFERIRNOS",0,1,'C');
    $this->Ln(3);     
}
########################## FUNCION TICKET CREDITO ##############################

########################## FUNCION LISTAR CREDITOS ##############################
function TablaListarCreditos()
   {

    $tra = new Login();
    $reg = $tra->ListarCreditos();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE CRÉDITOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(40,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(35,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(50,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'STATUS',1,0,'C', True);
    $this->Cell(25,8,'DIAS VENC',1,0,'C', True);
    $this->Cell(40,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,35,50,25,25,40,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalAbono+=$reg[$i]['creditopagado'];
    $TotalDebe+=$reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]['fechavencecredito'] == '0000-00-00' || $reg[$i]['fechapagado']== "0000-00-00" || $reg[$i]['fechavencecredito'] >= date("Y-m-d")){
        $fechavencecredito = "0";
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado']== "0000-00-00"){
        $fechavencecredito = Dias_Transcurridos(date("Y-m-d"),$reg[$i]['fechavencecredito']);
    } else {
        $fechavencecredito = Dias_Transcurridos($reg[$i]['fechapagado'],$reg[$i]['fechavencecredito']);
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),
        utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),
        utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),
        utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),
        utf8_decode($fechavencecredito),
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));

   }
   
    $this->Cell(230,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }

    } else {

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(75,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'STATUS',1,0,'C', True);
    $this->Cell(25,8,'DIAS VENC',1,0,'C', True);
    $this->Cell(50,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,75,30,25,50,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalAbono+=$reg[$i]['creditopagado'];
    $TotalDebe+=$reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]['fechavencecredito'] == '0000-00-00' || $reg[$i]['fechapagado']== "0000-00-00" || $reg[$i]['fechavencecredito'] >= date("Y-m-d")){
        $fechavencecredito = "0";
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado']== "0000-00-00"){
        $fechavencecredito = Dias_Transcurridos(date("Y-m-d"),$reg[$i]['fechavencecredito']);
    } else {
        $fechavencecredito = Dias_Transcurridos($reg[$i]['fechapagado'],$reg[$i]['fechavencecredito']);
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
    	utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),
    	utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),
    	utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),
    	utf8_decode($fechavencecredito),
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),
        utf8_decode($simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));

   }
   
    $this->Cell(230,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
       }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CREDITOS ##############################

######################## FUNCION LISTAR ABONOS CREDITOS POR CAJAS #########################
function TablaListarAbonosCreditosxCajas()
   {

    $tra = new Login();
    $reg = $tra->BuscarAbonosCreditosxCajas();

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(260,7,"LISTADO DE ABONOS CRÉDITOS POR CAJAS",1,0,'C');
    $this->Ln();

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"CAJA Nº: ".utf8_decode($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"RESPONSABLE: ".utf8_decode($reg[0]["nombres"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"CONDICIÓN DE PAGO: ".$_GET["formapago"],0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(45,8,'Nº DE DOCUMENTO',1,0,'C', True);
    $this->Cell(75,8,'DESCRIPCIÓN DE CLIENTE',1,0,'C', True);
    $this->Cell(45,8,'FECHA DE ABONO',1,0,'C', True);
    $this->Cell(45,8,'MONTO ABONO',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,35,45,75,45,45));

    $a=1;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalImporte+=$reg[$i]['montoabono'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),

        utf8_decode($reg[$i]['documento'].": ".$reg[$i]['dnicliente']),

        portales(utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente'])),


        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaabono']))),


        utf8_decode($simbolo.number_format($reg[$i]['montoabono'], 2, '.', ','))

       ));
   }
 }
   
    $this->Cell(215,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR ABONOS CREDITOS POR CAJAS #########################

######################## FUNCION LISTAR CREDITOS POR FECHAS ##########################
function TablaListarCreditosxFechas()
   {

    $tra = new Login();
    $reg = $tra->BuscarCreditosxFechas();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(335,7,'LISTADO DE CRÉDITOS GENERALES POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(335,7,'LISTADO DE CRÉDITOS PAGADOS POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(335,7,'LISTADO DE CRÉDITOS PEDIENTES POR FECHAS',0,0,'C');
    }
    
    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(80,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'STATUS',1,0,'C', True);
    $this->Cell(50,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(40,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,80,30,50,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalAbono+=$reg[$i]['creditopagado'];
    $TotalDebe+=$reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));
   }
 }
   
    $this->Cell(210,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR CREDITOS POR FECHAS ##########################

######################## FUNCION LISTAR CREDITOS POR CLIENTES #########################
function TablaListarCreditosxClientes()
{

    $tra = new Login();
    $reg = $tra->BuscarCreditosxClientes();

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(260,7,'LISTADO DE CRÉDITOS GENERALES POR CLIENTE',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(260,7,'LISTADO DE CRÉDITOS PAGADOS POR CLIENTE',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(260,7,'LISTADO DE CRÉDITOS PEDIENTES POR CLIENTE',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(260,5,"Nº DE ".utf8_decode($documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : $reg[0]['documento3']).": ".$reg[0]["dnicliente"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"CLIENTE: ".utf8_decode($reg[0]['nomcliente']),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"Nº DE TELEFONO: ".utf8_decode($reg[0]['tlfcliente'] == "" ? "********" : $reg[0]['tlfcliente']),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"DIRECCIÓN DOMICILIARIA: ".utf8_decode($reg[0]['direccliente'] == "" ? "********" : $reg[0]['direccliente']),0,1,'L');
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(35,8,'STATUS',1,0,'C', True);
    $this->Cell(50,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(45,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,35,50,45,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalAbono+=$reg[$i]['creditopagado'];
    $TotalDebe+=$reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),
    	utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));
   }
 }
   
    $this->Cell(135,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(45,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(40,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR CREDITOS POR CLIENTES #########################

######################## FUNCION LISTAR DETALLES CREDITOS POR CLIENTES #########################
function TablaListarDetallesCreditosxClientes()
   {

    $tra = new Login();
    $reg = $tra->BuscarDetallesCreditosxClientes();

    ################################# MEMBRETE LETTER #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_letter_X'], $this->GetY()+$GLOBALS['logo1_letter_Y'], $GLOBALS['logo1_letter']),0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-$GLOBALS['logo2_letter_X'], $this->GetY()+$GLOBALS['logo2_letter_Y'], $GLOBALS['logo2_letter']),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(260,7,'LISTADO DE DETALLES CRÉDITOS GENERALES POR CLIENTE',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(260,7,'LISTADO DE DETALLES CRÉDITOS PAGADOS POR CLIENTE',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(260,7,'LISTADO DE DETALLES CRÉDITOS PEDIENTES POR CLIENTE',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(260,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(260,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(260,5,"Nº DE ".utf8_decode($documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : $reg[0]['documento3']).": ".$reg[0]["dnicliente"]),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"CLIENTE: ".utf8_decode($reg[0]['nomcliente']),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"Nº DE TELEFONO: ".utf8_decode($reg[0]['tlfcliente'] == "" ? "********" : $reg[0]['tlfcliente']),0,0,'L');
    $this->Ln();
    $this->Cell(260,5,"DIRECCIÓN DOMICILIARIA: ".utf8_decode($reg[0]['direccliente'] == "" ? "********" : $reg[0]['direccliente']),0,1,'L');
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº DE VENTA',1,0,'C', True);
    $this->Cell(20,8,'STATUS',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIÓN',1,0,'C', True);
    $this->Cell(65,8,'DETALLES DE PRODUCTOS',1,0,'C', True);
    $this->Cell(35,8,'TOTAL IMPORTE',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONO',1,0,'C', True);
    $this->Cell(30,8,'TOTAL DEBE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,20,30,65,35,35,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte=0;
    $TotalAbono=0;
    $TotalDebe=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $detalles = str_replace("<br>","\n", $reg[$i]['detalles_productos']);
    
    $TotalImporte+=$reg[$i]['totalpago'];
    $TotalAbono+=$reg[$i]['creditopagado'];
    $TotalDebe+=$reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode(substr($reg[$i]["tipodocumento"], 0, 1)."".$reg[$i]["codfactura"]),utf8_decode($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE" ? "VENCIDA" : $reg[$i]["statusventa"]),
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaventa']))),portales(utf8_decode($detalles)),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['creditopagado'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 2, '.', ','))));
   }
 }
   
    $this->Cell(160,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalAbono, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalDebe, 2, '.', ',')),0,0,'L');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(140,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(130,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR DETALLES CREDITOS POR CLIENTES #########################

############################### REPORTES DE CREDITOS ###############################










































############################## REPORTES DE NOTAS DE CREDITOS ##################################

########################## FUNCION NOTA CREDITO (FACTURA) ##############################
function NotaCredito()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);

    $tra = new Login();
    $reg = $tra->NotasCreditoPorId();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
   
    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 10, 4.5, 30, 10, "PNG");
    $this->Ln(6);

    }
        
    //Bloque datos de empresa
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(5, 15, 42, 21, '1.5', "");
    
    $this->SetFont('Courier','BI',8);
    $this->SetTextColor(3,3,3); // Establece el color del texto (en este caso es Negro)
    $this->SetXY(5, 15);
    $this->CellFitSpace(42, 5,utf8_decode($reg[0]['nomsucursal']), 0, 1); //Membrete Nro 1

    $this->SetFont('Courier','B',6);
    if($reg[0]['id_provincia']!='0'){
    $this->SetX(5);
    $this->CellFitSpace(42, 3,utf8_decode($provincia = ($reg[0]['provincia'] == '' ? "" : $reg[0]['provincia']." ").$departamento = ($reg[0]['departamento'] == '' ? "" : $reg[0]['departamento']." ")), 0,1);
    }

    $this->SetX(5);
    $this->CellFitSpace(42, 3,$reg[0]['direcsucursal'], 0,1);

    $this->SetXY(5,25);
    $this->CellFitSpace(42, 3,'Nº ACTIVIDAD/GIRO: '.$reg[0]['codgiro'], 0,1);

    $this->SetXY(5,28);
    $this->CellFitSpace(42, 3,'Nº TLF: '.utf8_decode($reg[0]['tlfsucursal']), 0,1);

    $this->SetXY(5,32);
    $this->CellFitSpace(42, 3,utf8_decode($reg[0]['correosucursal']), 0,1);

    //Bloque datos de factura
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(48, 5, 57, 31, '1.5', "");

    $this->SetFont('Courier','B',10);
    $this->SetXY(48, 5);
    $this->Cell(5, 7, 'NOTA DE CRÉDITO', 0 , 0);

    $this->SetXY(48, 9);
    $this->SetFont('Courier','B',7);
    $this->Cell(5, 7, 'Nº DE '.$documento = ($reg[0]['documsucursal'] == '0' ? "REG.:" : $reg[0]['documento'].":"), 0 , 0);
    $this->SetXY(78, 9);
    $this->CellFitSpace(28, 7,utf8_decode($reg[0]['cuitsucursal']), 0, 0);

    $this->SetXY(48, 12);
    $this->SetFont('Courier','B',7);
    $this->Cell(5, 7, 'Nº DE NOTA:', 0 , 0);
    $this->SetXY(78, 12);
    $this->CellFitSpace(28, 7,utf8_decode($reg[0]['codfactura']), 0, 0);

    $this->SetXY(48, 15);
    $this->SetFont('Courier','B',7);
    $this->Cell(5, 7, 'DOCUMENTO MODIFICA:', 0 , 0);
    $this->SetXY(78, 15);
    $this->CellFitSpace(28, 7,$reg[0]['tipodocumento']." Nº ".utf8_decode($reg[0]['facturaventa']), 0, 0);

    $this->SetXY(48, 18);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,"FECHA DE NOTA:", 0, 0);
    $this->SetXY(78, 18);
    $this->Cell(28, 7,date("d-m-Y H:i:s",strtotime($reg[0]['fechanota'])), 0, 0);

    $this->SetXY(48, 21);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,"FECHA DE AUTORIZACIÓN:", 0, 0);
    $this->SetXY(78, 21);
    $this->Cell(28, 7,$fecha = ($reg[0]['fechaautorsucursal'] == '0000-00-00' ? "**********" : date("d-m-Y",strtotime($reg[0]['fechaautorsucursal']))), 0, 0);

    $this->SetXY(48, 24);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,'OBLIGADO A LLEVAR CONTABILIDAD: ', 0 , 0);
    $this->SetXY(90, 24);
    $this->Cell(78, 7,utf8_decode($reg[0]['llevacontabilidad']), 0 , 0);

    $this->SetXY(48, 27);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,'AMBIENTE: ', 0 , 0);
    $this->SetXY(78, 27);
    $this->Cell(28, 7,'PRODUCCIÓN', 0 , 0);

    $this->SetXY(48, 30);
    $this->SetFont('Courier','B',6);
    $this->Cell(5, 7,'EMISIÓN: ', 0 , 0);
    $this->SetXY(78, 30);
    $this->Cell(28, 7,'NORMAL', 0 , 0);
     
    //Bloque datos de cliente
    $this->SetLineWidth(0.3);
    $this->SetFillColor(192);
    $this->RoundedRect(5, 37, 100, 10, '1.5', "");
    $this->SetFont('Courier','B',6);

    $this->SetXY(6, 38);
    $this->CellFitSpace(66, 3,'RAZÓN SOCIAL: '.$nombre = ($reg[0]['dnicliente'] == '' ? "CONSUMIDOR FINAL" : utf8_decode($reg[0]['nomcliente'])), 0, 0);
    $this->CellFitSpace(32, 3,'Nº DE '.$documento = ($reg[0]['documcliente'] == '' ? "DOC: " : $reg[0]['documento3'].": ").$dni = ($reg[0]['dnicliente'] == '' ? "**********" : $reg[0]['dnicliente']), 0, 0);

    $this->SetXY(6, 41);
    $this->CellFitSpace(66, 3,'GIRO: '.utf8_decode($reg[0]['girocliente'] == '' ? "**********" : $reg[0]['girocliente']), 0, 0);
    $this->CellFitSpace(32, 3,'Nº DE TLF: '.($reg[0]['tlfcliente'] == '' ? "**********" : $reg[0]['tlfcliente']), 0, 0);

    $this->SetXY(6, 44);
    $this->CellFitSpace(98, 3,'DIRECCIÓN: '.utf8_decode($reg[0]['direccliente'] == '' ? "**********" : $reg[0]['direccliente']), 0, 0);

    $this->Ln(4);
    $this->SetX(5);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(5,3,'N°',1,0,'C', True);
    $this->Cell(50,3,'DESCRIPCIÓN',1,0,'C', True);
    $this->Cell(12,3,'CANTIDAD',1,0,'C', True);
    $this->Cell(14,3,'PRECIO',1,0,'C', True);
    $this->Cell(19,3,'IMPORTE',1,1,'C', True);
    
    $tra = new Login();
    $detalle = $tra->VerDetallesNotasCredito();
    $cantidad = 0;
    $SubTotal = 0;

    $this->SetWidths(array(5,50,12,14,19));

    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){ 
    $cantidad += $detalle[$i]['cantventa'];
    $valortotal = $detalle[$i]["precioventa"]*$detalle[$i]["cantventa"];
    $SubTotal += $detalle[$i]['valorneto'];

    $this->SetX(5);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier',"",6);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->RowFacture(array($a++,utf8_decode($detalle[$i]["producto"]),utf8_decode($detalle[$i]['cantventa']),utf8_decode($detalle[$i]["precioventa"]),utf8_decode(number_format($detalle[$i]['valorneto'], 2, '.', ','))));
       
    }

    $this->Ln(1);
    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',8);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'INFORMACIÓN ADICIONAL',1,0,'C');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->SetFont('Courier','B',6);
    $this->CellFitSpace(20,3.5,'SUBTOTAL ',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($SubTotal, 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'CANTIDAD DE PRODUCTOS: '.utf8_decode($cantidad),1,0,'L');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,'GRAVADO ('.number_format($reg[0]["iva"], 2, '.', ',').'%):',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["subtotalivasi"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'TIPO DE DOCUMENTO: NOTA DE CRÉDITO',1,0,'L');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,'EXENTO (0%):',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["subtotalivano"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'FECHA DE EMISIÓN: '.date("d-m-Y H:i:s"),1,0,'L');

    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,$impuesto." (".number_format($reg[0]["iva"], 2, '.', ',')."%):",1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["totaliva"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'DETALLE: '.utf8_decode($reg[0]['observaciones']),1,0,'L');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,'DESCONTADO %:',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["descontado"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'Nº DE CAJA: '.$caja = ($reg[0]['codcaja'] == 0 ? "**********" : $reg[0]['nrocaja'].": ".$reg[0]['nomcaja']),1,0,'L');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->CellFitSpace(20,3.5,'DESC % ('.number_format($reg[0]["descuento"], 2, '.', ',').'%):',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["totaldescuento"], 2, '.', ','),1,0,'R');
    $this->Ln();

    $this->SetX(5);
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont('Courier','B',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(59,3.5,'CAJERO: '.$cajero = ($reg[0]['codcaja'] == 0 ? "**********" : $reg[0]['nombres']),1,0,'L');
    $this->Cell(2,3.5,"",0,0,'C');
    $this->SetFont('Courier','B',6);
    $this->Cell(20,3.5,'IMPORTE TOTAL:',1,0,'L', True);
    $this->CellFitSpace(19,3.5,$simbolo.number_format($reg[0]["totalpago"], 2, '.', ','),1,0,'R');
    $this->Ln(4);
    
    $this->SetX(5);
    $this->SetDrawColor(3,3,3);
    $this->SetFont('Courier','BI',6);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(100,2,'MONTO EN LETRAS: '.utf8_decode(numtoletras(number_format($reg[0]['totalpago'], 2, '.', ''))),0,0,'L');
    $this->Ln();
}  
########################## FUNCION NOTA CREDITO  ##############################     

########################## FUNCION LISTAR NOTAS DE CREDITO ##############################
function TablaListarNotas()
   {
    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->ListarNotasCreditos();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE NOTAS DE CRÉDITOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(35,8,'SUCURSAL',1,0,'C', True);
    $this->Cell(30,8,'Nº CAJA',1,0,'C', True);
    $this->Cell(25,8,'Nº NOTA',1,0,'C', True);
    $this->Cell(30,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(30,8,'CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'OBSERVACIÓN',1,0,'C', True);
    $this->Cell(25,8,'FECHA',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(25,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,30,25,30,30,30,25,35,25,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,portales(utf8_decode($reg[$i]["cuitsucursal"].": ".$reg[$i]["nomsucursal"])),utf8_decode($caja = ($reg[$i]['codcaja'] == '0' ? "**********" : $reg[$i]["nrocaja"].": ".$reg[$i]['nomcaja'])),utf8_decode($reg[$i]["codfactura"]),utf8_decode($reg[$i]['tipodocumento'].": ".$reg[$i]["facturaventa"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]["observaciones"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechanota']))),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
   }
   
    $this->Cell(205,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
        }

    } else {

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº CAJA',1,0,'C', True);
    $this->Cell(25,8,'Nº NOTA',1,0,'C', True);
    $this->Cell(40,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(45,8,'CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'OBSERVACIÓN',1,0,'C', True);
    $this->Cell(25,8,'FECHA',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,25,40,45,30,25,35,30,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($caja = ($reg[$i]['codcaja'] == '0' ? "**********" : $reg[$i]["nrocaja"].": ".$reg[$i]['nomcaja'])),utf8_decode($reg[$i]["codfactura"]),utf8_decode($reg[$i]['tipodocumento'].": ".$reg[$i]["facturaventa"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]["observaciones"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechanota']))),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
   }
   
    $this->Cell(205,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
        }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR NOTAS DE CREDITO ##############################

########################## FUNCION LISTAR NOTAS DE CREDITO X CAJAS ##############################
function TablaListarNotasxCajas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarNotasxCajas();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE NOTAS DE CRÉDITOS POR CAJAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"Nº CAJA: ".utf8_decode($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"RESPONSABLE DE CAJA: ".portales(utf8_decode($reg[0]["nombres"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(25,8,'Nº NOTA',1,0,'C', True);
    $this->Cell(40,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(50,8,'CLIENTE',1,0,'C', True);
    $this->Cell(50,8,'OBSERVACIÓN',1,0,'C', True);
    $this->Cell(30,8,'FECHA',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,25,40,50,50,30,35,30,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codfactura"]),utf8_decode($reg[$i]['tipodocumento'].": ".$reg[$i]["facturaventa"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]["observaciones"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechanota']))),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
   }
   
    $this->Cell(205,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR NOTAS DE CREDITO X CAJAS ##############################

########################## FUNCION LISTAR NOTAS DE CREDITO X FECHAS ##############################
function TablaListarNotasxFechas()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarNotasxFechas();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE NOTAS DE CRÉDITOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº CAJA',1,0,'C', True);
    $this->Cell(25,8,'Nº NOTA',1,0,'C', True);
    $this->Cell(40,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(45,8,'CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'OBSERVACIÓN',1,0,'C', True);
    $this->Cell(25,8,'FECHA',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,25,40,45,30,25,35,30,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($caja = ($reg[$i]['codcaja'] == '0' ? "**********" : $reg[$i]["nrocaja"].": ".$reg[$i]['nomcaja'])),utf8_decode($reg[$i]["codfactura"]),utf8_decode($reg[$i]['tipodocumento'].": ".$reg[$i]["facturaventa"]),utf8_decode($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['nomcliente']),utf8_decode($reg[$i]["observaciones"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechanota']))),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
   }
   
    $this->Cell(205,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(30,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR NOTAS DE CREDITO X FECHAS ##############################

########################## FUNCION LISTAR NOTAS DE CREDITO X CLIENTES ##############################
function TablaListarNotasxClientes()
   {

    $imp = new Login();
    $imp = $imp->ImpuestosPorId();
    $impuesto = ($imp == "" ? "IMPUESTO" : $imp[0]['nomimpuesto']);
    $valor = ($imp == "" ? "0.00" : $imp[0]['valorimpuesto']);
    
    $tra = new Login();
    $reg = $tra->BuscarNotasxClientes();

    ################################# MEMBRETE LEGAL #################################
    if($_SESSION['acceso'] == "administradorG"){

    $logo = ( file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'])." ".utf8_decode($con[0]['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($con[0]['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($con[0]['id_provincia'] == '0' ? "" : $con[0]['provincia'])." ".$departamento = ($con[0]['id_departamento'] == '0' ? "" : $con[0]['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($con[0]['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($con[0]['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    } else {

    $logo = ( file_exists("./fotos/sucursales/".$_SESSION['cuitsucursal'].".png") == "" ? "./assets/images/null.png" : "./fotos/sucursales/".$_SESSION['cuitsucursal'].".png");
    $logo2 = ( file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA
    $this->Cell(90,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['nomsucursal']),0,0,'C');
    $this->Cell(90,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['documsucursal'] == '0' ? "" : $_SESSION['documento'])." ".utf8_decode($_SESSION['cuitsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    if($_SESSION['id_provincia']!='0'){

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($provincia = ($_SESSION['id_provincia'] == '0' ? "" : $_SESSION['provincia'])." ".$departamento = ($_SESSION['id_departamento'] == '0' ? "" : $_SESSION['departamento'])),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['direcsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,"Nº DE TLF: ".utf8_decode($_SESSION['tlfsucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(90,5,"",0,0,'C');
    $this->Cell(155,5,utf8_decode($_SESSION['correosucursal']),0,0,'C');
    $this->Cell(90,5,"",0,0,'C');
    $this->Ln(8);

    }
    ################################# MEMBRETE LEGAL #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE NOTAS DE CRÉDITOS POR CLIENTE',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && $reg != ""){

    $this->Ln();
    $this->Cell(335,5,"Nº ".utf8_decode($reg[0]['documento'])." SUCURSAL: ".utf8_decode($reg[0]["cuitsucursal"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"SUCURSAL: ".portales(utf8_decode($reg[0]["nomsucursal"])),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,5,"ENCARGADO: ".portales(utf8_decode($reg[0]["nomencargado"])),0,0,'L'); 

    }

    $this->Ln();
    $this->Cell(335,5,"Nº DE ".utf8_decode($documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : $reg[0]['documento3']).": ".$reg[0]["dnicliente"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"NOMBRE DE CLIENTE: ".portales(utf8_decode($reg[0]["nomcliente"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"Nº DE TELÉFONO: ".portales(utf8_decode($reg[0]["tlfcliente"] == "" ? "********" : $reg[0]["tlfcliente"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"PROVINCIA: ".portales(utf8_decode($reg[0]["id_provincia"] == "0" ? "********" : $reg[0]["provincia2"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DEPARTAMENTO: ".portales(utf8_decode($reg[0]["id_departamento"] == "0" ? "********" : $reg[0]["departamento2"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"DIRECCIÓN: ".portales(utf8_decode($reg[0]["direccliente"] == "" ? "********" : $reg[0]["direccliente"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"CORREO ELECTRONICO: ".portales(utf8_decode($reg[0]["emailcliente"] == "" ? "********" : $reg[0]["emailcliente"])),0,1,'L');

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(230, 126, 34); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(10,8,'Nº',1,0,'C', True);
    $this->Cell(30,8,'Nº CAJA',1,0,'C', True);
    $this->Cell(30,8,'Nº NOTA',1,0,'C', True);
    $this->Cell(35,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(50,8,'OBSERVACIÓN',1,0,'C', True);
    $this->Cell(45,8,'FECHA',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,$impuesto,1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,'TOTAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,30,35,50,45,35,35,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos=0;
    $TotalSubtotal=0;
    $TotalIva=0;
    $TotalDescuento=0;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos+=$reg[$i]['articulos'];
    $TotalSubtotal+=$reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva+=$reg[$i]['totaliva'];
    $TotalDescuento+=$reg[$i]['totaldescuento'];
    $TotalImporte+=$reg[$i]['totalpago']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($caja = ($reg[$i]['codcaja'] == '0' ? "**********" : $reg[$i]["nrocaja"].": ".$reg[$i]['nomcaja'])),utf8_decode($reg[$i]["codfactura"]),utf8_decode($reg[$i]['tipodocumento'].": ".$reg[$i]["facturaventa"]),utf8_decode($reg[$i]["observaciones"]),utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechanota']))),utf8_decode($simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaliva'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totaldescuento'], 2, '.', ',')),utf8_decode($simbolo.number_format($reg[$i]['totalpago'], 2, '.', ','))));
   }
   
    $this->Cell(200,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalSubtotal, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalIva, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(25,5,utf8_decode($simbolo.number_format($TotalDescuento, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode($simbolo.number_format($TotalImporte, 2, '.', ',')),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR NOTAS DE CREDITO X CLIENTES ##############################

############################## REPORTES DE NOTAS DE CREDITOS ##################################

 // FIN Class PDF
}
?>