<?php
// =======================================================================================================
// === AJUSTES GLOBALES DE CONEXIÓN ===
// =======================================================================================================
define('DB_HOST', 'localhost');
define('DB_USERNAME', 'chopchopcom_abraham');
define('DB_PASSWORD', 'Osito.1852570');

// Mapeo de bases de datos según el código de sucursal
$sucursales_db = [
    1 => ['nombre' => 'San Ignacio', 'db_name' => 'chopchopcom_sanignacio'],
    2 => ['nombre' => 'Sambil Chacao', 'db_name' => 'chopchopcom_chacao'],
    3 => ['nombre' => 'Sambil Candelaria', 'db_name' => 'chopchopcom_lacandelaria']
];

class Db {
    protected $dbh;

    // El constructor ahora recibe el nombre de la base de datos dinámicamente
    public function __construct($db_name){ 
        try{
            // 1. Zona Horaria de la Aplicación PHP
            date_default_timezone_set("America/Caracas");
            
            // 2. Ajustar la Zona Horaria del Servidor MySQL (UTC-4 para Caracas)
            $init_commands = "SET NAMES utf8; SET time_zone = '-04:00';"; 

            // Conexión dinámica usando $db_name
            $conn = new PDO("mysql:host=".DB_HOST.";dbname=".$db_name, DB_USERNAME, DB_PASSWORD,
                array(PDO::MYSQL_ATTR_INIT_COMMAND => $init_commands));
            
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->dbh = $conn;
        }catch(PDOException $e){
            die("Error de Conexión a la DB **".$db_name."**: " . $e->getMessage());
        }
    }
    
    public function DBConsulta($sql) {
        try {
            $stmt = $this->dbh->prepare($sql);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch(PDOException $e) {
            error_log("Error en Consulta SQL en reporte_consolidado: " . $e->getMessage() . " | SQL: " . $sql);
            return [];
        }
    }
}

// ========== CLASE LOGIN (ASUMIENDO QUE EXISTE Y HEREDA LA CONEXIÓN) ==========
class Login extends Db {
    public function __construct($db_name) {
        parent::__construct($db_name);
    }
    public function ExpiraSession() {
        return true; 
    }
}

// INICIO DE SESIÓN Y VERIFICACIÓN DE ACCESO
session_start();
if (!isset($_SESSION['acceso'])) {
    $_SESSION['acceso'] = 'administradorG';
}

// === LÓGICA DEL REPORTE PHP ===

// Definición de variables de fecha y sucursal por defecto
$cod_sucursal_seleccionado = isset($_POST['cod_sucursal']) ? (int)$_POST['cod_sucursal'] : 3; // Default a Sambil Candelaria (3)
$fecha_inicio = isset($_POST['fecha_inicio']) ? $_POST['fecha_inicio'] : date('Y-m-01');
$fecha_fin = isset($_POST['fecha_fin']) ? $_POST['fecha_fin'] : date('Y-m-d');

$datos_detalle = [];
$datos_medios_pago = [];
$total_ventas = 0;
$total_subtotal_general = 0;
$tasa_dia = 0.00; // Tasa por defecto

if(isset($_SESSION['acceso'])) { 
    if ($_SESSION["acceso"]=="administradorG" || $_SESSION["acceso"]=="administradorS" || $_SESSION["acceso"]=="secretaria" || $_SESSION["acceso"]=="cajero") {

// Determinación del DB_NAME a usar
$db_name_seleccionado = $sucursales_db[$cod_sucursal_seleccionado]['db_name'] ?? $sucursales_db[3]['db_name'];
$nombre_sucursal_seleccionada = $sucursales_db[$cod_sucursal_seleccionado]['nombre'] ?? $sucursales_db[3]['nombre'];

// *** LÓGICA ADICIONAL PARA DEFINIR EL NOMBRE DE SALA GENÉRICO (ORDEN LIBRE vs SALÓN PRINCIPAL) ***
$nombre_fallback_sala = 'SALÓN PRINCIPAL';
// Sambil Chacao (2) y Sambil Candelaria (3) usan ORDEN LIBRE como nombre genérico/fallback
if ($cod_sucursal_seleccionado == 2 || $cod_sucursal_seleccionado == 3) {
    $nombre_fallback_sala = 'ORDEN LIBRE';
}
// **********************************************************************************************

// Inicialización de la conexión con el DB_NAME dinámico
$tra = new Login($db_name_seleccionado); 
$ses = $tra->ExpiraSession();          


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Aseguramos que el rango cubra todo el día final
    $fecha_inicio_sql = $fecha_inicio . ' 00:00:00';
    $fecha_fin_sql = $fecha_fin . ' 23:59:59';
    
    $f_ini = $fecha_inicio_sql;
    $f_fin = $fecha_fin_sql;

    // 0. CONSULTA PARA OBTENER LA TASA DEL DÍA (Tomando montocambio)
    $sql_tasa = "
        SELECT 
            montocambio 
        FROM tiposcambio 
        ORDER BY codcambio DESC 
        LIMIT 1
    ";
    $resultado_tasa = $tra->DBConsulta($sql_tasa);
    $tasa_dia = $resultado_tasa[0]['montocambio'] ?? 0.00;

    // Lógica CASE para clasificar el medio de pago
    $case_pago = "
        CASE V.formapago
            WHEN 'Efectivo' THEN 'EFECTIVO BS'
            WHEN 'Cheque' THEN 'PAGO MOVIL'
            WHEN 'Tarjeta de Crédito' THEN 'DEBITO'
            WHEN 'Tarjeta de Débito' THEN 'DEBITO'
            WHEN 'Tarjeta Prepago' THEN 'DEBITO'
            WHEN 'Electronico' THEN 'ZELLE'
            WHEN 'Cupón' THEN 'CONSUMO'
            WHEN 'OTROS' THEN 'EFECTIVO $' 
            ELSE 'CONSUMO' 
        END
    ";
    
    // Usamos UPPER(TRIM(S.nomsala)) para mejor compatibilidad con los nombres de sala. COALESCE convierte NULL a ''
    $nomsala_comparacion = "UPPER(TRIM(COALESCE(S.nomsala, '')))";

    // ** Códigos de mesa (codmesa) que deben ser clasificados con el fallback de la sucursal **
    $mesas_salones_10_porciento = "170, 171, 185, 179, 190, 198"; 

    // ** NOMBRES de sala considerados genéricos que deben incluir el código de mesa **
    $nomsala_genericos_10_porciento = "'SALON PRINCIPAL', 'MESA', 'ORDEN LIBRE'";


    // =====================================================================================
    // Lógica CASE para obtener el PORCENTAJE de Servicio (0%, 10%, 20%)
    // =====================================================================================
    $case_servicio_porcentaje = "
        CASE 
            WHEN {$nomsala_comparacion} = 'YUMMY' THEN 0.20 
            WHEN {$nomsala_comparacion} IN ('DELIVERY', 'PICK UP', 'ORDEN LIBRE') THEN 0.00
            
            -- Para SALÓN PRINCIPAL, VIP, TERRAZA, PRUEBA, y cualquier otra sala registrada es 10%
            WHEN S.nomsala IS NOT NULL THEN 0.10
            
            -- Si no está registrada (FALLBACK DE MESA ESPECÍFICA), usamos la regla del fallback.
            -- El FALLBACK de Chacao/Candelaria es ORDEN LIBRE (0%) y San Ignacio es SALÓN PRINCIPAL (10%)
            WHEN V.codmesa IN ({$mesas_salones_10_porciento}) THEN 
                CASE 
                    WHEN '{$nombre_fallback_sala}' = 'ORDEN LIBRE' THEN 0.00
                    ELSE 0.10
                END
                
            -- FALLBACK FINAL (Usa la regla del nombre de fallback de la sucursal)
            ELSE 
                CASE 
                    WHEN '{$nombre_fallback_sala}' = 'ORDEN LIBRE' THEN 0.00
                    ELSE 0.10
                END
        END
    ";
    
    // =====================================================================================
    // Lógica CASE para clasificar el tipo de Servicio (Genera el NOMBRE y el % en el texto)
    // =====================================================================================
    $case_servicio_nombre = "
        CASE 
            -- 1. 20% Rule (Explícito)
            WHEN {$nomsala_comparacion} = 'YUMMY' THEN 'YUMMY (20%)'
            
            -- 2. DYNAMIC (SALAS CON NOMBRE EN DB)
            WHEN S.nomsala IS NOT NULL THEN
                CASE
                    -- Si es 0% (DELIVERY, PICK UP, ORDEN LIBRE)
                    WHEN {$nomsala_comparacion} IN ('DELIVERY', 'PICK UP', 'ORDEN LIBRE') THEN CONCAT(S.nomsala, ' (0%)')
                    
                    -- Si es 10% (SALON PRINCIPAL, VIP, TERRAZA, MESA, PRUEBA)
                    WHEN {$nomsala_comparacion} IN ({$nomsala_genericos_10_porciento}, 'VIP', 'TERRAZA', 'PRUEBA') THEN 
                        -- Si el nombre es genérico (ORDEN LIBRE/SALON PRINCIPAL/MESA) agregamos la mesa, sino solo el nombre (VIP/TERRAZA/PRUEBA)
                        CASE
                            WHEN {$nomsala_comparacion} IN ({$nomsala_genericos_10_porciento}) THEN CONCAT(S.nomsala, ' (Mesa ', V.codmesa, ') (10%)')
                            ELSE CONCAT(S.nomsala, ' (10%)')
                        END
                    
                    -- Catch-all para cualquier otra sala registrada (asumimos 10%)
                    ELSE CONCAT(S.nomsala, ' (10%)')
                END
            
            -- 3. REGLA DE MESA SIN REGISTRO (Usa el nombre de fallback de la sucursal seleccionada)
            WHEN V.codmesa IN ({$mesas_salones_10_porciento}) THEN 
                CASE 
                    WHEN '{$nombre_fallback_sala}' = 'ORDEN LIBRE' THEN CONCAT('ORDEN LIBRE (Mesa ', V.codmesa, ') (0%)')
                    ELSE CONCAT('SALÓN PRINCIPAL (Mesa ', V.codmesa, ') (10%)')
                END
            
            -- 4. FALLBACK FINAL: Cualquier otra cosa, usa el nombre de fallback de la sucursal.
            ELSE 
                CASE 
                    WHEN '{$nombre_fallback_sala}' = 'ORDEN LIBRE' THEN 'ORDEN LIBRE (0%)'
                    ELSE 'SALÓN PRINCIPAL (10%)'
                END
        END
    ";
    
    // 1. CONSULTA DETALLE DE VENTAS (Haciendo JOIN con la tabla salas)
    $sql_detalle = "
        SELECT 
            V.codventa AS venta_numero, 
            V.totalpago AS monto_usd, 
            V.codmesa AS codmesa, 
            ({$case_servicio_nombre}) AS nombre_servicio,
            ({$case_servicio_porcentaje}) AS porcentaje_servicio,
            TIME(V.fechaventa) AS hora,
            ({$case_pago}) AS medio_pago
        FROM ventas V
        LEFT JOIN salas S ON V.codmesa = S.codsala
        WHERE V.fechaventa BETWEEN '$f_ini' AND '$f_fin'
        ORDER BY V.fechaventa DESC
    ";
    $datos_detalle = $tra->DBConsulta($sql_detalle);

    // 2. CONSULTA RESUMEN POR MEDIO DE PAGO (Se mantiene)
    $sql_medios_pago = "
        SELECT 
            ({$case_pago}) AS mediopago,
            COUNT(idventa) AS total_ventas_por_medio,
            SUM(totalpago) AS monto_acumulado
        FROM ventas V
        WHERE V.fechaventa BETWEEN '$f_ini' AND '$f_fin'
        GROUP BY ({$case_pago})
        ORDER BY monto_acumulado DESC
    ";
    $datos_medios_pago = $tra->DBConsulta($sql_medios_pago);

    // 3. CONSULTA TOTALES GENERALES (Se mantiene)
    $sql_totales = "
        SELECT 
            COUNT(idventa) AS total_ventas,
            SUM(V.subtotalivasi + V.subtotalivano) AS total_subtotal 
        FROM ventas V
        WHERE V.fechaventa BETWEEN '$f_ini' AND '$f_fin'
    ";
    $resultado_totales = $tra->DBConsulta($sql_totales);
    
    $total_ventas = $resultado_totales[0]['total_ventas'] ?? 0;
    $total_subtotal_general = $resultado_totales[0]['total_subtotal'] ?? 0;
}

// CALCULAR SUBTOTAL EN BS
// Nota: La fórmula aquí utiliza totalpago (monto USD con servicio incluido) para los cálculos generales
// En el detalle usamos los subtotales para recalcular con los porcentajes exactos.
$subtotal_general_bs = $total_subtotal_general * $tasa_dia;

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte Consolidado de Ventas</title>
    <style>
        /* Estilos CSS Base */
        body { font-family: Arial, sans-serif; margin: 20px; }
        .container { max-width: 1200px; margin: auto; }
        .filtro-box { margin-bottom: 20px; padding: 15px; border: 1px solid #ccc; border-radius: 5px; background: #f9f9f9; display: flex; align-items: center; justify-content: space-between; flex-wrap: wrap; }
        .filtro-box label, .filtro-box input, .filtro-box select, .filtro-box button { margin-right: 15px; margin-bottom: 10px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .total-box { margin-top: 20px; padding: 15px; border: 2px solid #333; font-weight: bold; }
        .resumen-table-container { width: 45%; margin-top: 20px; float: left; margin-right: 5%; }
        .total-box-container { width: 45%; margin-top: 20px; float: right; }
        .monto { color: #007bff; font-weight: bold; }
        .clearfix::after { content: ""; clear: both; display: table; }
        .tasa-info { margin-bottom: 20px; padding: 10px; border: 1px solid #ffc107; background: #fff3cd; color: #856404; font-weight: bold; }
        .monto-bs { color: #dc3545; font-weight: bold; }
        .servicio-col { font-size: 0.9em; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Reporte Consolidado de Ventas - Sucursal: <?php echo $nombre_sucursal_seleccionada; ?> (DB: <?php echo $db_name_seleccionado; ?>)</h1>
        
        <div class="tasa-info">
            Tasa del Día (USD a Bs): **<?php echo number_format($tasa_dia, 2); ?> Bs**
        </div>

        <div class="filtro-box">
            <form method="POST" style="display: flex; flex-wrap: wrap; align-items: center;">
                <label for="cod_sucursal">Sucursal:</label>
                <select id="cod_sucursal" name="cod_sucursal" required style="padding: 8px;">
                    <option value="1" <?php echo ($cod_sucursal_seleccionado == 1) ? 'selected' : ''; ?>>1 - San Ignacio</option>
                    <option value="2" <?php echo ($cod_sucursal_seleccionado == 2) ? 'selected' : ''; ?>>2 - Sambil Chacao</option>
                    <option value="3" <?php echo ($cod_sucursal_seleccionado == 3) ? 'selected' : ''; ?>>3 - Sambil Candelaria</option>
                </select>
                
                <label for="fecha_inicio">Desde:</label>
                <input type="date" id="fecha_inicio" name="fecha_inicio" value="<?php echo $fecha_inicio; ?>" required>

                <label for="fecha_fin">Hasta:</label>
                <input type="date" id="fecha_fin" name="fecha_fin" value="<?php echo $fecha_fin; ?>" required>

                <button type="submit" name="btn-filtrar" style="padding: 8px 15px;">Filtrar Reporte</button>
            </form>
        </div>

        <?php if ($_SERVER["REQUEST_METHOD"] == "POST") { ?>
            
            <div class="clearfix" style="margin-bottom: 30px;">
                
                <div class="total-box-container" style="border-color: #28a745;">
                    <h3>📊 TOTAL DE VENTAS Y MONTO</h3>
                    <p>Total de Ventas Realizadas: <span class="monto" style="font-size: 1.5em; color: #28a745;">
                        **<?php echo number_format($total_ventas, 0); ?>**</span>
                    </p>
                    <p>Subtotal General Acumulado: <span class="monto" style="font-size: 1.5em; color: #007bff;">
                        $ **<?php echo number_format($total_subtotal_general, 2); ?>**</span>
                    </p>
                     <p>Subtotal General Acumulado en Bs: <span class="monto-bs" style="font-size: 1.5em;">
                        **<?php echo number_format($subtotal_general_bs, 2); ?> Bs**</span>
                    </p>
                </div>

                <div class="resumen-table-container">
                    <h3>💳 Monto Acumulado por Medio de Pago (Clasificación Actual)</h3>
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Medio de Pago Actual</th>
                                <th>Total Ventas</th>
                                <th>Monto Acumulado ($)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (is_array($datos_medios_pago) && count($datos_medios_pago) > 0) {
                                foreach ($datos_medios_pago as $resumen_pago) { ?>
                                <tr>
                                    <td>**<?php echo htmlspecialchars($resumen_pago['mediopago']); ?>**</td>
                                    <td style="text-align: center;"><?php echo number_format($resumen_pago['total_ventas_por_medio'], 0); ?></td>
                                    <td style="text-align: right;" class="monto">$ <?php echo number_format($resumen_pago['monto_acumulado'], 2); ?></td>
                                </tr>
                            <?php } } else { ?>
                                <tr><td colspan="3">No hay datos de pagos en el rango seleccionado.</td></tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                
            </div>
            <div style="clear: both;"></div>

            <h2>Detalle de Ventas (<?php echo $fecha_inicio; ?> al <?php echo $fecha_fin; ?>)</h2>
            <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Venta #</th>
                        <th>Cód. Mesa</th>
                        <th>Servicios</th>
                        <th>Monto ($)</th>
                        <th>Monto (Bs)</th>
                        <th>Monto ($) + Serv</th>
                        <th>Monto (Bs) + Serv</th>
                        <th>Hora</th>
                        <th>Medio de Pago</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (is_array($datos_detalle) && count($datos_detalle) > 0) {
                        foreach ($datos_detalle as $detalle) { 
                            // Montos base (subtotal sin servicio)
                            // Nota: V.totalpago en la base de datos ya incluye el servicio.
                            // Aquí usamos el subtotal del query original ($total_subtotal_general) 
                            // pero el detalle solo nos da V.totalpago.
                            
                            // Asumiremos que V.totalpago es el total (Monto + Servicio)
                            // Para obtener el Monto Base sin Servicio (Monto ($)), debemos despejar:
                            // Monto_total = Monto_base * (1 + Porcentaje_Servicio)
                            // Monto_base = Monto_total / (1 + Porcentaje_Servicio)
                            
                            $porcentaje_servicio = (float)$detalle['porcentaje_servicio'];
                            $monto_usd_serv = (float)$detalle['monto_usd']; // V.totalpago
                            
                            // Cálculo del Monto Base sin Servicio (lo que el cliente pagó por comida/bebida)
                            // Usamos 1.00 para evitar división por cero en caso de que el porcentaje sea NULL/cero,
                            // aunque la lógica de caso lo maneja. Se usa 1 + $porcentaje_servicio.
                            $divisor = 1.00 + $porcentaje_servicio;
                            $monto_usd_base = $monto_usd_serv / $divisor;
                            
                            $monto_bs_base = $monto_usd_base * $tasa_dia;
                            $monto_bs_serv = $monto_usd_serv * $tasa_dia;
                        ?>
                        <tr>
                            <td><?php echo htmlspecialchars($detalle['venta_numero']); ?></td>
                            <td><?php echo htmlspecialchars($detalle['codmesa']); ?></td>
                            <td class="servicio-col"><?php echo htmlspecialchars($detalle['nombre_servicio']); ?></td>
                            <td style="text-align: right;">$ <?php echo number_format($monto_usd_base, 2); ?></td>
                            <td style="text-align: right;">Bs <?php echo number_format($monto_bs_base, 2); ?></td>
                            <td style="text-align: right;" class="monto">$ **<?php echo number_format($monto_usd_serv, 2); ?>**</td>
                            <td style="text-align: right;" class="monto-bs">Bs **<?php echo number_format($monto_bs_serv, 2); ?>**</td>
                            <td><?php echo htmlspecialchars($detalle['hora']); ?></td>
                            <td>**<?php echo htmlspecialchars($detalle['medio_pago']); ?>**</td>
                        </tr>
                    <?php } } else { ?>
                        <tr><td colspan="9">No se encontraron ventas en el rango de fechas seleccionado.</td></tr>
                    <?php } ?>
                </tbody>
            </table>
            </div>
            
        <?php } else { ?>
            <p>Selecciona la sucursal, un rango de fechas y haz clic en "Filtrar Reporte" para ver la información consolidada.</p>
        <?php } ?>

    </div>
</body>
</html>

<?php 
// Cierres de tu script original
} else { ?>    
        <script type='text/javascript' language='javascript'>
        alert('NO TIENES PERMISO PARA ACCEDER A ESTA PAGINA.\nCONSULTA CON...');
        window.location='logout.php';
        </script>
<?php } } else { 
    header("Location: ../index.php"); 
} 
?>